/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.qos.AsyncTokenBucket;
import org.apache.pulsar.broker.qos.AsyncTokenBucketBuilder;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchRateLimiterAsyncTokenBucketImpl
extends DispatchRateLimiter {
    private volatile AsyncTokenBucket dispatchRateLimiterOnMessage;
    private volatile AsyncTokenBucket dispatchRateLimiterOnByte;
    private static final Logger log = LoggerFactory.getLogger(DispatchRateLimiterAsyncTokenBucketImpl.class);

    public DispatchRateLimiterAsyncTokenBucketImpl(PersistentTopic topic, DispatchRateLimiter.Type type) {
        this(topic, null, type);
    }

    public DispatchRateLimiterAsyncTokenBucketImpl(PersistentTopic topic, String subscriptionName, DispatchRateLimiter.Type type) {
        super(topic, subscriptionName, type);
    }

    public DispatchRateLimiterAsyncTokenBucketImpl(BrokerService brokerService) {
        super(brokerService);
    }

    @Override
    public long getAvailableDispatchRateLimitOnMsg() {
        AsyncTokenBucket localDispatchRateLimiterOnMessage = this.dispatchRateLimiterOnMessage;
        return localDispatchRateLimiterOnMessage == null ? -1L : Math.max(localDispatchRateLimiterOnMessage.getTokens(), 0L);
    }

    @Override
    public long getAvailableDispatchRateLimitOnByte() {
        AsyncTokenBucket localDispatchRateLimiterOnByte = this.dispatchRateLimiterOnByte;
        return localDispatchRateLimiterOnByte == null ? -1L : Math.max(localDispatchRateLimiterOnByte.getTokens(), 0L);
    }

    @Override
    public void consumeDispatchQuota(long numberOfMessages, long byteSize) {
        AsyncTokenBucket localDispatchRateLimiterOnMessage = this.dispatchRateLimiterOnMessage;
        if (numberOfMessages > 0L && localDispatchRateLimiterOnMessage != null) {
            localDispatchRateLimiterOnMessage.consumeTokens(numberOfMessages);
        }
        AsyncTokenBucket localDispatchRateLimiterOnByte = this.dispatchRateLimiterOnByte;
        if (byteSize > 0L && localDispatchRateLimiterOnByte != null) {
            localDispatchRateLimiterOnByte.consumeTokens(byteSize);
        }
    }

    @Override
    public boolean isDispatchRateLimitingEnabled() {
        return this.dispatchRateLimiterOnMessage != null || this.dispatchRateLimiterOnByte != null;
    }

    @Override
    public synchronized void updateDispatchRate(DispatchRate dispatchRate) {
        log.info("setting message-dispatch-rate {}", (Object)dispatchRate);
        long msgRate = dispatchRate.getDispatchThrottlingRateInMsg();
        long byteRate = dispatchRate.getDispatchThrottlingRateInByte();
        long ratePeriodNanos = TimeUnit.SECONDS.toNanos(Math.max(dispatchRate.getRatePeriodInSecond(), 1));
        this.dispatchRateLimiterOnMessage = msgRate > 0L ? (dispatchRate.isRelativeToPublishRate() ? this.configureAsyncTokenBucket(AsyncTokenBucket.builderForDynamicRate(), ratePeriodNanos).rateFunction(() -> this.getRelativeDispatchRateInMsg(dispatchRate)).ratePeriodNanosFunction(() -> ratePeriodNanos).build() : this.configureAsyncTokenBucket(AsyncTokenBucket.builder(), ratePeriodNanos).rate(msgRate).ratePeriodNanos(ratePeriodNanos).build()) : null;
        this.dispatchRateLimiterOnByte = byteRate > 0L ? (dispatchRate.isRelativeToPublishRate() ? this.configureAsyncTokenBucket(AsyncTokenBucket.builderForDynamicRate(), ratePeriodNanos).rateFunction(() -> this.getRelativeDispatchRateInByte(dispatchRate)).ratePeriodNanosFunction(() -> ratePeriodNanos).build() : this.configureAsyncTokenBucket(AsyncTokenBucket.builder(), ratePeriodNanos).rate(byteRate).ratePeriodNanos(ratePeriodNanos).build()) : null;
    }

    private <T extends AsyncTokenBucketBuilder<T>> T configureAsyncTokenBucket(T builder, long addTokensResolutionNanos) {
        builder.clock(this.brokerService.getPulsar().getMonotonicClock());
        builder.addTokensResolutionNanos(addTokensResolutionNanos);
        return builder;
    }

    private long getRelativeDispatchRateInMsg(DispatchRate dispatchRate) {
        return this.topic != null && dispatchRate != null ? (long)this.topic.getLastUpdatedAvgPublishRateInMsg() + (long)dispatchRate.getDispatchThrottlingRateInMsg() : 0L;
    }

    private long getRelativeDispatchRateInByte(DispatchRate dispatchRate) {
        return this.topic != null && dispatchRate != null ? (long)this.topic.getLastUpdatedAvgPublishRateInByte() + dispatchRate.getDispatchThrottlingRateInByte() : 0L;
    }

    @Override
    public long getDispatchRateOnMsg() {
        AsyncTokenBucket localDispatchRateLimiterOnMessage = this.dispatchRateLimiterOnMessage;
        return localDispatchRateLimiterOnMessage != null ? localDispatchRateLimiterOnMessage.getRate() : -1L;
    }

    @Override
    public long getDispatchRateOnByte() {
        AsyncTokenBucket localDispatchRateLimiterOnByte = this.dispatchRateLimiterOnByte;
        return localDispatchRateLimiterOnByte != null ? localDispatchRateLimiterOnByte.getRate() : -1L;
    }

    @Override
    public void close() {
        if (this.dispatchRateLimiterOnMessage != null) {
            this.dispatchRateLimiterOnMessage = null;
        }
        if (this.dispatchRateLimiterOnByte != null) {
            this.dispatchRateLimiterOnByte = null;
        }
    }
}

