/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.cache;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.resources.LoadBalanceResources;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.policies.data.ResourceQuota;

public class BundlesQuotas {
    LoadBalanceResources loadBalanceResources;
    static final ResourceQuota INITIAL_QUOTA = new ResourceQuota();

    public BundlesQuotas(PulsarService pulsar) {
        this.loadBalanceResources = pulsar.getPulsarResources().getLoadBalanceResources();
    }

    public CompletableFuture<Void> setDefaultResourceQuota(ResourceQuota quota) {
        return this.loadBalanceResources.getQuotaResources().setWithCreateDefaultQuotaAsync(quota);
    }

    public CompletableFuture<ResourceQuota> getDefaultResourceQuota() {
        return this.loadBalanceResources.getQuotaResources().getDefaultQuota().thenApply(optResourceQuota -> optResourceQuota.orElse(INITIAL_QUOTA));
    }

    public CompletableFuture<Void> setResourceQuota(String bundle, ResourceQuota quota) {
        return this.loadBalanceResources.getQuotaResources().setWithCreateQuotaAsync(bundle, quota);
    }

    public CompletableFuture<Void> setResourceQuota(NamespaceBundle bundle, ResourceQuota quota) {
        return this.setResourceQuota(bundle.toString(), quota);
    }

    public CompletableFuture<ResourceQuota> getResourceQuota(NamespaceBundle bundle) {
        return this.getResourceQuota(bundle.toString());
    }

    public CompletableFuture<ResourceQuota> getResourceQuota(String bundle) {
        return this.loadBalanceResources.getQuotaResources().getQuota(bundle).thenCompose(optResourceQuota -> {
            if (optResourceQuota.isPresent()) {
                return CompletableFuture.completedFuture((ResourceQuota)optResourceQuota.get());
            }
            return this.getDefaultResourceQuota();
        });
    }

    public CompletableFuture<Void> resetResourceQuota(NamespaceBundle bundle) {
        return this.loadBalanceResources.getQuotaResources().deleteQuota(bundle.toString());
    }

    static {
        INITIAL_QUOTA.setMsgRateIn(40.0);
        INITIAL_QUOTA.setMsgRateOut(120.0);
        INITIAL_QUOTA.setBandwidthIn(100000.0);
        INITIAL_QUOTA.setBandwidthOut(300000.0);
        INITIAL_QUOTA.setMemory(80.0);
        INITIAL_QUOTA.setDynamic(true);
    }
}

