/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ActionTargetDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 18595;
  }

  // Properties.
  protected final int actionTargetId;
  protected final PascalString name;
  protected final LocalizedText description;

  public ActionTargetDataType(int actionTargetId, PascalString name, LocalizedText description) {
    super();
    this.actionTargetId = actionTargetId;
    this.name = name;
    this.description = description;
  }

  public int getActionTargetId() {
    return actionTargetId;
  }

  public PascalString getName() {
    return name;
  }

  public LocalizedText getDescription() {
    return description;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ActionTargetDataType");

    // Simple Field (actionTargetId)
    writeSimpleField("actionTargetId", actionTargetId, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (name)
    writeSimpleField("name", name, writeComplex(writeBuffer));

    // Simple Field (description)
    writeSimpleField("description", description, writeComplex(writeBuffer));

    writeBuffer.popContext("ActionTargetDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ActionTargetDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (actionTargetId)
    lengthInBits += 16;

    // Simple field (name)
    lengthInBits += name.getLengthInBits();

    // Simple field (description)
    lengthInBits += description.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("ActionTargetDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int actionTargetId = readSimpleField("actionTargetId", readUnsignedInt(readBuffer, 16));

    PascalString name =
        readSimpleField(
            "name", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    LocalizedText description =
        readSimpleField(
            "description", readComplex(() -> LocalizedText.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("ActionTargetDataType");
    // Create the instance
    return new ActionTargetDataTypeBuilderImpl(actionTargetId, name, description);
  }

  public static class ActionTargetDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final int actionTargetId;
    private final PascalString name;
    private final LocalizedText description;

    public ActionTargetDataTypeBuilderImpl(
        int actionTargetId, PascalString name, LocalizedText description) {
      this.actionTargetId = actionTargetId;
      this.name = name;
      this.description = description;
    }

    public ActionTargetDataType build() {
      ActionTargetDataType actionTargetDataType =
          new ActionTargetDataType(actionTargetId, name, description);
      return actionTargetDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ActionTargetDataType)) {
      return false;
    }
    ActionTargetDataType that = (ActionTargetDataType) o;
    return (getActionTargetId() == that.getActionTargetId())
        && (getName() == that.getName())
        && (getDescription() == that.getDescription())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getActionTargetId(), getName(), getDescription());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
