/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ApduDataOther extends ApduData implements Message {

  // Accessors for discriminator values.
  public Byte getApciType() {
    return (byte) 0xF;
  }

  // Properties.
  protected final ApduDataExt extendedApdu;

  public ApduDataOther(ApduDataExt extendedApdu) {
    super();
    this.extendedApdu = extendedApdu;
  }

  public ApduDataExt getExtendedApdu() {
    return extendedApdu;
  }

  @Override
  protected void serializeApduDataChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ApduDataOther");

    // Simple Field (extendedApdu)
    writeSimpleField("extendedApdu", extendedApdu, writeComplex(writeBuffer));

    writeBuffer.popContext("ApduDataOther");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ApduDataOther _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (extendedApdu)
    lengthInBits += extendedApdu.getLengthInBits();

    return lengthInBits;
  }

  public static ApduDataBuilder staticParseApduDataBuilder(ReadBuffer readBuffer, Short dataLength)
      throws ParseException {
    readBuffer.pullContext("ApduDataOther");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ApduDataExt extendedApdu =
        readSimpleField(
            "extendedApdu",
            readComplex(
                () -> ApduDataExt.staticParse(readBuffer, (short) (dataLength)), readBuffer));

    readBuffer.closeContext("ApduDataOther");
    // Create the instance
    return new ApduDataOtherBuilderImpl(extendedApdu);
  }

  public static class ApduDataOtherBuilderImpl implements ApduData.ApduDataBuilder {
    private final ApduDataExt extendedApdu;

    public ApduDataOtherBuilderImpl(ApduDataExt extendedApdu) {
      this.extendedApdu = extendedApdu;
    }

    public ApduDataOther build() {
      ApduDataOther apduDataOther = new ApduDataOther(extendedApdu);
      return apduDataOther;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ApduDataOther)) {
      return false;
    }
    ApduDataOther that = (ApduDataOther) o;
    return (getExtendedApdu() == that.getExtendedApdu()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getExtendedApdu());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
