/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.ttf.gsub.DefaultGsubWorker;
import org.apache.fontbox.ttf.gsub.GsubWorker;
import org.apache.fontbox.ttf.gsub.GsubWorkerForBengali;
import org.apache.fontbox.ttf.gsub.GsubWorkerForDevanagari;
import org.apache.fontbox.ttf.gsub.GsubWorkerForGujarati;
import org.apache.fontbox.ttf.gsub.GsubWorkerForLatin;
import org.apache.fontbox.ttf.model.GsubData;

public class GsubWorkerFactory {
    private static final Log LOG = LogFactory.getLog(GsubWorkerFactory.class);

    public GsubWorker getGsubWorker(CmapLookup cmapLookup, GsubData gsubData) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Language: " + (Object)((Object)gsubData.getLanguage())));
        }
        switch (gsubData.getLanguage()) {
            case BENGALI: {
                return new GsubWorkerForBengali(cmapLookup, gsubData);
            }
            case DEVANAGARI: {
                return new GsubWorkerForDevanagari(cmapLookup, gsubData);
            }
            case GUJARATI: {
                return new GsubWorkerForGujarati(cmapLookup, gsubData);
            }
            case LATIN: {
                return new GsubWorkerForLatin(cmapLookup, gsubData);
            }
        }
        return new DefaultGsubWorker();
    }
}

