---
title: Monitoring with Prometheus
summary: A Simple recipe to monitor Ozone using Prometheus
linktitle: Prometheus
---
<!---
  Licensed to the Apache Software Foundation (ASF) under one or more
  contributor license agreements.  See the NOTICE file distributed with
  this work for additional information regarding copyright ownership.
  The ASF licenses this file to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->

[Prometheus](https://prometheus.io/) is an open-source monitoring server developed under under the [Cloud Native Computing Foundation](https://www.cncf.io/).

Ozone supports Prometheus out of the box. The servers start a prometheus
compatible metrics endpoint where all the available hadoop metrics are published in prometheus exporter format.

## Prerequisites

 1. [Install the and start]({{< ref "start/RunningViaDocker.md" >}}) an Ozone cluster.
 2. [Download](https://prometheus.io/download/#prometheus) the prometheus binary.

## Monitoring with prometheus

* To enable the Prometheus metrics endpoint you need to add a new configuration to the `ozone-site.xml` file.

 ```xml
  <property>
    <name>hdds.prometheus.endpoint.enabled</name>
    <value>true</value>
  </property>
```

_Note_: for Docker compose based pseudo cluster put the \
`OZONE-SITE.XML_hdds.prometheus.endpoint.enabled=true` line to the `docker-config` file.

* Restart the Ozone Manager and Storage Container Manager and check the prometheus endpoints:

 * http://scm:9876/prom

 * http://ozoneManager:9874/prom

* Create a prometheus.yaml configuration with the previous endpoints:

```yaml
global:
  scrape_interval: 15s

scrape_configs:
  - job_name: ozone
    metrics_path: /prom
    static_configs:
     - targets:
        - "scm:9876"
        - "ozoneManager:9874"
```

* Start with prometheus from the directory where you have the prometheus.yaml file:

```bash
prometheus
```

* Check the active targets in the prometheus web-ui:

http://localhost:9090/targets

![Prometheus target page example](prometheus.png)


* Check any metrics on the prometheus web ui.\
For example:

http://localhost:9090/graph?g0.range_input=1h&g0.expr=om_metrics_num_key_allocate&g0.tab=1

![Prometheus metrics page example](prometheus-key-allocate.png)

## Note

The ozone distribution contains a ready-to-use, dockerized environment to try out ozone and Prometheus. It can be found under `compose/ozone` directory.

```bash
cd compose/ozone
export COMPOSE_FILE=docker-compose.yaml:monitoring.yaml
docker-compose up -d
```
