/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.util;

import java.util.regex.Pattern;

public class NumberParsing {
    private static final String OptionalSign = "[\\-\\+]?";
    private static final String Infinity = "(Infinity)";
    private static final String NotANumber = "(NaN)";
    private static final String Base10Digits = "\\d+";
    private static final String Base10Decimal = "\\.\\d+";
    private static final String OptionalBase10Decimal = "\\.\\d+?";
    private static final String Base10Exponent = "[eE][\\-\\+]?\\d+";
    private static final String OptionalBase10Exponent = "([eE][\\-\\+]?\\d+)?";
    private static final String HexIdentifier = "0[xX]";
    private static final String HexDigits = "[0-9a-fA-F]+";
    private static final String HexDecimal = "\\.[0-9a-fA-F]+";
    private static final String OptionalHexDecimal = "\\.[0-9a-fA-F]+?";
    private static final String HexExponent = "[pP][\\-\\+]?\\d+";
    private static final String OptionalHexExponent = "([pP][\\-\\+]?\\d+)?";
    private static final String doubleRegex = "[\\-\\+]?((Infinity)|(NaN)|(\\d+\\.\\d+)|(\\d+\\.\\d+?[eE][\\-\\+]?\\d+)|(\\.\\d+([eE][\\-\\+]?\\d+)?)|(0[xX][0-9a-fA-F]+\\.?[pP][\\-\\+]?\\d+)|(0[xX][0-9a-fA-F]+\\.[0-9a-fA-F]+?[pP][\\-\\+]?\\d+)|(0[xX]\\.[0-9a-fA-F]+([pP][\\-\\+]?\\d+)?))";
    private static final String numberRegex = "[\\-\\+]?(\\d+|0[xX][0-9a-fA-F]+)";
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[\\-\\+]?((Infinity)|(NaN)|(\\d+\\.\\d+)|(\\d+\\.\\d+?[eE][\\-\\+]?\\d+)|(\\.\\d+([eE][\\-\\+]?\\d+)?)|(0[xX][0-9a-fA-F]+\\.?[pP][\\-\\+]?\\d+)|(0[xX][0-9a-fA-F]+\\.[0-9a-fA-F]+?[pP][\\-\\+]?\\d+)|(0[xX]\\.[0-9a-fA-F]+([pP][\\-\\+]?\\d+)?))");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[\\-\\+]?(\\d+|0[xX][0-9a-fA-F]+)");

    private NumberParsing() {
    }

    public static ParseResultType parse(String input) {
        if (NUMBER_PATTERN.matcher(input).matches()) {
            return ParseResultType.WHOLE_NUMBER;
        }
        if (DOUBLE_PATTERN.matcher(input).matches()) {
            return ParseResultType.DECIMAL;
        }
        return ParseResultType.NOT_NUMBER;
    }

    public static enum ParseResultType {
        NOT_NUMBER,
        WHOLE_NUMBER,
        DECIMAL;

    }
}

