/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.spi.java.queries.SourceJavadocAttacherImplementation;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class SourceJavadocAttacher {
    private static final Logger LOG = Logger.getLogger(SourceJavadocAttacher.class.getName());

    private SourceJavadocAttacher() {
    }

    public static void attachSources(@NonNull URL root, @NullAllowed AttachmentListener listener) {
        SourceJavadocAttacher.attach(root, listener, 0, null);
    }

    public static void attachSources(@NonNull URL root, @NonNull Lookup context, @NullAllowed AttachmentListener listener) {
        SourceJavadocAttacher.attach(root, listener, 0, context);
    }

    public static void attachJavadoc(@NonNull URL root, @NullAllowed AttachmentListener listener) {
        SourceJavadocAttacher.attach(root, listener, 1, null);
    }

    public static void attachJavadoc(@NonNull URL root, @NonNull Lookup context, @NullAllowed AttachmentListener listener) {
        SourceJavadocAttacher.attach(root, listener, 1, context);
    }

    private static void attach(URL root, @NullAllowed AttachmentListener aListener, int mode, Lookup context) {
        Parameters.notNull("root", root);
        AttachmentListener listener = aListener != null ? aListener : new AttachmentListener(){

            @Override
            public void attachmentSucceeded() {
            }

            @Override
            public void attachmentFailed() {
            }
        };
        Lookup attacherLookup = context == null ? Lookup.getDefault() : new ProxyLookup(context, Lookup.getDefault());
        new AttacherExecution(mode, root, attacherLookup, listener).run();
    }

    public static interface AttachmentListener {
        public void attachmentSucceeded();

        public void attachmentFailed();
    }

    private static class AttacherExecution
    implements AttachmentListener,
    Runnable {
        private final Lookup lkp;
        private final int mode;
        private final URL root;
        private final AttachmentListener delegate;
        private final List<? extends SourceJavadocAttacherImplementation> attachers;
        private int index;
        private int attempts;
        private boolean currentHandles;

        public AttacherExecution(int mode, URL root, Lookup lkp, AttachmentListener delegate) {
            this.mode = mode;
            this.root = root;
            this.delegate = delegate;
            this.lkp = lkp;
            this.attachers = new ArrayList<SourceJavadocAttacherImplementation>(lkp.lookupAll(SourceJavadocAttacherImplementation.class));
        }

        @Override
        public void attachmentSucceeded() {
            if (this.delegate != null) {
                this.delegate.attachmentSucceeded();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void attachmentFailed() {
            if (this.isEmpty()) {
                if (this.delegate != null) {
                    int a;
                    AttacherExecution attacherExecution = this;
                    synchronized (attacherExecution) {
                        a = this.attempts;
                    }
                    LOG.log(Level.FINE, "No provider from {2} invoked ({3} total) succeeded attaching of {0} to root: {1}", new Object[]{this.mode == 0 ? "sources" : "javadoc", this.root, a, this.attachers.size()});
                    this.delegate.attachmentFailed();
                }
                return;
            }
            this.run();
        }

        synchronized boolean isEmpty() {
            return this.index >= this.attachers.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int pos = this.index;
            while (pos < this.attachers.size()) {
                SourceJavadocAttacherImplementation attacher = this.attachers.get(pos++);
                AttacherExecution attacherExecution = this;
                synchronized (attacherExecution) {
                    this.index = pos;
                    ++this.attempts;
                    Lookups.executeWith(this.lkp, () -> {
                        try {
                            this.currentHandles = this.mode == 0 ? attacher.attachSources(this.root, this) : attacher.attachJavadoc(this.root, this);
                        }
                        catch (IOException ioe) {
                            LOG.log(Level.WARNING, "Attacher {1} failed for {0}", new Object[]{this.root, attacher.getClass().getName()});
                            LOG.log(Level.WARNING, "Thrown exception: ", ioe);
                        }
                    });
                }
                if (this.currentHandles) {
                    LOG.log(Level.FINE, "Attaching of {0} to root: {1} handled by: {2}", new Object[]{this.mode == 0 ? "sources" : "javadoc", this.root, attacher.getClass().getName()});
                    LOG.log(Level.FINE, "Remaingin attachers: {0}", this.attachers.subList(pos, this.attachers.size()));
                    return;
                }
                --this.attempts;
            }
        }
    }
}

