/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.util;

import java.lang.ref.WeakReference;
import jpt.sun.tools.javac.util.Assert;
import jpt.sun.tools.javac.util.Convert;
import jpt.sun.tools.javac.util.InvalidUtfException;
import jpt.sun.tools.javac.util.Name;
import jpt.sun.tools.javac.util.Names;
import jpt.sun.tools.javac.util.Utf8NameTable;

public class UnsharedNameTable
extends Utf8NameTable {
    private HashEntry[] hashes = null;
    private int hashMask;
    public int index;

    public static UnsharedNameTable create(Names names) {
        return new UnsharedNameTable(names);
    }

    public UnsharedNameTable(Names names, int hashSize) {
        super(names);
        if (Integer.bitCount(hashSize) != 1) {
            throw new IllegalArgumentException();
        }
        this.hashMask = hashSize - 1;
        this.hashes = new HashEntry[hashSize];
    }

    public UnsharedNameTable(Names names) {
        this(names, 32768);
    }

    @Override
    public Name fromChars(char[] cs, int start, int len) {
        byte[] name = new byte[len * 3];
        int nbytes = Convert.chars2utf(cs, start, name, 0, len);
        return this.fromValidUtf(name, 0, nbytes);
    }

    @Override
    public Name fromUtf(byte[] cs, int start, int len, Convert.Validation validation) throws InvalidUtfException {
        if (validation != Convert.Validation.NONE) {
            Convert.utfValidate(cs, start, len, validation);
        }
        return this.fromValidUtf(cs, start, len);
    }

    private Name fromValidUtf(byte[] cs, int start, int len) {
        int h = UnsharedNameTable.hashValue(cs, start, len) & this.hashMask;
        HashEntry element = this.hashes[h];
        NameImpl n = null;
        HashEntry previousNonNullTableEntry = null;
        HashEntry firstTableEntry = element;
        while (element != null) {
            n = (NameImpl)element.get();
            if (n == null) {
                if (firstTableEntry == element) {
                    this.hashes[h] = firstTableEntry = element.next;
                } else {
                    Assert.checkNonNull(previousNonNullTableEntry, "previousNonNullTableEntry cannot be null here.");
                    previousNonNullTableEntry.next = element.next;
                }
            } else {
                if (n.getByteLength() == len && UnsharedNameTable.equals(n.bytes, 0, cs, start, len)) {
                    return n;
                }
                previousNonNullTableEntry = element;
            }
            element = element.next;
        }
        byte[] bytes = new byte[len];
        System.arraycopy(cs, start, bytes, 0, len);
        n = new NameImpl(this, bytes, this.index++);
        HashEntry newEntry = new HashEntry(n);
        if (previousNonNullTableEntry == null) {
            this.hashes[h] = newEntry;
        } else {
            Assert.checkNull((Object)previousNonNullTableEntry.next, "previousNonNullTableEntry.next must be null.");
            previousNonNullTableEntry.next = newEntry;
        }
        return n;
    }

    @Override
    public void dispose() {
        this.hashes = null;
    }

    static class HashEntry
    extends WeakReference<NameImpl> {
        HashEntry next;

        HashEntry(NameImpl referent) {
            super(referent);
        }
    }

    static final class NameImpl
    extends Utf8NameTable.NameImpl {
        final byte[] bytes;
        final int index;

        NameImpl(UnsharedNameTable table, byte[] bytes, int index) {
            super(table);
            this.bytes = bytes;
            this.index = index;
        }

        @Override
        protected byte[] getByteData() {
            return this.bytes;
        }

        @Override
        protected int getByteOffset() {
            return 0;
        }

        @Override
        protected int getByteLength() {
            return this.bytes.length;
        }

        @Override
        protected int getNameIndex() {
            return this.index;
        }
    }
}

