/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.DecorationPosition;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.SupportsAutoSpacing;
import org.apache.myfaces.tobago.component.SupportsDecorationPosition;
import org.apache.myfaces.tobago.component.SupportsHelp;
import org.apache.myfaces.tobago.internal.component.AbstractUIButton;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.component.AbstractUIOut;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectOneChoice;
import org.apache.myfaces.tobago.internal.renderkit.renderer.LabelLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.ResourceUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public abstract class DecorationPositionRendererBase<T extends UIComponent & SupportsAutoSpacing>
extends LabelLayoutRendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        if (this.isInside(facesContext, HtmlElements.COMMAND)) {
            this.encodeBeginField(facesContext, component);
        } else {
            super.encodeBeginInternal(facesContext, component);
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        if (this.isInside(facesContext, HtmlElements.COMMAND)) {
            this.encodeEndField(facesContext, component);
        } else {
            super.encodeEndInternal(facesContext, component);
        }
    }

    @Override
    public void encodeBeginMessageField(FacesContext facesContext, T component) throws IOException {
        String help;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Integer tabIndex = component instanceof AbstractUIInput ? ((AbstractUIInput)component).getTabIndex() : null;
        SupportsDecorationPosition supportsDecorationPosition = component instanceof SupportsDecorationPosition ? (SupportsDecorationPosition)component : null;
        DecorationPosition helpPosition = supportsDecorationPosition != null ? supportsDecorationPosition.getHelpPosition() : DecorationPosition.none;
        String string = help = component instanceof SupportsHelp ? ((SupportsHelp)component).getHelp() : null;
        if (!StringUtils.isEmpty(help)) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(TobagoClass.HELP__CONTAINER, TobagoClass.valueOf(helpPosition));
            writer.writeAttribute(DataAttributes.HELP, help, true);
            switch (helpPosition) {
                case buttonLeft: {
                    String title = ResourceUtils.getString(facesContext, "help.title");
                    this.encodePopover(writer, BootstrapClass.BTN_OUTLINE_INFO, Icons.QUESTION_LG, title, help, tabIndex);
                    break;
                }
                case textTop: {
                    writer.startElement(HtmlElements.DIV);
                    writer.writeClassAttribute(BootstrapClass.HELP_FEEDBACK);
                    writer.writeText(help);
                    writer.endElement(HtmlElements.DIV);
                }
            }
        }
        DecorationPosition messagePosition = supportsDecorationPosition != null ? supportsDecorationPosition.getMessagePosition() : DecorationPosition.none;
        String clientId = component.getClientId();
        List messages = facesContext.getMessageList(clientId);
        String message = this.getMessage(messages);
        FacesMessage.Severity severity = ComponentUtils.getMaximumSeverity(messages);
        if (!StringUtils.isEmpty(message)) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(TobagoClass.MESSAGES__CONTAINER, TobagoClass.valueOf(messagePosition));
            writer.writeAttribute(DataAttributes.FACES_MESSAGE, message, true);
            switch (messagePosition) {
                case buttonLeft: {
                    CssItem buttonColor = BootstrapClass.buttonColor(severity);
                    this.encodePopover(writer, buttonColor, Icons.EXCLAMATION_LG, this.getTitle(facesContext, messages), message, tabIndex);
                    break;
                }
                case textTop: {
                    CssItem feedback = BootstrapClass.feedbackColor(severity);
                    writer.startElement(HtmlElements.DIV);
                    writer.writeClassAttribute(feedback);
                    writer.writeText(message);
                    writer.endElement(HtmlElements.DIV);
                }
            }
        }
        this.encodeBeginField(facesContext, component);
    }

    @Override
    public void encodeEndMessageField(FacesContext facesContext, T component) throws IOException {
        String help;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Integer tabIndex = component instanceof AbstractUIInput ? ((AbstractUIInput)component).getTabIndex() : null;
        SupportsDecorationPosition supportsDecorationPosition = component instanceof SupportsDecorationPosition ? (SupportsDecorationPosition)component : null;
        this.encodeEndField(facesContext, component);
        DecorationPosition messagePosition = supportsDecorationPosition != null ? supportsDecorationPosition.getMessagePosition() : DecorationPosition.none;
        String clientId = component.getClientId();
        List messages = facesContext.getMessageList(clientId);
        String message = this.getMessage(messages);
        FacesMessage.Severity severity = ComponentUtils.getMaximumSeverity(messages);
        if (!StringUtils.isEmpty(message)) {
            switch (messagePosition) {
                case buttonRight: {
                    CssItem buttonColor = BootstrapClass.buttonColor(severity);
                    this.encodePopover(writer, buttonColor, Icons.EXCLAMATION_LG, this.getTitle(facesContext, messages), message, tabIndex);
                    break;
                }
                case tooltip: {
                    CssItem tooltip = BootstrapClass.tooltipColor(severity);
                    writer.startElement(HtmlElements.DIV);
                    writer.writeClassAttribute(tooltip);
                    writer.writeText(message);
                    writer.endElement(HtmlElements.DIV);
                    break;
                }
                case textBottom: {
                    CssItem feedback = BootstrapClass.feedbackColor(severity);
                    writer.startElement(HtmlElements.DIV);
                    writer.writeClassAttribute(feedback);
                    writer.writeText(message);
                    writer.endElement(HtmlElements.DIV);
                }
            }
            writer.endElement(HtmlElements.DIV);
        }
        DecorationPosition helpPosition = supportsDecorationPosition != null ? supportsDecorationPosition.getHelpPosition() : DecorationPosition.none;
        String title = ResourceUtils.getString(facesContext, "help.title");
        String string = help = component instanceof SupportsHelp ? ((SupportsHelp)component).getHelp() : null;
        if (!StringUtils.isEmpty(help)) {
            switch (helpPosition) {
                case buttonRight: {
                    this.encodePopover(writer, BootstrapClass.BTN_OUTLINE_INFO, Icons.QUESTION_LG, title, help, tabIndex);
                    break;
                }
                case tooltip: {
                    writer.startElement(HtmlElements.DIV);
                    writer.writeClassAttribute(BootstrapClass.HELP_TOOLTIP);
                    writer.writeText(help);
                    writer.endElement(HtmlElements.DIV);
                    break;
                }
                case textBottom: {
                    writer.startElement(HtmlElements.DIV);
                    writer.writeClassAttribute(BootstrapClass.HELP_FEEDBACK);
                    writer.writeText(help);
                    writer.endElement(HtmlElements.DIV);
                }
            }
            writer.endElement(HtmlElements.DIV);
        }
    }

    protected abstract void encodeBeginField(FacesContext var1, T var2) throws IOException;

    protected abstract void encodeEndField(FacesContext var1, T var2) throws IOException;

    private String getTitle(FacesContext facesContext, List<FacesMessage> messages) {
        int fatalCount = 0;
        int errorCount = 0;
        int warningCount = 0;
        int informationCount = 0;
        String fatal = ResourceUtils.getString(facesContext, "severity.fatal");
        String error = ResourceUtils.getString(facesContext, "severity.error");
        String warn = ResourceUtils.getString(facesContext, "severity.warn");
        String info = ResourceUtils.getString(facesContext, "severity.info");
        for (FacesMessage message : messages) {
            if (FacesMessage.SEVERITY_FATAL.equals(message.getSeverity())) {
                ++fatalCount;
                continue;
            }
            if (FacesMessage.SEVERITY_ERROR.equals(message.getSeverity())) {
                ++errorCount;
                continue;
            }
            if (FacesMessage.SEVERITY_WARN.equals(message.getSeverity())) {
                ++warningCount;
                continue;
            }
            if (!FacesMessage.SEVERITY_INFO.equals(message.getSeverity())) continue;
            ++informationCount;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (messages.size() > 1) {
            if (fatalCount > 0) {
                stringBuilder.append(fatal).append(" (").append(fatalCount).append(")");
                if (errorCount + warningCount + informationCount > 0) {
                    stringBuilder.append(", ");
                }
            }
            if (errorCount > 0) {
                stringBuilder.append(error).append(" (").append(errorCount).append(")");
                if (warningCount + informationCount > 0) {
                    stringBuilder.append(", ");
                }
            }
            if (warningCount > 0) {
                stringBuilder.append(warn).append(" (").append(warningCount).append(")");
                if (informationCount > 0) {
                    stringBuilder.append(", ");
                }
            }
            if (informationCount > 0) {
                stringBuilder.append(info).append(" (").append(informationCount).append(")");
            }
        } else if (fatalCount == 1) {
            stringBuilder.append(fatal);
        } else if (errorCount == 1) {
            stringBuilder.append(error);
        } else if (warningCount == 1) {
            stringBuilder.append(warn);
        } else if (informationCount == 1) {
            stringBuilder.append(info);
        }
        return stringBuilder.toString();
    }

    private String getMessage(List<FacesMessage> messages) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean firstMessage = true;
        for (FacesMessage message : messages) {
            if (firstMessage) {
                firstMessage = false;
            } else {
                stringBuilder.append("\n\n");
            }
            stringBuilder.append(message.getDetail());
        }
        return stringBuilder.toString();
    }

    private void encodePopover(TobagoResponseWriter writer, CssItem buttonColor, Icons icon, String title, String content, Integer tabIndex) throws IOException {
        writer.startElement(HtmlElements.TOBAGO_POPOVER);
        writer.writeAttribute(DataAttributes.BS_TOGGLE, "popover", false);
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.writeAttribute(DataAttributes.BS_CONTENT, content, true);
        writer.writeAttribute(DataAttributes.BS_TRIGGER, "focus", false);
        writer.startElement(HtmlElements.A);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, tabIndex != null ? tabIndex : 0);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.ROLE, HtmlButtonTypes.BUTTON);
        writer.writeClassAttribute(BootstrapClass.BTN, buttonColor);
        writer.startElement(HtmlElements.I);
        writer.writeClassAttribute(icon);
        writer.endElement(HtmlElements.I);
        writer.endElement(HtmlElements.A);
        writer.endElement(HtmlElements.TOBAGO_POPOVER);
    }

    protected void encodeGroupAddon(FacesContext facesContext, TobagoResponseWriter writer, UIComponent addon, boolean isAfterFacet) throws IOException {
        if (addon != null) {
            for (UIComponent child : RenderUtils.getFacetChildren(addon)) {
                this.insideBegin(facesContext, isAfterFacet ? Facets.after : Facets.before);
                if (child instanceof AbstractUIButton) {
                    child.encodeAll(facesContext);
                } else if (child instanceof AbstractUIOut) {
                    child.encodeAll(facesContext);
                } else if (child instanceof AbstractUISelectOneChoice) {
                    child.encodeAll(facesContext);
                } else {
                    writer.startElement(HtmlElements.SPAN);
                    writer.writeClassAttribute(BootstrapClass.INPUT_GROUP_TEXT);
                    child.encodeAll(facesContext);
                    writer.endElement(HtmlElements.SPAN);
                }
                this.insideEnd(facesContext, isAfterFacet ? Facets.after : Facets.before);
            }
        }
    }
}

