/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import jakarta.el.ValueExpression;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.Application;
import jakarta.faces.application.ApplicationFactory;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.util.ParametrizableFacesMessage;
import org.apache.myfaces.util.lang.ClassUtils;

public final class MessageUtils {
    private static final String DEFAULT_BUNDLE = "jakarta.faces.Messages";
    private static final String DETAIL_SUFFIX = "_detail";
    private static Logger log = Logger.getLogger(MessageUtils.class.getName());

    private MessageUtils() {
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String messageId, Object arg) {
        return MessageUtils.getMessage(severity, messageId, new Object[]{arg}, FacesContext.getCurrentInstance());
    }

    public static FacesMessage getMessage(String bundleBaseName, FacesMessage.Severity severity, String messageId, Object arg) {
        return MessageUtils.getMessage(bundleBaseName, severity, messageId, new Object[]{arg}, FacesContext.getCurrentInstance());
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String messageId, Object[] args) {
        return MessageUtils.getMessage(severity, messageId, args, FacesContext.getCurrentInstance());
    }

    public static FacesMessage getMessage(String bundleBaseName, FacesMessage.Severity severity, String messageId, Object[] args) {
        return MessageUtils.getMessage(bundleBaseName, severity, messageId, args, FacesContext.getCurrentInstance());
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String messageId, Object[] args, FacesContext facesContext) {
        FacesMessage message = MessageUtils.getMessage(facesContext, messageId, args);
        message.setSeverity(severity);
        return message;
    }

    public static FacesMessage getMessage(String bundleBaseName, FacesMessage.Severity severity, String messageId, Object[] args, FacesContext facesContext) {
        FacesMessage message = MessageUtils.getMessage(bundleBaseName, facesContext, messageId, args);
        message.setSeverity(severity);
        return message;
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args) {
        MessageUtils.addMessage(severity, messageId, args, null, FacesContext.getCurrentInstance());
    }

    public static void addMessage(String bundleBaseName, FacesMessage.Severity severity, String messageId, Object[] args) {
        MessageUtils.addMessage(bundleBaseName, severity, messageId, args, null, FacesContext.getCurrentInstance());
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args, FacesContext facesContext) {
        MessageUtils.addMessage(severity, messageId, args, null, facesContext);
    }

    public static void addMessage(String bundleBaseName, FacesMessage.Severity severity, String messageId, Object[] args, FacesContext facesContext) {
        MessageUtils.addMessage(bundleBaseName, severity, messageId, args, null, facesContext);
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args, String forClientId) {
        MessageUtils.addMessage(severity, messageId, args, forClientId, FacesContext.getCurrentInstance());
    }

    public static void addMessage(String bundleBaseName, FacesMessage.Severity severity, String messageId, Object[] args, String forClientId) {
        MessageUtils.addMessage(bundleBaseName, severity, messageId, args, forClientId, FacesContext.getCurrentInstance());
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args, String forClientId, FacesContext facesContext) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Adding message " + messageId + " for clientId " + forClientId);
        }
        facesContext.addMessage(forClientId, MessageUtils.getMessage(severity, messageId, args, facesContext));
    }

    public static void addMessage(String bundleBaseName, FacesMessage.Severity severity, String messageId, Object[] args, String forClientId, FacesContext facesContext) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Adding message " + messageId + " for clientId " + forClientId);
        }
        facesContext.addMessage(forClientId, MessageUtils.getMessage(bundleBaseName, severity, messageId, args, facesContext));
    }

    public static String substituteParams(Locale locale, String msgtext, Object[] params) {
        String localizedStr = null;
        if (params == null || msgtext == null) {
            return msgtext;
        }
        if (locale != null) {
            MessageFormat mf = new MessageFormat(msgtext, locale);
            localizedStr = mf.format(params);
        }
        return localizedStr;
    }

    public static FacesMessage getMessage(String messageId, Object[] params) {
        Locale locale = MessageUtils.getCurrentLocale();
        return MessageUtils.getMessage(locale, messageId, params);
    }

    public static FacesMessage getMessageFromBundle(String bundleBaseName, String messageId, Object[] params) {
        Locale locale = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null && context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return MessageUtils.getMessageFromBundle(bundleBaseName, context, locale, messageId, params);
    }

    public static FacesMessage getMessage(Locale locale, String messageId, Object[] params) {
        String summary = null;
        String detail = null;
        String bundleName = MessageUtils.getApplication().getMessageBundle();
        ResourceBundle bundle = null;
        ResourceBundle.Control bundleControl = MyfacesConfig.getCurrentInstance().getResourceBundleControl();
        if (bundleName != null) {
            try {
                bundle = bundleControl == null ? ResourceBundle.getBundle(bundleName, locale, ClassUtils.getCurrentLoader((Object)bundleName)) : ResourceBundle.getBundle(bundleName, locale, ClassUtils.getCurrentLoader((Object)bundleName), bundleControl);
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = bundleControl == null ? ResourceBundle.getBundle(DEFAULT_BUNDLE, locale, ClassUtils.getCurrentLoader((Object)DEFAULT_BUNDLE)) : ResourceBundle.getBundle(DEFAULT_BUNDLE, locale, ClassUtils.getCurrentLoader((Object)DEFAULT_BUNDLE), bundleControl);
                if (bundle == null) {
                    throw new NullPointerException();
                }
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            summary = messageId;
        }
        if (bundle == null) {
            throw new NullPointerException("Unable to locate ResourceBundle: bundle is null");
        }
        String detailMessageId = messageId + DETAIL_SUFFIX;
        if (params != null && locale != null) {
            try {
                if (bundle.containsKey(detailMessageId)) {
                    detail = bundle.getString(detailMessageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return new ParametrizableFacesMessage(summary, detail, params, locale);
        }
        summary = MessageUtils.substituteParams(locale, summary, params);
        try {
            if (bundle.containsKey(detailMessageId)) {
                detail = MessageUtils.substituteParams(locale, bundle.getString(detailMessageId), params);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return new FacesMessage(summary, detail);
    }

    public static FacesMessage getMessageFromBundle(String bundleBaseName, FacesContext context, Locale locale, String messageId, Object[] params) {
        String summary = null;
        String detail = null;
        String bundleName = context.getApplication().getMessageBundle();
        ResourceBundle bundle = null;
        ResourceBundle.Control bundleControl = MyfacesConfig.getCurrentInstance().getResourceBundleControl();
        if (bundleName != null) {
            try {
                bundle = bundleControl == null ? ResourceBundle.getBundle(bundleName, locale, ClassUtils.getCurrentLoader((Object)bundleName)) : ResourceBundle.getBundle(bundleName, locale, ClassUtils.getCurrentLoader((Object)bundleName), bundleControl);
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = bundleControl == null ? ResourceBundle.getBundle(bundleBaseName, locale, ClassUtils.getCurrentLoader((Object)bundleBaseName)) : ResourceBundle.getBundle(bundleBaseName, locale, ClassUtils.getCurrentLoader((Object)bundleBaseName), bundleControl);
                if (bundle == null) {
                    throw new NullPointerException();
                }
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = bundleControl == null ? ResourceBundle.getBundle(DEFAULT_BUNDLE, locale, ClassUtils.getCurrentLoader((Object)DEFAULT_BUNDLE)) : ResourceBundle.getBundle(DEFAULT_BUNDLE, locale, ClassUtils.getCurrentLoader((Object)DEFAULT_BUNDLE), bundleControl);
                if (bundle == null) {
                    throw new NullPointerException();
                }
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            summary = messageId;
        }
        if (bundle == null) {
            throw new NullPointerException("Unable to locate ResourceBundle: bundle is null");
        }
        String detailMessageId = messageId + DETAIL_SUFFIX;
        if (params != null && locale != null) {
            try {
                if (bundle.containsKey(detailMessageId)) {
                    detail = bundle.getString(detailMessageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return new ParametrizableFacesMessage(summary, detail, params, locale);
        }
        summary = MessageUtils.substituteParams(locale, summary, params);
        try {
            if (bundle.containsKey(detailMessageId)) {
                detail = MessageUtils.substituteParams(locale, bundle.getString(detailMessageId), params);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return new FacesMessage(summary, detail);
    }

    public static FacesMessage getMessage(String bundleBaseName, String messageId, Object[] params) {
        return MessageUtils.getMessage(bundleBaseName, MessageUtils.getCurrentLocale(), messageId, params);
    }

    public static Locale getCurrentLocale() {
        return MessageUtils.getCurrentLocale(FacesContext.getCurrentInstance());
    }

    public static Locale getCurrentLocale(FacesContext context) {
        Locale locale;
        if (context != null && context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String bundleBaseName, String messageId, Object[] params) {
        FacesMessage msg = MessageUtils.getMessage(bundleBaseName, messageId, params);
        msg.setSeverity(severity);
        return msg;
    }

    public static FacesMessage getMessage(String bundleBaseName, Locale locale, String messageId, Object[] params) {
        if (bundleBaseName == null) {
            throw new NullPointerException("Unable to locate ResourceBundle: bundle is null");
        }
        ResourceBundle bundle = ResourceBundle.getBundle(bundleBaseName, locale);
        return MessageUtils.getMessage(bundle, messageId, params);
    }

    public static FacesMessage getMessage(ResourceBundle bundle, String messageId, Object[] params) {
        String summary = null;
        String detail = null;
        try {
            if (bundle.containsKey(messageId)) {
                summary = bundle.getString(messageId);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (summary == null) {
            summary = messageId;
        }
        summary = MessageUtils.substituteParams(bundle.getLocale(), summary, params);
        try {
            String detailMessageId = messageId + DETAIL_SUFFIX;
            if (bundle.containsKey(detailMessageId)) {
                detail = MessageUtils.substituteParams(bundle.getLocale(), bundle.getString(detailMessageId), params);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return new FacesMessage(summary, detail);
    }

    public static FacesMessage getMessage(FacesContext context, String messageId) {
        return MessageUtils.getMessage(context, messageId, null);
    }

    public static FacesMessage getMessage(String bundleBaseName, FacesContext context, String messageId) {
        return MessageUtils.getMessage(bundleBaseName, context, messageId, null);
    }

    public static FacesMessage getMessage(FacesContext context, String messageId, Object[] params) {
        if (context == null || messageId == null) {
            throw new NullPointerException(" context " + String.valueOf(context) + " messageId " + messageId);
        }
        Locale locale = MessageUtils.getCurrentLocale(context);
        if (null == locale) {
            throw new NullPointerException(" locale " + String.valueOf(locale));
        }
        FacesMessage message = MessageUtils.getMessage(locale, messageId, params);
        if (message != null) {
            return message;
        }
        locale = Locale.getDefault();
        return MessageUtils.getMessage(locale, messageId, params);
    }

    public static FacesMessage getMessage(String bundleBaseName, FacesContext context, String messageId, Object[] params) {
        if (context == null || messageId == null) {
            throw new NullPointerException(" context " + String.valueOf(context) + " messageId " + messageId);
        }
        Locale locale = MessageUtils.getCurrentLocale(context);
        if (null == locale) {
            throw new NullPointerException(" locale " + String.valueOf(locale));
        }
        FacesMessage message = MessageUtils.getMessageFromBundle(bundleBaseName, context, locale, messageId, params);
        if (message != null) {
            return message;
        }
        locale = Locale.getDefault();
        return MessageUtils.getMessageFromBundle(bundleBaseName, context, locale, messageId, params);
    }

    public static Object getLabel(FacesContext facesContext, UIComponent component) {
        Object label = component.getAttributes().get("label");
        ValueExpression expression = null;
        if (label != null && label instanceof String && ((String)label).length() == 0 && (expression = component.getValueExpression("label")) != null) {
            label = null;
        }
        if (label != null) {
            return label;
        }
        ValueExpression valueExpression = expression = expression == null ? component.getValueExpression("label") : expression;
        if (expression != null) {
            return expression;
        }
        return component.getClientId(facesContext);
    }

    private static Application getApplication() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            return context.getApplication();
        }
        ApplicationFactory afactory = (ApplicationFactory)FactoryFinder.getFactory((String)"jakarta.faces.application.ApplicationFactory");
        return afactory.getApplication();
    }
}

