/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.builder;

import jakarta.el.ValueExpression;
import jakarta.faces.flow.builder.NavigationCaseBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.flow.FlowImpl;
import org.apache.myfaces.flow.NavigationCaseImpl;
import org.apache.myfaces.flow.builder.FlowBuilderImpl;

public class NavigationCaseBuilderImpl
extends NavigationCaseBuilder {
    private FlowImpl facesFlow;
    private FlowBuilderImpl flowBuilder;
    private NavigationCaseImpl navigationCaseImpl;

    public NavigationCaseBuilderImpl(FlowBuilderImpl flowBuilder, FlowImpl facesFlow) {
        this.flowBuilder = flowBuilder;
        this.facesFlow = facesFlow;
        this.navigationCaseImpl = new NavigationCaseImpl();
    }

    public NavigationCaseBuilder fromViewId(String fromViewId) {
        if (this.navigationCaseImpl.getFromViewId() != null) {
            this.facesFlow.removeNavigationCase(this.navigationCaseImpl);
        }
        if (fromViewId != null) {
            this.navigationCaseImpl.setFromViewId(fromViewId);
            this.facesFlow.addNavigationCase(this.navigationCaseImpl);
        }
        return this;
    }

    public NavigationCaseBuilder fromAction(String fromAction) {
        this.navigationCaseImpl.setFromAction(fromAction);
        return this;
    }

    public NavigationCaseBuilder fromOutcome(String fromOutcome) {
        this.navigationCaseImpl.setFromOutcome(fromOutcome);
        return this;
    }

    public NavigationCaseBuilder toViewId(String toViewId) {
        this.navigationCaseImpl.setToViewId(toViewId);
        return this;
    }

    public NavigationCaseBuilder toFlowDocumentId(String toFlowDocumentId) {
        this.navigationCaseImpl.setToFlowDocumentId(toFlowDocumentId);
        return this;
    }

    public NavigationCaseBuilder condition(String condition) {
        this.navigationCaseImpl.setConditionExpression(null);
        this.navigationCaseImpl.setCondition(condition);
        return this;
    }

    public NavigationCaseBuilder condition(ValueExpression condition) {
        this.navigationCaseImpl.setCondition(null);
        this.navigationCaseImpl.setConditionExpression(condition);
        return this;
    }

    public NavigationCaseBuilder.RedirectBuilder redirect() {
        this.navigationCaseImpl.setRedirect(true);
        return new RedirectBuilderImpl();
    }

    public class RedirectBuilderImpl
    extends NavigationCaseBuilder.RedirectBuilder {
        public RedirectBuilderImpl() {
            super((NavigationCaseBuilder)NavigationCaseBuilderImpl.this);
        }

        public NavigationCaseBuilder.RedirectBuilder parameter(String name, String value) {
            Map<String, List<String>> map = NavigationCaseBuilderImpl.this.navigationCaseImpl.getParameters();
            if (map == null) {
                map = new HashMap<String, List<String>>(3, 1.0f);
                NavigationCaseBuilderImpl.this.navigationCaseImpl.setParameters(map);
            }
            List values = map.computeIfAbsent(name, k -> new ArrayList());
            values.add(value);
            return this;
        }

        public NavigationCaseBuilder.RedirectBuilder includeViewParams() {
            NavigationCaseBuilderImpl.this.navigationCaseImpl.setIncludeViewParams(true);
            return this;
        }
    }
}

