/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support;

import java.io.File;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.MutableCallContext;

public class MutableCallContextWrapper
implements MutableCallContext {
    private final CallContext context;
    private final Map<String, Object> values;

    public MutableCallContextWrapper(CallContext context) {
        this.context = context;
        this.values = context instanceof MutableCallContext ? null : new HashMap<String, Object>();
    }

    public Object get(String key) {
        if (this.values == null) {
            return this.context.get(key);
        }
        if (this.values.containsKey(key)) {
            return this.values.get(key);
        }
        return this.context.get(key);
    }

    public void put(String key, Object value) {
        if (this.values == null) {
            ((MutableCallContext)this.context).put(key, value);
        } else {
            this.values.put(key, value);
        }
    }

    public Object remove(String key) {
        if (this.values == null) {
            return ((MutableCallContext)this.context).remove(key);
        }
        Object value = this.context.get(key);
        if (value != null) {
            this.values.put(key, null);
            return value;
        }
        return this.values.remove(key);
    }

    public String getBinding() {
        return this.context.getBinding();
    }

    public boolean isObjectInfoRequired() {
        return this.context.isObjectInfoRequired();
    }

    public CmisVersion getCmisVersion() {
        return (CmisVersion)this.get("cmisVersion");
    }

    public String getRepositoryId() {
        return (String)this.get("repositoryId");
    }

    public String getUsername() {
        return (String)this.get("username");
    }

    public String getPassword() {
        return (String)this.get("password");
    }

    public String getLocale() {
        return (String)this.get("locale");
    }

    public BigInteger getOffset() {
        return (BigInteger)this.get("offset");
    }

    public BigInteger getLength() {
        return (BigInteger)this.get("length");
    }

    public File getTempDirectory() {
        return (File)this.get("tempDir");
    }

    public boolean encryptTempFiles() {
        return Boolean.TRUE.equals(this.get("encryptTempFiles"));
    }

    public int getMemoryThreshold() {
        return (Integer)this.get("memoryThreshold");
    }

    public long getMaxContentSize() {
        return (Long)this.get("maxContentSize");
    }
}

