/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.connectorcommon.throttler;

import org.apache.manifoldcf.connectorcommon.interfaces.BreakException;
import org.apache.manifoldcf.connectorcommon.interfaces.IBreakCheck;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IServiceDataAcceptor;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class ThrottleBin {
    protected boolean isAlive = true;
    protected final String binName;
    protected final String serviceTypeName;
    protected final String serviceName;
    protected final String targetCalcLockName;
    protected double minimumMillisecondsPerByte = Double.MAX_VALUE;
    protected double localMinimum = Double.MAX_VALUE;
    protected volatile int refCount = 0;
    protected double rateEstimate = 0.0;
    protected volatile boolean estimateValid = false;
    protected volatile boolean estimateInProgress = false;
    protected long seriesStartTime = -1L;
    protected long totalBytesRead = -1L;
    protected static final String serviceTypePrefix = "_THROTTLEBIN_";
    protected static final String targetCalcLockPrefix = "_THROTTLEBINTARGET_";

    public ThrottleBin(IThreadContext threadContext, String throttlingGroupName, String binName) throws ManifoldCFException {
        this.binName = binName;
        this.serviceTypeName = ThrottleBin.buildServiceTypeName(throttlingGroupName, binName);
        this.targetCalcLockName = ThrottleBin.buildTargetCalcLockName(throttlingGroupName, binName);
        ILockManager lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        this.serviceName = lockManager.registerServiceBeginServiceActivity(this.serviceTypeName, null, null);
    }

    protected static String buildServiceTypeName(String throttlingGroupName, String binName) {
        return serviceTypePrefix + throttlingGroupName + "_" + binName;
    }

    protected static String buildTargetCalcLockName(String throttlingGroupName, String binName) {
        return targetCalcLockPrefix + throttlingGroupName + "_" + binName;
    }

    public String getBinName() {
        return this.binName;
    }

    public synchronized void updateMinimumMillisecondsPerByte(double min) {
        this.minimumMillisecondsPerByte = min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginFetch() {
        ThrottleBin throttleBin = this;
        synchronized (throttleBin) {
            if (this.refCount == 0) {
                this.estimateValid = false;
                this.rateEstimate = 0.0;
                this.totalBytesRead = 0L;
                this.estimateInProgress = false;
                this.seriesStartTime = -1L;
            }
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortFetch() {
        ThrottleBin throttleBin = this;
        synchronized (throttleBin) {
            --this.refCount;
        }
    }

    public boolean beginRead(int byteCount, IBreakCheck breakCheck) throws InterruptedException, BreakException {
        ThrottleBin throttleBin = this;
        synchronized (throttleBin) {
            while (true) {
                if (!this.isAlive) {
                    return false;
                }
                if (this.estimateInProgress) {
                    if (breakCheck == null) {
                        this.wait();
                        continue;
                    }
                    long amt = breakCheck.abortCheck();
                    this.wait(amt);
                    continue;
                }
                long currentTime = System.currentTimeMillis();
                if (!this.estimateValid) {
                    this.seriesStartTime = currentTime;
                    this.estimateInProgress = true;
                    this.totalBytesRead += (long)byteCount;
                    return true;
                }
                if (this.localMinimum == Double.MAX_VALUE) {
                    if (breakCheck == null) {
                        this.wait();
                        continue;
                    }
                    long amt = breakCheck.abortCheck();
                    this.wait(amt);
                    continue;
                }
                long desiredEndTime = this.seriesStartTime + (long)((double)(this.totalBytesRead + (long)byteCount) * this.localMinimum);
                long estimatedTime = (long)(this.rateEstimate * (double)byteCount);
                long waitTime = desiredEndTime - estimatedTime - currentTime;
                if (waitTime <= 0L) {
                    this.totalBytesRead += (long)byteCount;
                    return true;
                }
                if (breakCheck == null) {
                    this.wait(waitTime);
                    continue;
                }
                long amt = breakCheck.abortCheck();
                if (waitTime < amt) {
                    amt = waitTime;
                }
                this.wait(amt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortRead() {
        ThrottleBin throttleBin = this;
        synchronized (throttleBin) {
            if (this.estimateInProgress) {
                this.estimateInProgress = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRead(int originalCount, int actualCount) {
        ThrottleBin throttleBin = this;
        synchronized (throttleBin) {
            this.totalBytesRead = this.totalBytesRead + (long)actualCount - (long)originalCount;
            if (this.estimateInProgress) {
                this.rateEstimate = actualCount == 0 ? 0.0 : (double)(System.currentTimeMillis() - this.seriesStartTime) / (double)actualCount;
                this.estimateValid = true;
                this.estimateInProgress = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endFetch() {
        ThrottleBin throttleBin = this;
        synchronized (throttleBin) {
            --this.refCount;
            return this.refCount == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void poll(IThreadContext threadContext) throws ManifoldCFException {
        ILockManager lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        lockManager.enterWriteLock(this.targetCalcLockName);
        try {
            double fairTarget;
            double maximumTarget;
            SumClass sumClass = new SumClass(this.serviceName);
            lockManager.scanServiceData(this.serviceTypeName, (IServiceDataAcceptor)sumClass);
            int numServices = sumClass.getNumServices();
            if (numServices == 0) {
                return;
            }
            double globalTarget = sumClass.getGlobalTarget();
            if (this.minimumMillisecondsPerByte == 0.0) {
                double globalMaxBytesPerMillisecond;
                maximumTarget = globalMaxBytesPerMillisecond = Double.MAX_VALUE;
                fairTarget = globalMaxBytesPerMillisecond;
            } else {
                double globalMaxBytesPerMillisecond = 1.0 / this.minimumMillisecondsPerByte;
                maximumTarget = globalMaxBytesPerMillisecond - globalTarget;
                if (maximumTarget < 0.0) {
                    maximumTarget = 0.0;
                }
                fairTarget = globalMaxBytesPerMillisecond / (double)numServices;
            }
            double inverseTarget = maximumTarget;
            if (inverseTarget > fairTarget) {
                inverseTarget = fairTarget;
            }
            lockManager.updateServiceData(this.serviceTypeName, this.serviceName, ThrottleBin.pack(inverseTarget));
            double target = inverseTarget == 0.0 ? Double.MAX_VALUE : 1.0 / inverseTarget;
            if (target == this.localMinimum) {
                return;
            }
            this.localMinimum = target;
            this.notifyAll();
        }
        finally {
            lockManager.leaveWriteLock(this.targetCalcLockName);
        }
    }

    public synchronized void shutDown(IThreadContext threadContext) throws ManifoldCFException {
        this.isAlive = false;
        this.notifyAll();
        ILockManager lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        lockManager.endServiceActivity(this.serviceTypeName, this.serviceName);
    }

    protected static double unpackTarget(byte[] data) {
        if (data == null || data.length != 8) {
            return 0.0;
        }
        return Double.longBitsToDouble(((long)data[0] & 0xFFL) + ((long)data[1] << 8 & 0xFF00L) + ((long)data[2] << 16 & 0xFF0000L) + ((long)data[3] << 24 & 0xFF000000L) + ((long)data[4] << 32 & 0xFF00000000L) + ((long)data[5] << 40 & 0xFF0000000000L) + ((long)data[6] << 48 & 0xFF000000000000L) + ((long)data[7] << 56 & 0xFF00000000000000L));
    }

    protected static byte[] pack(double targetDouble) {
        long target = Double.doubleToLongBits(targetDouble);
        byte[] rval = new byte[]{(byte)(target & 0xFFL), (byte)(target >> 8 & 0xFFL), (byte)(target >> 16 & 0xFFL), (byte)(target >> 24 & 0xFFL), (byte)(target >> 32 & 0xFFL), (byte)(target >> 40 & 0xFFL), (byte)(target >> 48 & 0xFFL), (byte)(target >> 56 & 0xFFL)};
        return rval;
    }

    protected static class SumClass
    implements IServiceDataAcceptor {
        protected final String serviceName;
        protected int numServices = 0;
        protected double globalTargetTally = 0.0;

        public SumClass(String serviceName) {
            this.serviceName = serviceName;
        }

        public boolean acceptServiceData(String serviceName, byte[] serviceData) throws ManifoldCFException {
            ++this.numServices;
            if (!serviceName.equals(this.serviceName)) {
                this.globalTargetTally += ThrottleBin.unpackTarget(serviceData);
            }
            return false;
        }

        public int getNumServices() {
            return this.numServices;
        }

        public double getGlobalTarget() {
            return this.globalTargetTally;
        }
    }
}

