/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.amazons3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.amazons3.S3Artifact;
import org.apache.manifoldcf.amazons3.XThreadBuffer;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.amazons3.DocumentProcess;
import org.apache.manifoldcf.crawler.connectors.amazons3.GenericDocumentProcess;
import org.apache.manifoldcf.crawler.connectors.amazons3.Messages;
import org.apache.manifoldcf.crawler.connectors.amazons3.ResponseException;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;

public class AmazonS3Connector
extends BaseRepositoryConnector {
    private static final String BUCKET_SPLITTER = ",";
    private static final String TAB_NAME = "TabName";
    private static final String SELECTED_NUM = "SelectedNum";
    private static final String SEQ_NUM = "SeqNum";
    protected static final String ACTIVITY_READ = "read document";
    protected long lastSessionFetch = -1L;
    protected static final long timeToRelease = 300000L;
    protected AmazonS3 amazonS3;
    protected boolean connected = false;
    protected String amazons3ProxyHost = null;
    protected String amazons3ProxyPort = null;
    protected String amazons3ProxyDomain = null;
    protected String amazons3ProxyUserName = null;
    protected String amazons3ProxyPassword = null;
    protected String amazons3AwsAccessKey = null;
    protected String amazons3AwsSecretKey = null;
    private static final String STD_SEPARATOR_BUCKET_AND_KEY = ",";
    private String[] buckets;
    private DocumentProcess documentProcess = new GenericDocumentProcess();

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_READ};
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.amazons3AwsAccessKey};
    }

    public void disconnect() throws ManifoldCFException {
        this.amazons3AwsAccessKey = null;
        this.amazons3AwsSecretKey = null;
        this.amazons3ProxyHost = null;
        this.amazons3ProxyPort = null;
        this.amazons3ProxyDomain = null;
        this.amazons3ProxyUserName = null;
        this.amazons3ProxyPassword = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.amazons3AwsAccessKey = configParams.getParameter("aws_access_key");
        this.amazons3AwsSecretKey = configParams.getObfuscatedParameter("aws_secret_key");
        this.amazons3ProxyHost = configParams.getParameter("amazons3_proxy_host");
        this.amazons3ProxyPort = configParams.getParameter("amazons3_proxy_port");
        this.amazons3ProxyDomain = configParams.getParameter("amazons3_proxy_domain");
        this.amazons3ProxyUserName = configParams.getParameter("amazons3_proxy_username");
        this.amazons3ProxyPassword = configParams.getObfuscatedParameter("amazons3_proxy_password");
    }

    protected AmazonS3 getClient() throws ManifoldCFException {
        if (this.amazonS3 == null) {
            try {
                BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.amazons3AwsAccessKey, this.amazons3AwsSecretKey);
                this.amazonS3 = new AmazonS3Client((AWSCredentials)awsCreds);
            }
            catch (Exception e) {
                Logging.connectors.error((Object)"Error while amazon s3 connectionr", (Throwable)e);
                throw new ManifoldCFException("Amazon client can not connect at the moment", e.getCause());
            }
        }
        this.lastSessionFetch = System.currentTimeMillis();
        return this.amazonS3;
    }

    public String check() throws ManifoldCFException {
        Logging.connectors.info((Object)"Checking connection");
        try {
            CheckThread checkThread = new CheckThread(this.getClient());
            checkThread.start();
            checkThread.join();
            if (checkThread.getException() != null) {
                Throwable thr = checkThread.getException();
                return "Check exception: " + thr.getMessage();
            }
            return checkThread.getResult();
        }
        catch (InterruptedException ex) {
            Logging.connectors.error((Object)"Error while checking connection", (Throwable)ex);
            throw new ManifoldCFException(ex.getMessage(), (Throwable)ex, 2);
        }
    }

    public boolean isConnected() {
        return this.amazonS3 != null && this.amazonS3.getS3AccountOwner() != null;
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            this.amazonS3 = null;
            this.lastSessionFetch = -1L;
        }
    }

    public int getMaxDocumentRequest() {
        return 1;
    }

    public String[] getRelationshipTypes() {
        return new String[]{"related"};
    }

    private void fillInServerConfigurationMap(Map<String, Object> newMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String amazons3AccessKey = parameters.getParameter("aws_access_key");
        String amazons3SecretKey = parameters.getObfuscatedParameter("aws_secret_key");
        if (amazons3AccessKey == null) {
            amazons3AccessKey = "";
        }
        amazons3SecretKey = amazons3SecretKey == null ? "" : mapper.mapPasswordToKey(amazons3SecretKey);
        newMap.put("AMAZONS3_AWS_ACCESS_KEY", amazons3AccessKey);
        newMap.put("AMAZONS3_AWS_SECRET_KEY", amazons3SecretKey);
    }

    private void fillInProxyConfigurationMap(Map<String, Object> newMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String amazons3ProxyHost = parameters.getParameter("amazons3_proxy_host");
        String amazons3ProxyPort = parameters.getParameter("amazons3_proxy_port");
        String amazons3ProxyDomain = parameters.getParameter("amazons3_proxy_domain");
        String amazons3ProxyUserName = parameters.getParameter("amazons3_proxy_username");
        String amazons3ProxyPassword = parameters.getObfuscatedParameter("amazons3_proxy_password");
        if (amazons3ProxyHost == null) {
            amazons3ProxyHost = "";
        }
        if (amazons3ProxyPort == null) {
            amazons3ProxyPort = "";
        }
        if (amazons3ProxyDomain == null) {
            amazons3ProxyDomain = "";
        }
        if (amazons3ProxyUserName == null) {
            amazons3ProxyUserName = "";
        }
        amazons3ProxyPassword = amazons3ProxyPassword == null ? "" : mapper.mapPasswordToKey(amazons3ProxyPassword);
        newMap.put("AMAZONS3_PROXY_HOST", amazons3ProxyHost);
        newMap.put("AMAZONS3_PROXY_PORT", amazons3ProxyPort);
        newMap.put("AMAZONS3_PROXY_DOMAIN", amazons3ProxyDomain);
        newMap.put("AMAZONS3_PROXY_USERNAME", amazons3ProxyUserName);
        newMap.put("AMAZONS3_PROXY_PWD", amazons3ProxyPassword);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        this.fillInProxyConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "viewConfiguration_amazons3.html", paramMap);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "Amazons3RepositoryConnector.Server"));
        tabsArray.add(Messages.getString(locale, "Amazons3RepositoryConnector.Proxy"));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        this.fillInProxyConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_amazons3.js", paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(TAB_NAME, tabName);
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        this.fillInProxyConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_amazons3_server.html", paramMap);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_amazons3_proxy.html", paramMap);
    }

    private static void fillInBucketsSpecificationMap(Map<String, Object> newMap, Specification ds) {
        String s3Buckets = "";
        newMap.put("AMAZONS3BUCKETS", s3Buckets);
        s3Buckets = AmazonS3Connector.getExcludedBuckets(ds);
        if (s3Buckets != null && !StringUtils.isEmpty((String)s3Buckets)) {
            String[] buckets = s3Buckets.split(",");
            newMap.put("AMAZONS3BUCKETS", s3Buckets);
            Logging.connectors.info((Object)("resolved s3 bucket values : " + s3Buckets));
        } else {
            Logging.connectors.info((Object)"No exclusion buckets available");
        }
    }

    private static String getExcludedBuckets(Specification ds) {
        String buckets = null;
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (!sn.getType().equals("startpoint")) continue;
            buckets = sn.getAttributeValue("s3buckets");
        }
        return buckets;
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String amazons3ProxyPassword;
        String amazons3ProxyUserName;
        String amazons3ProxyDomain;
        String amazons3ProxyPort;
        String amazons3ProxyHost;
        String awsSecretKey;
        String awsAccessKey = variableContext.getParameter("aws_access_key");
        if (awsAccessKey != null) {
            parameters.setParameter("aws_access_key", awsAccessKey);
        }
        if ((awsSecretKey = variableContext.getParameter("aws_secret_key")) != null) {
            parameters.setObfuscatedParameter("aws_secret_key", variableContext.mapKeyToPassword(awsSecretKey));
        }
        if ((amazons3ProxyHost = variableContext.getParameter("amazons3_proxy_host")) != null) {
            parameters.setParameter("amazons3_proxy_host", amazons3ProxyHost);
        }
        if ((amazons3ProxyPort = variableContext.getParameter("amazons3_proxy_port")) != null) {
            parameters.setParameter("amazons3_proxy_port", amazons3ProxyPort);
        }
        if ((amazons3ProxyDomain = variableContext.getParameter("amazons3_proxy_domain")) != null) {
            parameters.setParameter("amazons3_proxy_domain", amazons3ProxyDomain);
        }
        if ((amazons3ProxyUserName = variableContext.getParameter("amazons3_proxy_username")) != null) {
            parameters.setParameter("amazons3_proxy_username", amazons3ProxyUserName);
        }
        if ((amazons3ProxyPassword = variableContext.getParameter("amazons3_proxy_pwd")) != null) {
            parameters.setObfuscatedParameter("amazons3_proxy_password", variableContext.mapKeyToPassword(amazons3ProxyPassword));
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(SEQ_NUM, Integer.toString(connectionSequenceNumber));
        AmazonS3Connector.fillInBucketsSpecificationMap(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, "viewSpecification_amazons3.html", paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String xc;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String s3Buckets = variableContext.getParameter(seqPrefix + "s3buckets");
        if (StringUtils.isNotEmpty((String)s3Buckets)) {
            s3Buckets = s3Buckets.replaceAll("\\s+", "");
            this.buckets = s3Buckets.split(",");
            if (this.buckets != null) {
                for (int i = 0; i < ds.getChildCount(); ++i) {
                    SpecificationNode oldNode = ds.getChild(i);
                    if (!oldNode.getType().equals("startpoint")) continue;
                    ds.removeChild(i);
                    break;
                }
                SpecificationNode node = new SpecificationNode("startpoint");
                node.setAttribute("s3buckets", s3Buckets);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn = ds.getChild(i);
                if (sn.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(TAB_NAME, tabName);
        paramMap.put(SEQ_NUM, Integer.toString(connectionSequenceNumber));
        paramMap.put(SELECTED_NUM, Integer.toString(actualSequenceNumber));
        AmazonS3Connector.fillInBucketsSpecificationMap(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, "editSpecification_buckets.html", paramMap);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "Amazons3RepositoryConnector.Amazons3Buckets"));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(SEQ_NUM, Integer.toString(connectionSequenceNumber));
        AmazonS3Connector.fillInBucketsSpecificationMap(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, "editSpecification_amazons3.js", paramMap);
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        if (lastSeedVersion == null) {
            long startTime = 0L;
        } else {
            long startTime = new Long(lastSeedVersion);
        }
        String[] bucketsToRemove = null;
        String unparsedBuckets = AmazonS3Connector.getExcludedBuckets(spec);
        if (unparsedBuckets != null && StringUtils.isNotEmpty((String)unparsedBuckets)) {
            bucketsToRemove = unparsedBuckets.split(",");
        }
        this.getSeeds(activities, bucketsToRemove);
        return new Long(seedTime).toString();
    }

    private void getSeeds(ISeedingActivity activities, String[] buckets) throws ManifoldCFException, ServiceInterruption {
        GetSeedsThread t = new GetSeedsThread(this.getClient(), buckets);
        try {
            t.start();
            boolean wasInterrupted = false;
            try {
                XThreadBuffer<S3Artifact> seedBuffer = t.getBuffer();
                while (true) {
                    S3Artifact s3Artifact;
                    if ((s3Artifact = seedBuffer.fetch()) == null) {
                        Logging.connectors.info((Object)"No artifact retured");
                        break;
                    }
                    String issueKey = s3Artifact.getBucketName() + "," + s3Artifact.getKey();
                    Logging.connectors.info((Object)("Issue key is : " + issueKey));
                    activities.addSeedDocument(issueKey);
                }
            }
            catch (InterruptedException e) {
                Logging.connectors.error((Object)e);
                wasInterrupted = true;
                throw e;
            }
            catch (ManifoldCFException e) {
                Logging.connectors.error((Object)e);
                if (e.getErrorCode() == 2) {
                    wasInterrupted = true;
                }
                throw e;
            }
            finally {
                if (!wasInterrupted) {
                    t.finishUp();
                }
            }
        }
        catch (InterruptedException e) {
            Logging.connectors.error((Object)e);
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            Logging.connectors.error((Object)e);
            AmazonS3Connector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            Logging.connectors.error((Object)e);
            t.interrupt();
            AmazonS3Connector.handleIOException(e);
        }
        catch (IOException e) {
            Logging.connectors.error((Object)e);
            AmazonS3Connector.handleIOException(e);
        }
        catch (ResponseException e) {
            Logging.connectors.error((Object)e);
            AmazonS3Connector.handleResponseException(e);
        }
    }

    private static void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (!(e instanceof SocketTimeoutException) && e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        Logging.connectors.warn((Object)("Amazons3: IO exception: " + e.getMessage()), (Throwable)e);
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("IO exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
    }

    private static void handleResponseException(ResponseException e) throws ManifoldCFException, ServiceInterruption {
        throw new ManifoldCFException("Unexpected response: " + e.getMessage(), (Throwable)e);
    }

    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        AmazonS3 amazons3Client = this.getClient();
        this.documentProcess.doProcessDocument(documentIdentifiers, statuses, spec, activities, jobMode, usesDefaultAuthority, amazons3Client);
    }

    protected static class CheckThread
    extends Thread {
        protected String result = "Unknown";
        protected AmazonS3 s3 = null;
        protected Throwable exception = null;

        public CheckThread(AmazonS3 s3) {
            this.s3 = s3;
        }

        public String getResult() {
            return this.result;
        }

        public Throwable getException() {
            return this.exception;
        }

        @Override
        public void run() {
            try {
                Owner s3AccountOwner;
                if (this.s3 != null && (s3AccountOwner = this.s3.getS3AccountOwner()) != null) {
                    this.result = StringUtils.isNotEmpty((String)s3AccountOwner.getDisplayName()) ? "Connection OK" : "Connection Failed";
                }
            }
            catch (AmazonServiceException e) {
                this.result = "Connection Failed : " + e.getMessage();
                this.exception = e;
                Logging.connectors.error((Object)e);
            }
            catch (AmazonClientException e) {
                this.result = "Connection Failed : " + e.getMessage();
                this.exception = e;
                Logging.connectors.error((Object)e);
            }
        }
    }

    protected static class GetSeedsThread
    extends Thread {
        protected Throwable exception = null;
        protected String[] bucketsToBeRemoved;
        protected AmazonS3 s3client = null;
        protected XThreadBuffer<S3Artifact> seedBuffer;

        public XThreadBuffer<S3Artifact> getBuffer() {
            return this.seedBuffer;
        }

        public void setBuffer(XThreadBuffer<S3Artifact> buffer) {
            this.seedBuffer = buffer;
        }

        public GetSeedsThread(AmazonS3 s3, String[] buckets) {
            this.bucketsToBeRemoved = buckets;
            this.s3client = s3;
            this.seedBuffer = new XThreadBuffer();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.processSeeds();
            }
            catch (Exception e) {
                Logging.connectors.error((Object)e);
                this.exception = e;
            }
            finally {
                this.seedBuffer.signalDone();
            }
        }

        private void processSeeds() {
            if (this.s3client != null) {
                List listBuckets = this.s3client.listBuckets();
                ArrayList<String> refinedBuckets = new ArrayList<String>();
                for (Object bucket : listBuckets) {
                    if (this.bucketsToBeRemoved != null && this.bucketsToBeRemoved.length > 0) {
                        if (Arrays.asList(this.bucketsToBeRemoved).contains(bucket.getName())) continue;
                        refinedBuckets.add(bucket.getName());
                        continue;
                    }
                    refinedBuckets.add(bucket.getName());
                }
                Iterator iterator = refinedBuckets.iterator();
                while (iterator.hasNext()) {
                    Object bucket;
                    Object bucketName = bucket = (String)iterator.next();
                    try {
                        this.PushSeeds((String)bucketName);
                    }
                    catch (Exception e) {
                        Logging.connectors.error((Object)e);
                    }
                }
            } else {
                Logging.connectors.info((Object)"Could not connect amazon");
            }
        }

        private void PushSeeds(String bucketName) {
            try {
                ObjectListing objectListing = this.s3client.listObjects(new ListObjectsRequest().withBucketName(bucketName));
                for (S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
                    try {
                        this.addSeed(bucketName, objectSummary);
                    }
                    catch (Exception e) {
                        Logging.connectors.error((Object)e);
                    }
                }
            }
            catch (Exception e) {
                Logging.connectors.error((Object)e);
            }
        }

        private void addSeed(String bucketName, S3ObjectSummary objectSummary) throws InterruptedException {
            String objectKey = objectSummary.getKey();
            String combinedKey = bucketName + "," + objectKey;
            this.seedBuffer.add(new S3Artifact(bucketName, objectKey));
            Logging.connectors.info((Object)("Pused a new key(combined) in seed buffer : " + combinedKey));
        }

        public void finishUp() throws InterruptedException, IOException, ResponseException {
            this.seedBuffer.abandon();
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof ResponseException) {
                    throw (ResponseException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unhandled exception of type: " + thr.getClass().getName(), thr);
            }
        }
    }
}

