/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.NumericUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Benchmark)
@Warmup(iterations=4, time=1)
@Measurement(iterations=5, time=1)
@Fork(value=3, jvmArgsAppend={"-Xmx2g", "-Xms2g", "-XX:+AlwaysPreTouch"})
public class NumericUtilsBenchmark {
    @Param(value={"1", "128", "207", "256", "300", "512", "702", "1024"})
    int size;
    private byte[] subA;
    private byte[] subB;
    private byte[] subResult;
    private byte[] subExpected;
    private byte[] addA;
    private byte[] addB;
    private byte[] addResult;
    private byte[] addExpected;

    @Setup(value=Level.Iteration)
    public void subInit() {
        byte[] temp;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.subA = new byte[this.size];
        this.subB = new byte[this.size];
        this.subResult = new byte[this.size];
        this.subExpected = new byte[this.size];
        random.nextBytes(this.subA);
        random.nextBytes(this.subB);
        BigInteger aBig = new BigInteger(1, this.subA);
        BigInteger bBig = new BigInteger(1, this.subB);
        if (aBig.compareTo(bBig) < 0) {
            temp = this.subA;
            this.subA = this.subB;
            this.subB = temp;
            BigInteger tempBig = aBig;
            aBig = bBig;
            bBig = tempBig;
        }
        if ((temp = aBig.subtract(bBig).toByteArray()).length == this.size + 1) {
            assert (temp[0] == 0);
            System.arraycopy(temp, 1, this.subExpected, 0, this.size);
        } else {
            System.arraycopy(temp, 0, this.subExpected, this.size - temp.length, temp.length);
        }
    }

    @Setup(value=Level.Iteration)
    public void addInit() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.addA = new byte[this.size];
        this.addB = new byte[this.size];
        this.addResult = new byte[this.size];
        this.addExpected = new byte[this.size];
        random.nextBytes(this.addA);
        random.nextBytes(this.addB);
        BigInteger aBig = new BigInteger(1, this.addA);
        BigInteger bBig = new BigInteger(1, this.addB);
        byte[] temp = aBig.add(bBig).toByteArray();
        if (temp.length == this.size + 1) {
            if (temp[0] != 0) {
                this.addInit();
                return;
            }
            System.arraycopy(temp, 1, this.addExpected, 0, this.size);
        } else {
            System.arraycopy(temp, 0, this.addExpected, this.size - temp.length, temp.length);
        }
    }

    @Benchmark
    public void subtract() {
        NumericUtils.subtract((int)this.size, (int)0, (byte[])this.subA, (byte[])this.subB, (byte[])this.subResult);
        assert (Arrays.equals(this.subExpected, this.subResult));
    }

    @Benchmark
    public void add() {
        NumericUtils.add((int)this.size, (int)0, (byte[])this.addA, (byte[])this.addB, (byte[])this.addResult);
        assert (Arrays.equals(this.addExpected, this.addResult));
    }
}

