/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.KeywordField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsCollectorManager;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.StringDocValuesReaderState;
import org.apache.lucene.facet.StringValueFacetCounts;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;

public class StringValueFacetCountsExample {
    private final Directory indexDir = new ByteBuffersDirectory();
    private final FacetsConfig config = new FacetsConfig();

    private void index() throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.indexDir, new IndexWriterConfig((Analyzer)new WhitespaceAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        Document doc = new Document();
        doc.add((IndexableField)new KeywordField("Author", "Bob", Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField("Publish Year", new BytesRef((CharSequence)"2010")));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        doc = new Document();
        doc.add((IndexableField)new KeywordField("Author", "Lisa", Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField("Publish Year", new BytesRef((CharSequence)"2010")));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        doc = new Document();
        doc.add((IndexableField)new KeywordField("Author", "Lisa", Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField("Publish Year", new BytesRef((CharSequence)"2012")));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        doc = new Document();
        doc.add((IndexableField)new KeywordField("Author", "Susan", Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField("Publish Year", new BytesRef((CharSequence)"2012")));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        doc = new Document();
        doc.add((IndexableField)new KeywordField("Author", "Frank", Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField("Publish Year", new BytesRef((CharSequence)"1999")));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        indexWriter.close();
    }

    private List<FacetResult> search() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        StringDocValuesReaderState authorState = new StringDocValuesReaderState((IndexReader)indexReader, "Author");
        StringDocValuesReaderState publishState = new StringDocValuesReaderState((IndexReader)indexReader, "Publish Year");
        FacetsCollectorManager fcm = new FacetsCollectorManager();
        FacetsCollector fc = FacetsCollectorManager.search((IndexSearcher)searcher, (Query)MatchAllDocsQuery.INSTANCE, (int)10, (FacetsCollectorManager)fcm).facetsCollector();
        StringValueFacetCounts authorFacets = new StringValueFacetCounts(authorState, fc);
        StringValueFacetCounts publishFacets = new StringValueFacetCounts(publishState, fc);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        results.add(authorFacets.getTopChildren(10, "Author", new String[0]));
        results.add(publishFacets.getTopChildren(10, "Publish Year", new String[0]));
        indexReader.close();
        return results;
    }

    public List<FacetResult> runSearch() throws IOException {
        this.index();
        return this.search();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Facet counting example:");
        System.out.println("-----------------------");
        StringValueFacetCountsExample example = new StringValueFacetCountsExample();
        List<FacetResult> results = example.runSearch();
        System.out.println("Author: " + String.valueOf(results.get(0)));
        System.out.println("Publish Year: " + String.valueOf(results.get(1)));
    }
}

