/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.overview;

import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.luke.models.overview.TermCountsOrder;
import org.apache.lucene.luke.models.util.IndexUtils;

final class TermCounts {
    private final Map<String, Long> termCountMap;

    TermCounts(IndexReader reader) throws IOException {
        Objects.requireNonNull(reader);
        this.termCountMap = IndexUtils.countTerms(reader, IndexUtils.getFieldNames(reader));
    }

    long numTerms() {
        return this.termCountMap.values().stream().mapToLong(Long::longValue).sum();
    }

    Map<String, Long> sortedTermCounts(TermCountsOrder order) {
        Objects.requireNonNull(order);
        return this.sortedTermCounts(switch (order) {
            case TermCountsOrder.NAME_ASC -> Map.Entry.comparingByKey();
            case TermCountsOrder.NAME_DESC -> Map.Entry.comparingByKey().reversed();
            case TermCountsOrder.COUNT_ASC -> Map.Entry.comparingByValue();
            case TermCountsOrder.COUNT_DESC -> Map.Entry.comparingByValue().reversed();
            default -> Map.Entry.comparingByKey();
        });
    }

    private Map<String, Long> sortedTermCounts(Comparator<Map.Entry<String, Long>> comparator) {
        return this.termCountMap.entrySet().stream().sorted(comparator).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, LinkedHashMap::new));
    }
}

