/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.lucene.benchmark.byTask.utils.Format;
import org.apache.lucene.internal.hppc.IntArrayList;

public class Config {
    private static final String DEFAULT_PRINT_PROPS = System.getProperty("tests.verbose", "true");
    private static final String NEW_LINE = System.getProperty("line.separator");
    private int roundNumber = 0;
    private Properties props;
    private HashMap<String, Object> valByRound = new HashMap();
    private HashMap<String, String> colForValByRound = new HashMap();
    private String algorithmText;
    private int numThreads = 1;

    public Config(Reader algReader) throws IOException {
        int i;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader r = new BufferedReader(algReader);
        int lastConfigLine = 0;
        String line = r.readLine();
        while (line != null) {
            lines.add(line);
            if (line.indexOf(61) > 0) {
                lastConfigLine = lines.size();
            }
            line = r.readLine();
        }
        r.close();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < lastConfigLine; ++i) {
            sb.append((String)lines.get(i));
            sb.append(NEW_LINE);
        }
        this.props = new Properties();
        this.props.load(new StringReader(sb.toString()));
        if (this.props.get("work.dir") == null) {
            this.props.setProperty("work.dir", System.getProperty("benchmark.work.dir", "work"));
        }
        if (Boolean.valueOf(this.props.getProperty("print.props", DEFAULT_PRINT_PROPS)).booleanValue()) {
            this.printProps();
        }
        sb = new StringBuilder();
        for (i = lastConfigLine; i < lines.size(); ++i) {
            sb.append((String)lines.get(i));
            sb.append(NEW_LINE);
        }
        this.algorithmText = sb.toString();
    }

    public Config(Properties props) {
        this.props = props;
        if (Boolean.valueOf(props.getProperty("print.props", DEFAULT_PRINT_PROPS)).booleanValue()) {
            this.printProps();
        }
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    private void printProps() {
        System.out.println("------------> config properties:");
        ArrayList<Object> propKeys = new ArrayList<Object>(this.props.keySet());
        Collections.sort(propKeys);
        for (String string : propKeys) {
            System.out.println(string + " = " + this.props.getProperty(string));
        }
        System.out.println("-------------------------------");
    }

    public String get(String name, String dflt) {
        String[] vals = (String[])this.valByRound.get(name);
        if (vals != null) {
            return vals[this.roundNumber % vals.length];
        }
        String sval = this.props.getProperty(name, dflt);
        if (sval == null) {
            return null;
        }
        if (sval.indexOf(58) < 0) {
            return sval;
        }
        if (sval.indexOf(":\\") >= 0 || sval.indexOf(":/") >= 0) {
            return sval;
        }
        int k = sval.indexOf(58);
        String colName = sval.substring(0, k);
        sval = sval.substring(k + 1);
        this.colForValByRound.put(name, colName);
        vals = this.propToStringArray(sval);
        this.valByRound.put(name, vals);
        return vals[this.roundNumber % vals.length];
    }

    public void set(String name, String value) throws Exception {
        if (this.valByRound.get(name) != null) {
            throw new Exception("Cannot modify a multi value property!");
        }
        this.props.setProperty(name, value);
    }

    public int get(String name, int dflt) {
        int[] vals = (int[])this.valByRound.get(name);
        if (vals != null) {
            return vals[this.roundNumber % vals.length];
        }
        String sval = this.props.getProperty(name, "" + dflt);
        if (sval.indexOf(58) < 0) {
            return Integer.parseInt(sval);
        }
        int k = sval.indexOf(58);
        String colName = sval.substring(0, k);
        sval = sval.substring(k + 1);
        this.colForValByRound.put(name, colName);
        vals = this.propToIntArray(sval);
        this.valByRound.put(name, vals);
        return vals[this.roundNumber % vals.length];
    }

    public double get(String name, double dflt) {
        double[] vals = (double[])this.valByRound.get(name);
        if (vals != null) {
            return vals[this.roundNumber % vals.length];
        }
        String sval = this.props.getProperty(name, "" + dflt);
        if (sval.indexOf(58) < 0) {
            return Double.parseDouble(sval);
        }
        int k = sval.indexOf(58);
        String colName = sval.substring(0, k);
        sval = sval.substring(k + 1);
        this.colForValByRound.put(name, colName);
        vals = this.propToDoubleArray(sval);
        this.valByRound.put(name, vals);
        return vals[this.roundNumber % vals.length];
    }

    public boolean get(String name, boolean dflt) {
        boolean[] vals = (boolean[])this.valByRound.get(name);
        if (vals != null) {
            return vals[this.roundNumber % vals.length];
        }
        String sval = this.props.getProperty(name, "" + dflt);
        if (sval.indexOf(58) < 0) {
            return Boolean.valueOf(sval);
        }
        int k = sval.indexOf(58);
        String colName = sval.substring(0, k);
        sval = sval.substring(k + 1);
        this.colForValByRound.put(name, colName);
        vals = this.propToBooleanArray(sval);
        this.valByRound.put(name, vals);
        return vals[this.roundNumber % vals.length];
    }

    public int newRound() {
        ++this.roundNumber;
        StringBuilder sb = new StringBuilder("--> Round ").append(this.roundNumber - 1).append("-->").append(this.roundNumber);
        if (this.valByRound.size() > 0) {
            sb.append(": ");
            for (Map.Entry<String, Object> entry : this.valByRound.entrySet()) {
                int n2;
                String name = entry.getKey();
                Object a = entry.getValue();
                if (a instanceof int[]) {
                    int[] ai = (int[])a;
                    int n1 = (this.roundNumber - 1) % ai.length;
                    n2 = this.roundNumber % ai.length;
                    sb.append("  ").append(name).append(":").append(ai[n1]).append("-->").append(ai[n2]);
                    continue;
                }
                if (a instanceof double[]) {
                    double[] ad = (double[])a;
                    int n1 = (this.roundNumber - 1) % ad.length;
                    n2 = this.roundNumber % ad.length;
                    sb.append("  ").append(name).append(":").append(ad[n1]).append("-->").append(ad[n2]);
                    continue;
                }
                if (a instanceof String[]) {
                    String[] ad = (String[])a;
                    int n1 = (this.roundNumber - 1) % ad.length;
                    n2 = this.roundNumber % ad.length;
                    sb.append("  ").append(name).append(":").append(ad[n1]).append("-->").append(ad[n2]);
                    continue;
                }
                boolean[] ab = (boolean[])a;
                int n1 = (this.roundNumber - 1) % ab.length;
                int n22 = this.roundNumber % ab.length;
                sb.append("  ").append(name).append(":").append(ab[n1]).append("-->").append(ab[n22]);
            }
        }
        System.out.println();
        System.out.println(sb.toString());
        System.out.println();
        return this.roundNumber;
    }

    private String[] propToStringArray(String s) {
        if (s.indexOf(58) < 0) {
            return new String[]{s};
        }
        ArrayList<String> a = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, ":");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            a.add(t);
        }
        return a.toArray(new String[a.size()]);
    }

    private int[] propToIntArray(String s) {
        if (s.indexOf(58) < 0) {
            return new int[]{Integer.parseInt(s)};
        }
        IntArrayList a = new IntArrayList();
        StringTokenizer st = new StringTokenizer(s, ":");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            a.add(Integer.parseInt(t));
        }
        int[] res = new int[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            res[i] = a.get(i);
        }
        return res;
    }

    private double[] propToDoubleArray(String s) {
        if (s.indexOf(58) < 0) {
            return new double[]{Double.parseDouble(s)};
        }
        ArrayList<Double> a = new ArrayList<Double>();
        StringTokenizer st = new StringTokenizer(s, ":");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            a.add(Double.valueOf(t));
        }
        double[] res = new double[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            res[i] = (Double)a.get(i);
        }
        return res;
    }

    private boolean[] propToBooleanArray(String s) {
        if (s.indexOf(58) < 0) {
            return new boolean[]{Boolean.valueOf(s)};
        }
        ArrayList<Boolean> a = new ArrayList<Boolean>();
        StringTokenizer st = new StringTokenizer(s, ":");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            a.add(Boolean.valueOf(t));
        }
        boolean[] res = new boolean[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            res[i] = (Boolean)a.get(i);
        }
        return res;
    }

    public String getColsNamesForValsByRound() {
        if (this.colForValByRound.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String colName : this.colForValByRound.values()) {
            sb.append(' ').append(colName);
        }
        return sb.toString();
    }

    public String getColsValuesForValsByRound(int roundNum) {
        if (this.colForValByRound.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.colForValByRound.entrySet()) {
            String colName = entry.getValue();
            String template = " " + colName;
            if (roundNum < 0) {
                sb.append(Format.formatPaddLeft("-", template));
                continue;
            }
            String valByRoundName = entry.getKey();
            Object a = this.valByRound.get(valByRoundName);
            if (a instanceof int[]) {
                int[] ai = (int[])a;
                int n = roundNum % ai.length;
                sb.append(Format.format(ai[n], template));
                continue;
            }
            if (a instanceof double[]) {
                double[] ad = (double[])a;
                int n = roundNum % ad.length;
                sb.append(Format.format(2, ad[n], template));
                continue;
            }
            if (a instanceof String[]) {
                String[] ad = (String[])a;
                int n = roundNum % ad.length;
                sb.append(ad[n]);
                continue;
            }
            boolean[] ab = (boolean[])a;
            int n = roundNum % ab.length;
            sb.append(Format.formatPaddLeft("" + ab[n], template));
        }
        return sb.toString();
    }

    public int getRoundNumber() {
        return this.roundNumber;
    }

    public String getAlgorithmText() {
        return this.algorithmText;
    }
}

