/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktreeords;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.blocktreeords.OrdsBlockTreeTermsReader;
import org.apache.lucene.codecs.blocktreeords.OrdsBlockTreeTermsWriter;
import org.apache.lucene.codecs.lucene103.Lucene103PostingsReader;
import org.apache.lucene.codecs.lucene103.Lucene103PostingsWriter;
import org.apache.lucene.codecs.lucene103.blocktree.Lucene103BlockTreeTermsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.IOUtils;

public class BlockTreeOrdsPostingsFormat
extends PostingsFormat {
    private final int minTermBlockSize;
    private final int maxTermBlockSize;
    public static final int BLOCK_SIZE = 128;

    public BlockTreeOrdsPostingsFormat() {
        this(25, 48);
    }

    public BlockTreeOrdsPostingsFormat(int minTermBlockSize, int maxTermBlockSize) {
        super("BlockTreeOrds");
        this.minTermBlockSize = minTermBlockSize;
        this.maxTermBlockSize = maxTermBlockSize;
        Lucene103BlockTreeTermsWriter.validateSettings((int)minTermBlockSize, (int)maxTermBlockSize);
    }

    public String toString() {
        return this.getName() + "(blocksize=128)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        OrdsBlockTreeTermsWriter ordsBlockTreeTermsWriter;
        block3: {
            Lucene103PostingsWriter postingsWriter = new Lucene103PostingsWriter(state);
            boolean success = false;
            try {
                OrdsBlockTreeTermsWriter ret = new OrdsBlockTreeTermsWriter(state, (PostingsWriterBase)postingsWriter, this.minTermBlockSize, this.maxTermBlockSize);
                success = true;
                ordsBlockTreeTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsWriter});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsWriter});
        }
        return ordsBlockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        OrdsBlockTreeTermsReader ordsBlockTreeTermsReader;
        block3: {
            Lucene103PostingsReader postingsReader = new Lucene103PostingsReader(state);
            boolean success = false;
            try {
                OrdsBlockTreeTermsReader ret = new OrdsBlockTreeTermsReader((PostingsReaderBase)postingsReader, state);
                success = true;
                ordsBlockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsReader});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsReader});
        }
        return ordsBlockTreeTermsReader;
    }
}

