/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiAuthRoleRef;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="This is the model for user information in the API, v18 and beyond. <p> Note that any method that returns user information will not contain any password information. The password property is only used when creating or updating users.")
public class ApiUser2 {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="authRoles")
    private List<ApiAuthRoleRef> authRoles = null;
    @SerializedName(value="pwHash")
    private String pwHash = null;
    @SerializedName(value="pwSalt")
    private BigDecimal pwSalt = null;
    @SerializedName(value="pwLogin")
    private Boolean pwLogin = null;

    public ApiUser2 name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The username, which is unique within a Cloudera Manager installation.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiUser2 password(String password) {
        this.password = password;
        return this;
    }

    @Schema(description="Returns the user password. <p> Passwords are not returned when querying user information, so this property will always be empty when reading information from a server.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ApiUser2 authRoles(List<ApiAuthRoleRef> authRoles) {
        this.authRoles = authRoles;
        return this;
    }

    public ApiUser2 addAuthRolesItem(ApiAuthRoleRef authRolesItem) {
        if (this.authRoles == null) {
            this.authRoles = new ArrayList<ApiAuthRoleRef>();
        }
        this.authRoles.add(authRolesItem);
        return this;
    }

    @Schema(description="A list of ApiAuthRole that this user possesses.")
    public List<ApiAuthRoleRef> getAuthRoles() {
        return this.authRoles;
    }

    public void setAuthRoles(List<ApiAuthRoleRef> authRoles) {
        this.authRoles = authRoles;
    }

    public ApiUser2 pwHash(String pwHash) {
        this.pwHash = pwHash;
        return this;
    }

    @Schema(description="NOTE: Optional. Only available in the \"export\" view.")
    public String getPwHash() {
        return this.pwHash;
    }

    public void setPwHash(String pwHash) {
        this.pwHash = pwHash;
    }

    public ApiUser2 pwSalt(BigDecimal pwSalt) {
        this.pwSalt = pwSalt;
        return this;
    }

    @Schema(description="NOTE: Optional. Only available in the \"export\" view.")
    public BigDecimal getPwSalt() {
        return this.pwSalt;
    }

    public void setPwSalt(BigDecimal pwSalt) {
        this.pwSalt = pwSalt;
    }

    public ApiUser2 pwLogin(Boolean pwLogin) {
        this.pwLogin = pwLogin;
        return this;
    }

    @Schema(description="NOTE: Optional. Only available in the \"export\" view.")
    public Boolean isPwLogin() {
        return this.pwLogin;
    }

    public void setPwLogin(Boolean pwLogin) {
        this.pwLogin = pwLogin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiUser2 apiUser2 = (ApiUser2)o;
        return Objects.equals(this.name, apiUser2.name) && Objects.equals(this.password, apiUser2.password) && Objects.equals(this.authRoles, apiUser2.authRoles) && Objects.equals(this.pwHash, apiUser2.pwHash) && Objects.equals(this.pwSalt, apiUser2.pwSalt) && Objects.equals(this.pwLogin, apiUser2.pwLogin);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.password, this.authRoles, this.pwHash, this.pwSalt, this.pwLogin);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiUser2 {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    authRoles: ").append(this.toIndentedString(this.authRoles)).append("\n");
        sb.append("    pwHash: ").append(this.toIndentedString(this.pwHash)).append("\n");
        sb.append("    pwSalt: ").append(this.toIndentedString(this.pwSalt)).append("\n");
        sb.append("    pwLogin: ").append(this.toIndentedString(this.pwLogin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

