/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiCommandList;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="A list of commands. <p> This list is returned whenever commands are issued in bulk, and contains a second list with information about errors issuing specific commands.")
public class ApiBulkCommandList
extends ApiCommandList {
    @SerializedName(value="errors")
    private List<String> errors = null;

    public ApiBulkCommandList errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public ApiBulkCommandList addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Schema(description="Errors that occurred when issuing individual commands.")
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiBulkCommandList apiBulkCommandList = (ApiBulkCommandList)o;
        return Objects.equals(this.errors, apiBulkCommandList.errors) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.errors, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiBulkCommandList {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

