/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.parsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.jline.ParsedLineImpl;
import org.apache.felix.gogo.runtime.Parser;
import org.apache.felix.gogo.runtime.Token;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Session;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;

public class KarafParser
implements Parser {
    private final Session session;

    public KarafParser(Session session) {
        this.session = session;
    }

    public ParsedLine parse(String line, int cursor, Parser.ParseContext parseContext) throws org.apache.felix.gogo.runtime.SyntaxError {
        try {
            return this.doParse(line, cursor, parseContext);
        }
        catch (org.apache.felix.gogo.runtime.EOFError e) {
            throw new EOFError(e.line(), e.column(), e.getMessage(), e.missing());
        }
        catch (org.apache.felix.gogo.runtime.SyntaxError e) {
            throw new SyntaxError(e.line(), e.column(), e.getMessage());
        }
    }

    private ParsedLine doParse(String line, int cursor, Parser.ParseContext parseContext) throws org.apache.felix.gogo.runtime.SyntaxError {
        Parser.Program program = null;
        List<Parser.Statement> statements = null;
        Object repaired = line;
        while (program == null) {
            try {
                org.apache.felix.gogo.runtime.Parser parser = new org.apache.felix.gogo.runtime.Parser((CharSequence)repaired);
                program = parser.program();
                statements = parser.statements();
            }
            catch (org.apache.felix.gogo.runtime.EOFError e) {
                if (parseContext == Parser.ParseContext.COMPLETE && ((String)repaired).length() < line.length() + 1024) {
                    repaired = (String)repaired + " " + e.repair();
                    continue;
                }
                throw e;
            }
        }
        Parser.Statement statement = null;
        for (int i = statements.size() - 1; i >= 0; --i) {
            Parser.Statement s = statements.get(i);
            if (s.start() > cursor) continue;
            boolean isOk = true;
            if (s.start() + s.length() < cursor) {
                for (int j = s.start() + s.length(); isOk && j < cursor; ++j) {
                    isOk = Character.isWhitespace(line.charAt(j));
                }
            }
            statement = s;
            break;
        }
        if (statement != null && statement.tokens() != null && !statement.tokens().isEmpty()) {
            org.apache.karaf.shell.api.console.Parser cmdParser;
            String cmdName = this.session.resolveCommand(statement.tokens().get(0).toString());
            String[] parts = cmdName.split(":");
            Command cmd = parts.length == 2 ? this.session.getRegistry().getCommand(parts[0], parts[1]) : null;
            org.apache.karaf.shell.api.console.Parser parser = cmdParser = cmd != null ? cmd.getParser() : null;
            if (cmdParser != null) {
                final CommandLine cmdLine = cmdParser.parse(this.session, statement.toString(), cursor - statement.start());
                return new ParsedLine(){

                    public String word() {
                        return cmdLine.getCursorArgument();
                    }

                    public int wordCursor() {
                        return cmdLine.getArgumentPosition();
                    }

                    public int wordIndex() {
                        return cmdLine.getCursorArgumentIndex();
                    }

                    public List<String> words() {
                        return Arrays.asList(cmdLine.getArguments());
                    }

                    public String line() {
                        return cmdLine.getBuffer();
                    }

                    public int cursor() {
                        return cmdLine.getBufferPosition();
                    }
                };
            }
            if (repaired != line) {
                Token stmt = statement.subSequence(0, line.length() - statement.start());
                ArrayList<Token> tokens = new ArrayList<Token>(statement.tokens());
                Token last = (Token)tokens.get(tokens.size() - 1);
                tokens.set(tokens.size() - 1, last.subSequence(0, line.length() - last.start()));
                return new ParsedLineImpl(program, stmt, cursor, tokens);
            }
            return new ParsedLineImpl(program, statement, cursor, statement.tokens());
        }
        return new ParsedLineImpl(program, program, cursor, Collections.singletonList(program));
    }
}

