/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region.hook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.equinox.internal.region.hook.RegionBundleFindHook;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.hooks.bundle.EventHook;

public final class RegionBundleEventHook
implements EventHook {
    private final RegionDigraph regionDigraph;
    private final ThreadLocal<Region> threadLocal;
    private final long hookImplID;

    public RegionBundleEventHook(RegionDigraph regionDigraph, ThreadLocal<Region> threadLocal, long hookImplID) {
        this.regionDigraph = regionDigraph;
        this.threadLocal = threadLocal;
        this.hookImplID = hookImplID;
    }

    public void event(BundleEvent event, Collection<BundleContext> contexts) {
        Bundle eventBundle = event.getBundle();
        if (event.getType() == 1) {
            this.bundleInstalled(eventBundle, event.getOrigin());
        }
        HashMap<Region, Boolean> regionAccess = new HashMap<Region, Boolean>();
        Iterator<BundleContext> i = contexts.iterator();
        while (i.hasNext()) {
            Bundle bundle = RegionBundleFindHook.getBundle(i.next());
            if (bundle == null) {
                i.remove();
                continue;
            }
            long bundleID = bundle.getBundleId();
            if (bundleID == 0L || bundleID == this.hookImplID) continue;
            Region region = this.regionDigraph.getRegion(bundle);
            if (region == null) {
                i.remove();
                continue;
            }
            Boolean accessible = (Boolean)regionAccess.get(region);
            if (accessible == null) {
                accessible = this.isAccessible(region, eventBundle);
                regionAccess.put(region, accessible);
            }
            if (accessible.booleanValue()) continue;
            i.remove();
        }
        if (event.getType() == 16) {
            this.bundleUninstalled(eventBundle);
        }
    }

    private boolean isAccessible(Region region, Bundle candidateBundle) {
        ArrayList<Bundle> candidates = new ArrayList<Bundle>(1);
        candidates.add(candidateBundle);
        RegionBundleFindHook.find(region, candidates);
        return !candidates.isEmpty();
    }

    private void bundleInstalled(Bundle eventBundle, Bundle originBundle) {
        Region installRegion = this.threadLocal.get();
        if (installRegion != null) {
            this.addBundleToRegion(eventBundle, installRegion);
        } else {
            Region defaultAssignRegion = this.regionDigraph.getDefaultRegion();
            if (defaultAssignRegion != null) {
                this.addBundleToRegion(eventBundle, defaultAssignRegion);
            } else {
                Region originRegion = this.regionDigraph.getRegion(originBundle);
                if (originRegion != null) {
                    this.addBundleToRegion(eventBundle, originRegion);
                }
            }
        }
    }

    private void addBundleToRegion(Bundle eventBundle, Region region) {
        try {
            region.addBundle(eventBundle);
        }
        catch (BundleException e) {
            e.printStackTrace();
            throw new RuntimeException("Bundle could not be added to region", e);
        }
    }

    private void bundleUninstalled(Bundle eventBundle) {
        Region region = this.regionDigraph.getRegion(eventBundle);
        if (region != null) {
            region.removeBundle(eventBundle);
        }
    }
}

