/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms.internal;

import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import org.apache.karaf.jms.internal.DestinationSource;
import org.apache.karaf.util.json.JsonReader;

class ArtemisDestinationSourceFactory
implements DestinationSource.Factory {
    ArtemisDestinationSourceFactory() {
    }

    @Override
    public DestinationSource create(JMSContext context) {
        try {
            ConnectionMetaData cmd = context.getMetaData();
            if (cmd.getJMSProviderName().equals("ActiveMQ") && cmd.getProviderVersion().startsWith("2.")) {
                return type -> this.getNames(context, type);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private List<String> getNames(JMSContext context, DestinationSource.DestinationType type) {
        List list;
        block8: {
            Queue managementQueue = context.createQueue("activemq.management");
            TemporaryQueue replyTo = context.createTemporaryQueue();
            context.start();
            String routing = type == DestinationSource.DestinationType.Queue ? "ANYCAST" : "MULTICAST";
            context.createProducer().setProperty("_AMQ_ResourceName", "broker").setProperty("_AMQ_OperationName", "getQueueNames").setJMSReplyTo((Destination)replyTo).send((Destination)managementQueue, "[\"" + routing + "\"]");
            JMSConsumer consumer = context.createConsumer((Destination)replyTo);
            try {
                Message reply = consumer.receive(500L);
                String json = ((TextMessage)reply).getText();
                List array = (List)JsonReader.read(new StringReader(json));
                list = (List)array.get(0);
                if (consumer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (consumer != null) {
                        try {
                            consumer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }
            consumer.close();
        }
        return list;
    }
}

