/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.core.internal.osgi;

import java.util.Hashtable;
import org.apache.karaf.log.core.LogEventFormatter;
import org.apache.karaf.log.core.LogService;
import org.apache.karaf.log.core.internal.LogEventFormatterImpl;
import org.apache.karaf.log.core.internal.LogMBeanImpl;
import org.apache.karaf.log.core.internal.LogServiceImpl;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.Managed;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogLevel;

@Services(requires={@RequireService(value=ConfigurationAdmin.class)}, provides={@ProvideService(value=LogService.class)})
@Managed(value="org.apache.karaf.log")
public class Activator
extends BaseActivator
implements ManagedService {
    @Override
    protected void doStart() throws Exception {
        ConfigurationAdmin configurationAdmin = this.getTrackedService(ConfigurationAdmin.class);
        if (configurationAdmin == null) {
            return;
        }
        int size = this.getInt("size", 500);
        String pattern = this.getString("pattern", "%d{ABSOLUTE} | %-5.5p | %-16.16t | %-32.32c{1} | %-32.32C %4L | %m%n");
        String errorColor = this.getString("errorColor", "31");
        String warnColor = this.getString("warnColor", "35");
        String infoColor = this.getString("infoColor", "36");
        String debugColor = this.getString("debugColor", "39");
        String traceColor = this.getString("traceColor", "39");
        LogEventFormatterImpl formatter = new LogEventFormatterImpl();
        formatter.setPattern(pattern);
        formatter.setColor(LogLevel.ERROR, errorColor);
        formatter.setColor(LogLevel.WARN, warnColor);
        formatter.setColor(LogLevel.INFO, infoColor);
        formatter.setColor(LogLevel.DEBUG, debugColor);
        formatter.setColor(LogLevel.TRACE, traceColor);
        formatter.setColor(LogLevel.AUDIT, traceColor);
        this.register(LogEventFormatter.class, formatter);
        LogServiceImpl logService = new LogServiceImpl(configurationAdmin, size);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("org.ops4j.pax.logging.appender.name", "VmLogAppender");
        this.register(PaxAppender.class, logService, props);
        this.register(LogService.class, logService);
        LogMBeanImpl securityMBean = new LogMBeanImpl(logService);
        this.registerMBean(securityMBean, "type=log");
    }
}

