/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.command;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.shell.InteractiveShell;
import org.apache.kafka.shell.command.Commands;
import org.apache.kafka.shell.state.MetadataShellState;
import org.jline.reader.Candidate;

public final class HistoryCommandHandler
implements Commands.Handler {
    public static final Commands.Type TYPE = new HistoryCommandType();
    private final int numEntriesToShow;

    public HistoryCommandHandler(int numEntriesToShow) {
        this.numEntriesToShow = numEntriesToShow;
    }

    @Override
    public void run(Optional<InteractiveShell> shell, PrintWriter writer, MetadataShellState state) throws Exception {
        if (!shell.isPresent()) {
            throw new RuntimeException("The history command requires a shell.");
        }
        Iterator<Map.Entry<Integer, String>> iter = shell.get().history(this.numEntriesToShow);
        while (iter.hasNext()) {
            Map.Entry<Integer, String> entry = iter.next();
            writer.printf("% 5d  %s%n", entry.getKey(), entry.getValue());
        }
    }

    public int hashCode() {
        return this.numEntriesToShow;
    }

    public boolean equals(Object other) {
        if (!(other instanceof HistoryCommandHandler)) {
            return false;
        }
        HistoryCommandHandler o = (HistoryCommandHandler)other;
        return o.numEntriesToShow == this.numEntriesToShow;
    }

    public static class HistoryCommandType
    implements Commands.Type {
        private HistoryCommandType() {
        }

        @Override
        public String name() {
            return "history";
        }

        @Override
        public String description() {
            return "Print command history.";
        }

        @Override
        public boolean shellOnly() {
            return true;
        }

        @Override
        public void addArguments(ArgumentParser parser) {
            parser.addArgument(new String[]{"numEntriesToShow"}).nargs("?").type(Integer.class).help("The number of entries to show.");
        }

        @Override
        public Commands.Handler createHandler(Namespace namespace) {
            Integer numEntriesToShow = namespace.getInt("numEntriesToShow");
            return new HistoryCommandHandler(numEntriesToShow == null ? Integer.MAX_VALUE : numEntriesToShow);
        }

        @Override
        public void completeNext(MetadataShellState state, List<String> nextWords, List<Candidate> candidates) throws Exception {
        }
    }
}

