/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public abstract class AbstractHttpClientTransport
extends ContainerLifeCycle
implements HttpClientTransport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientTransport.class);
    private HttpClient client;
    private ConnectionPool.Factory factory;
    private Invocable.InvocationType invocationType = Invocable.InvocationType.BLOCKING;

    protected HttpClient getHttpClient() {
        return this.client;
    }

    @Override
    public void setHttpClient(HttpClient client) {
        this.client = client;
    }

    @Override
    public ConnectionPool.Factory getConnectionPoolFactory() {
        return this.factory;
    }

    @Override
    public void setConnectionPoolFactory(ConnectionPool.Factory factory) {
        this.factory = factory;
    }

    protected void connectFailed(Map<String, Object> context2, Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not connect to {}", context2.get(Destination.CONTEXT_KEY));
        }
        Promise promise = (Promise)context2.get(Connection.PROMISE_CONTEXT_KEY);
        promise.failed(failure);
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        return this.invocationType;
    }

    @Override
    public void setInvocationType(Invocable.InvocationType invocationType) {
        this.invocationType = Objects.requireNonNull(invocationType);
    }
}

