/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.AssociationAggregationFunction;
import org.apache.lucene.facet.taxonomy.FloatTaxonomyFacets;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;

public class TaxonomyFacetFloatAssociations
extends FloatTaxonomyFacets {
    public TaxonomyFacetFloatAssociations(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction) throws IOException {
        this("$facets", taxoReader, config, fc, aggregationFunction);
    }

    public TaxonomyFacetFloatAssociations(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction, DoubleValuesSource valuesSource) throws IOException {
        this("$facets", taxoReader, config, fc, aggregationFunction, valuesSource);
    }

    public TaxonomyFacetFloatAssociations(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction) throws IOException {
        super(indexFieldName, taxoReader, aggregationFunction, config, fc);
        this.aggregateValues(aggregationFunction, fc.getMatchingDocs());
    }

    public TaxonomyFacetFloatAssociations(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction, DoubleValuesSource valuesSource) throws IOException {
        super(indexFieldName, taxoReader, aggregationFunction, config, fc);
        this.aggregateValues(aggregationFunction, fc.getMatchingDocs(), fc.getKeepScores(), valuesSource);
    }

    private static DoubleValues scores(final FacetsCollector.MatchingDocs hits) {
        return new DoubleValues(){
            int index = -1;

            @Override
            public double doubleValue() throws IOException {
                return hits.scores()[this.index];
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                this.index = doc;
                return true;
            }
        };
    }

    private void aggregateValues(AssociationAggregationFunction aggregationFunction, List<FacetsCollector.MatchingDocs> matchingDocs, boolean keepScores, DoubleValuesSource valueSource) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            if (hits.totalHits() == 0) continue;
            this.initializeValueCounters();
            SortedNumericDocValues ordinalValues = DocValues.getSortedNumeric(hits.context().reader(), this.indexFieldName);
            DoubleValues scores = keepScores ? TaxonomyFacetFloatAssociations.scores(hits) : null;
            DoubleValues functionValues = valueSource.getValues(hits.context(), scores);
            DocIdSetIterator it = ConjunctionUtils.intersectIterators(List.of(hits.bits().iterator(), ordinalValues));
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (functionValues.advanceExact(doc)) {
                    float value = (float)functionValues.doubleValue();
                    int ordinalCount = ordinalValues.docValueCount();
                    for (int i = 0; i < ordinalCount; ++i) {
                        int ord = (int)ordinalValues.nextValue();
                        float currentValue = this.getValue(ord);
                        float newValue = aggregationFunction.aggregate(currentValue, value);
                        this.setValue(ord, newValue);
                        this.setCount(ord, this.getCount(ord) + 1);
                    }
                }
                doc = it.nextDoc();
            }
        }
        this.rollup();
    }

    private void aggregateValues(AssociationAggregationFunction aggregationFunction, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            if (hits.totalHits() == 0) continue;
            this.initializeValueCounters();
            BinaryDocValues dv = DocValues.getBinary(hits.context().reader(), this.indexFieldName);
            DocIdSetIterator it = ConjunctionUtils.intersectIterators(Arrays.asList(hits.bits().iterator(), dv));
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                BytesRef bytesRef = dv.binaryValue();
                byte[] bytes = bytesRef.bytes;
                int end = bytesRef.offset + bytesRef.length;
                for (int offset = bytesRef.offset; offset < end; offset += 4) {
                    int ord = BitUtil.VH_BE_INT.get(bytes, offset);
                    float value = BitUtil.VH_BE_FLOAT.get(bytes, offset += 4);
                    float currentValue = this.getValue(ord);
                    float newValue = aggregationFunction.aggregate(currentValue, value);
                    this.setValue(ord, newValue);
                    this.setCount(ord, this.getCount(ord) + 1);
                }
                doc = it.nextDoc();
            }
        }
    }
}

