/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.dboe.storage.system.StorageLib;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;

public interface StorageRDF {
    default public void add(Triple triple) {
        this.add(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    default public void add(Quad quad) {
        this.add(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    default public void delete(Triple triple) {
        this.delete(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    default public void delete(Quad quad) {
        this.delete(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public void add(Node var1, Node var2, Node var3);

    public void add(Node var1, Node var2, Node var3, Node var4);

    public void delete(Node var1, Node var2, Node var3);

    public void delete(Node var1, Node var2, Node var3, Node var4);

    default public void removeAll(Node s, Node p, Node o) {
        StorageLib.removeTriples(this, s, p, o);
    }

    default public void removeAll(Node g, Node s, Node p, Node o) {
        StorageLib.removeTriples(this, s, p, o);
    }

    default public Iterator<Triple> findUnionGraph(Node s, Node p, Node o) {
        return Iter.distinct(Iter.map(this.find(Node.ANY, s, p, o), Quad::asTriple));
    }

    default public Iterator<Quad> find(Quad quad) {
        return this.find(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public Iterator<Quad> find(Node var1, Node var2, Node var3, Node var4);

    default public Iterator<Triple> find(Triple triple) {
        return this.find(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public Iterator<Triple> find(Node var1, Node var2, Node var3);

    default public Stream<Triple> streamUnionGraph(Node s, Node p, Node o) {
        return this.stream(Node.ANY, s, p, o).map(Quad::asTriple).distinct();
    }

    default public Stream<Quad> stream(Quad quad) {
        return this.stream(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    default public Stream<Quad> stream(Node g, Node s, Node p, Node o) {
        return Iter.asStream(this.find(g, s, p, o));
    }

    default public Stream<Triple> stream(Triple triple) {
        return this.stream(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    default public Stream<Triple> stream(Node s, Node p, Node o) {
        return Iter.asStream(this.find(s, p, o));
    }

    default public boolean contains(Triple triple) {
        return this.contains(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean contains(Node var1, Node var2, Node var3);

    default public boolean contains(Quad quad) {
        return this.contains(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public boolean contains(Node var1, Node var2, Node var3, Node var4);
}

