/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.file;

import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.dboe.base.file.BinaryDataFile;
import org.apache.jena.dboe.base.file.SegmentedMemBuffer;

public class BinaryDataFileMem
implements BinaryDataFile {
    private boolean readMode;
    private SegmentedMemBuffer storage;

    @Override
    public synchronized void open() {
        if (this.storage != null) {
            throw new RuntimeIOException("Already open");
        }
        this.storage = new SegmentedMemBuffer();
        this.readMode = true;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.storage != null;
    }

    @Override
    public synchronized int read(long posn, byte[] b, int start, int length) {
        this.checkOpen();
        this.switchToReadMode();
        return this.storage.read(posn, b, start, length);
    }

    @Override
    public synchronized long write(byte[] b, int start, int length) {
        this.checkOpen();
        this.switchToWriteMode();
        long x = this.storage.length();
        this.storage.write(x, b, start, length);
        return x;
    }

    @Override
    public synchronized void truncate(long length) {
        if (length < 0L) {
            IO.exception((String)String.format("truncate: bad length : %d", length));
        }
        this.checkOpen();
        this.switchToWriteMode();
        this.storage.truncate(length);
    }

    @Override
    public synchronized void sync() {
        this.checkOpen();
        this.storage.sync();
    }

    @Override
    public synchronized void close() {
        if (!this.isOpen()) {
            return;
        }
        this.storage.close();
        this.storage = null;
    }

    @Override
    public synchronized long length() {
        return this.storage.length();
    }

    private void switchToReadMode() {
        this.readMode = true;
    }

    private void switchToWriteMode() {
        this.readMode = false;
    }

    private void checkOpen() {
        if (!this.isOpen()) {
            throw new RuntimeIOException("Not open");
        }
    }
}

