/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.parser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIs;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.lang.LangParserBase;
import org.apache.jena.riot.lang.LangParserLib;
import org.apache.jena.shex.ShapeMap;
import org.apache.jena.shex.ShexRecord;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.ShexShape;
import org.apache.jena.shex.expressions.Cardinality;
import org.apache.jena.shex.expressions.DatatypeConstraint;
import org.apache.jena.shex.expressions.NodeConstraint;
import org.apache.jena.shex.expressions.NodeConstraintComponent;
import org.apache.jena.shex.expressions.NodeKind;
import org.apache.jena.shex.expressions.NodeKindConstraint;
import org.apache.jena.shex.expressions.NumLengthConstraint;
import org.apache.jena.shex.expressions.NumLengthKind;
import org.apache.jena.shex.expressions.NumRangeConstraint;
import org.apache.jena.shex.expressions.NumRangeKind;
import org.apache.jena.shex.expressions.SemAct;
import org.apache.jena.shex.expressions.ShapeExprAND;
import org.apache.jena.shex.expressions.ShapeExprDot;
import org.apache.jena.shex.expressions.ShapeExprNOT;
import org.apache.jena.shex.expressions.ShapeExprNone;
import org.apache.jena.shex.expressions.ShapeExprOR;
import org.apache.jena.shex.expressions.ShapeExprRef;
import org.apache.jena.shex.expressions.ShapeExprTripleExpr;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.expressions.ShapeNodeConstraint;
import org.apache.jena.shex.expressions.StrLengthConstraint;
import org.apache.jena.shex.expressions.StrLengthKind;
import org.apache.jena.shex.expressions.StrRegexConstraint;
import org.apache.jena.shex.expressions.TripleConstraint;
import org.apache.jena.shex.expressions.TripleExprCardinality;
import org.apache.jena.shex.expressions.TripleExprEachOf;
import org.apache.jena.shex.expressions.TripleExprOneOf;
import org.apache.jena.shex.expressions.TripleExprRef;
import org.apache.jena.shex.expressions.TripleExpression;
import org.apache.jena.shex.expressions.ValueConstraint;
import org.apache.jena.shex.expressions.ValueSetItem;
import org.apache.jena.shex.expressions.ValueSetRange;
import org.apache.jena.shex.parser.ShexParseException;
import org.apache.jena.shex.parser.ShexParserLib;
import org.apache.jena.shex.sys.SysShex;
import org.apache.jena.sparql.util.NodeUtils;

public class ParserShExC
extends LangParserBase {
    private IndentedWriter out;
    public static boolean DEBUG_PARSE = false;
    public static boolean DEBUG_STACK = false;
    public static boolean DEBUG_DEV = false;
    private List<ShexShape> shapes = new ArrayList<ShexShape>();
    private ShexShape startShape = null;
    private List<String> imports = null;
    private List<SemAct> semActs = new ArrayList<SemAct>();
    private String sourceURI = null;
    private boolean explicitBase = false;
    private String baseURI = null;
    private Node currentShexShapeLabel = null;
    private Map<Node, TripleExpression> tripleExprRefs = new HashMap<Node, TripleExpression>();
    private Deque<ShapeExpression> shapeExprStack = new ArrayDeque<ShapeExpression>();
    private Deque<TripleExpression> tripleExprStack = new ArrayDeque<TripleExpression>();
    private List<NodeConstraintComponent> accumulator = new ArrayList<NodeConstraintComponent>();
    private List<ValueSetRange> valueSetRanges = new ArrayList<ValueSetRange>();
    private ValueSetRange valueSetRange = null;
    private List<ShexRecord> associations = new ArrayList<ShexRecord>();

    protected ParserShExC() {
        this.out = IndentedWriter.clone((IndentedWriter)IndentedWriter.stdout);
    }

    private ShapeExpression currentShapeExpression() {
        return this.peek(this.shapeExprStack);
    }

    private TripleExpression currentTripleExpression() {
        return this.peek(this.tripleExprStack);
    }

    private void printState() {
        if (DEBUG_DEV) {
            this.printStack("shapeExprStack", this.shapeExprStack);
            this.printStack("tripleExprStack", this.tripleExprStack);
        }
    }

    protected String unescapeStr(String lex, int line, int column) {
        return ParserShExC.convert(() -> LangParserLib.unescapeStr((String)lex, (int)line, (int)column), line, column);
    }

    private static String convert(Supplier<String> action, int line, int column) {
        try {
            return action.get();
        }
        catch (RiotException ex) {
            throw new ShexParseException(ex.getMessage(), line, column);
        }
    }

    protected String resolveQuotedIRI(String iriStr, int line, int column) {
        return ParserShExC.convert(() -> super.resolveQuotedIRI(iriStr, line, column), line, column);
    }

    protected String resolvePName(String pname, int line, int column) {
        return ParserShExC.convert(() -> super.resolvePName(pname, line, column), line, column);
    }

    private <T> void printStack(String string, Deque<T> stack) {
        System.out.printf("%s: %d: %s\n", string, stack.size(), stack);
    }

    protected void setBase(String iriStr, int line, int column) {
        super.setBase(iriStr, line, column);
        if (!this.explicitBase) {
            this.baseURI = iriStr;
        }
        this.explicitBase = true;
    }

    public void setSourceAndBase(String originURI, String baseURI) {
        this.sourceURI = originURI;
        this.explicitBase = false;
        this.baseURI = baseURI;
    }

    public void parseShapesStart() {
    }

    public ShexSchema parseShapesFinish() {
        if (this.currentShexShapeLabel != null) {
            throw new InternalErrorException("shape in-progress");
        }
        if (!this.shapeExprStack.isEmpty()) {
            throw new InternalErrorException("shape expresion stack not empty");
        }
        return ShexSchema.shapes(this.sourceURI, this.baseURI, this.profile.getPrefixMap(), this.startShape, this.shapes, this.imports, this.semActs, this.tripleExprRefs);
    }

    protected void semActs(SemAct semAct, int line, int column) {
        this.semActs.add(semAct);
    }

    protected void imports(String iri, int line, int column) {
        if (this.imports == null) {
            this.imports = new ArrayList<String>();
        }
        if (!IRIs.check((String)iri)) {
            this.profile.getErrorHandler().warning("Bad IRI: <" + iri + ">", (long)line, (long)column);
        }
        this.imports.add(iri);
    }

    protected void startShexDoc() {
    }

    protected void finishShexDoc() {
    }

    protected void startShapeExprDecl() {
        this.start("ShapeExprDecl");
        this.startShapeExpressionTop();
    }

    protected void finishShapeExprDecl() {
        ShapeExpression sExpr = this.finishShapeExpressionTop();
        this.newShape(sExpr);
        this.finish("ShapeExprDecl");
    }

    protected void shapeExprDecl(Node label, int line, int column) {
        this.debug("shape label: %s", label);
        this.currentShexShapeLabel = label;
    }

    protected void shapeExternal() {
        this.debug("shape external", new Object[0]);
    }

    protected void startStartClause() {
        this.start("StartClause");
        this.currentShexShapeLabel = SysShex.startNode;
        this.startShapeExpressionTop();
    }

    protected void finishStartClause() {
        ShapeExpression sExpr = this.finishShapeExpressionTop();
        this.startShape = this.newShape(sExpr);
        this.finish("StartClause");
    }

    private ShexShape newShape(ShapeExpression sExpr) {
        ShexShape newShexShape = new ShexShape(this.currentShexShapeLabel, sExpr);
        this.shapes.add(newShexShape);
        this.currentShexShapeLabel = null;
        return newShexShape;
    }

    private void startShapeExpressionTop() {
        this.start("startShapeExpressionTop");
        if (DEBUG_DEV && !this.shapeExprStack.isEmpty()) {
            this.debug("startShapeExpressionTop: Stack not empty", new Object[0]);
        }
    }

    private ShapeExpression finishShapeExpressionTop() {
        if (this.shapeExprStack.isEmpty()) {
            return ShapeExprNone.get();
        }
        ShapeExpression sExpr = this.pop(this.shapeExprStack);
        if (DEBUG_DEV && !this.shapeExprStack.isEmpty()) {
            this.debug("finishShapeExpressionTop: Stack not empty", new Object[0]);
        }
        this.finish("finishShapeExpressionTop");
        return sExpr;
    }

    private int startShapeOp() {
        return this.front(this.shapeExprStack);
    }

    private void finishShapeOpNoAction(String operation, int idx) {
    }

    private List<ShapeExpression> finishShapeOp(int idx) {
        return this.pop(this.shapeExprStack, idx);
    }

    private void finishShapeOp(int idx, Function<List<ShapeExpression>, ShapeExpression> action) {
        if (action == null) {
            return;
        }
        List<ShapeExpression> args = this.finishShapeOp(idx);
        if (args == null) {
            return;
        }
        this.processShapeExprArgs(args, action);
    }

    private void processShapeExprArgs(List<ShapeExpression> args, Function<List<ShapeExpression>, ShapeExpression> action) {
        ShapeExpression sExpr;
        if (action != null && (sExpr = action.apply(args)) != null) {
            this.push(this.shapeExprStack, sExpr);
        }
    }

    private int startTripleOp() {
        return this.front(this.tripleExprStack);
    }

    private void finishTripleOpNoAction(String operation, int idx) {
    }

    private List<TripleExpression> finishTripleOp(int idx) {
        return this.pop(this.tripleExprStack, idx);
    }

    private void finishTripleOp(int idx, List<SemAct> semActs, BiFunction<List<TripleExpression>, List<SemAct>, TripleExpression> action) {
        if (action == null) {
            return;
        }
        List<TripleExpression> args = this.finishTripleOp(idx);
        if (args == null) {
            return;
        }
        this.processTripleExprArgs(args, semActs, action);
    }

    private void processTripleExprArgs(List<TripleExpression> args, List<SemAct> semActs, BiFunction<List<TripleExpression>, List<SemAct>, TripleExpression> action) {
        TripleExpression tExpr;
        if (action != null && (tExpr = action.apply(args, semActs)) != null) {
            this.push(this.tripleExprStack, tExpr);
        }
    }

    protected int startShapeExpression(Inline inline) {
        this.start(inline, "ShapeExpression");
        return this.startShapeOp();
    }

    protected void finishShapeExpression(Inline inline, int idx) {
        this.finishShapeOpNoAction("ShapeExpression", idx);
        this.finish(inline, "ShapeExpression");
    }

    protected int startShapeOr(Inline inline) {
        this.start(inline, "ShapeOr");
        return this.startShapeOp();
    }

    protected void finishShapeOr(Inline inline, int idx) {
        this.finishShapeOp(idx, ShapeExprOR::create);
        this.finish(inline, "ShapeOr");
    }

    protected int startShapeAnd(Inline inline) {
        this.start(inline, "ShapeAnd");
        return this.startShapeOp();
    }

    protected void finishShapeAnd(Inline inline, int idx) {
        this.finishShapeOp(idx, ShapeExprAND::create);
        this.finish(inline, "ShapeAnd");
    }

    protected int startShapeNot(Inline inline) {
        this.start(inline, "ShapeNot");
        return this.startShapeOp();
    }

    protected void finishShapeNot(Inline inline, int idx, boolean negate) {
        int x = this.front(this.shapeExprStack) - idx;
        if (x > 1) {
            throw new InternalErrorException("Shape NOT - multiple items on the stack");
        }
        if (negate && !this.shapeExprStack.isEmpty()) {
            ShapeExpression shExpr = this.pop(this.shapeExprStack);
            ShapeExprNOT shExpr2 = new ShapeExprNOT(shExpr);
            this.push(this.shapeExprStack, shExpr2);
        }
        this.finish(inline, "ShapeNot");
    }

    protected int startShapeAtom(Inline inline) {
        this.start(inline, "ShapeAtom");
        return this.startShapeOp();
    }

    protected void finishShapeAtom(Inline inline, int idx) {
        this.finishShapeOp(idx, ShapeExprAND::create);
        this.finish(inline, "ShapeAtom");
    }

    protected void shapeAtomDOT() {
        this.push(this.shapeExprStack, new ShapeExprDot());
    }

    protected void shapeReference(Node ref) {
        this.push(this.shapeExprStack, new ShapeExprRef(ref));
    }

    protected void startShapeDefinition() {
        this.start("ShapeDefinition");
    }

    protected void finishShapeDefinition(TripleExpression tripleExpr, List<Node> extras, boolean closed, List<SemAct> semActs) {
        if (tripleExpr == null) {
            return;
        }
        ShapeExprTripleExpr shape = ShapeExprTripleExpr.newBuilder().closed(closed).extras(extras).semActs(semActs).shapeExpr(tripleExpr).build();
        this.push(this.shapeExprStack, shape);
        this.finish("ShapeDefinition");
    }

    protected int startTripleExpression() {
        this.start("TripleExpression");
        return this.startTripleOp();
    }

    protected TripleExpression finishTripleExpression(int idx, List<SemAct> semActs) {
        this.finishTripleOp(idx, semActs, TripleExprOneOf::create);
        TripleExpression tripleExpr = this.pop(this.tripleExprStack);
        this.finish("TripleExpression");
        return tripleExpr;
    }

    protected int startTripleExpressionClause() {
        this.start("TripleExpressionClause");
        return this.startTripleOp();
    }

    protected void finishTripleExpressionClause(int idx, List<SemAct> semActs) {
        this.finishTripleOp(idx, semActs, TripleExprEachOf::create);
        this.finish("TripleExpressionClause");
    }

    protected void startUnaryTripleExpr() {
        this.start("UnaryTripleExpression");
    }

    protected void finishUnaryTripleExpr() {
        this.finish("UnaryTripleExpression");
    }

    protected void startBracketedTripleExpr() {
        this.start("BracketedTripleExpression");
    }

    protected void finishBracketedTripleExpr(Node label, TripleExpression tripleExpr, Cardinality cardinality, List<SemAct> semActs) {
        TripleExpression tripleExpr2 = tripleExpr;
        if (cardinality != null) {
            tripleExpr2 = new TripleExprCardinality(tripleExpr, cardinality, semActs);
        } else {
            tripleExpr2.setSemActs(semActs);
        }
        this.push(this.tripleExprStack, tripleExpr2);
        if (label != null) {
            this.tripleExprRefs.put(label, tripleExpr2);
        }
        this.finish("BracketedTripleExpression");
    }

    protected int startTripleConstraint() {
        this.start("TripleConstraint");
        return this.startShapeOp();
    }

    protected void finishTripleConstraint(Node label, int idx, Node predicate, boolean reverse, Cardinality cardinality, List<SemAct> semActs) {
        List<ShapeExpression> args = this.finishShapeOp(idx);
        if (args == null) {
            throw new InternalErrorException("TripleConstraint with null argument ShapeExpression.");
        }
        if (args.size() != 1) {
            throw new InternalErrorException("TripleConstraint with multiple ShapeExpressions");
        }
        ShapeExpression arg = args.get(0);
        TripleConstraint tripleExpr = new TripleConstraint(label, predicate, reverse, arg, cardinality, semActs);
        this.push(this.tripleExprStack, tripleExpr);
        if (label != null) {
            this.tripleExprRefs.put(label, tripleExpr);
        }
        this.finish("TripleConstraint");
    }

    protected int startLiteralNodeConstraint(int line, int column) {
        this.startNodeConstraint();
        this.start("LiteralNodeConstraint");
        return this.startShapeOp();
    }

    protected void finishLiteralNodeConstraint(List<SemAct> semActs, int idx, int line, int column) {
        this.finishShapeOpNoAction("LiteralNodeConstraint", idx);
        this.finishNodeConstraint(semActs);
        this.finish("LiteralNodeConstraint");
    }

    protected int startNonLiteralNodeConstraint(int line, int column) {
        this.startNodeConstraint();
        this.start("NonLiteralNodeConstraint");
        return this.startShapeOp();
    }

    protected void finishNonLiteralNodeConstraint(List<SemAct> semActs, int idx, int line, int column) {
        this.finishShapeOpNoAction("NonLiteralNodeConstraint", idx);
        this.finishNodeConstraint(semActs);
        this.finish("NonLiteralNodeConstraint");
    }

    private void startNodeConstraint() {
    }

    private void finishNodeConstraint(List<SemAct> semActs) {
        NodeConstraint nodeConstraint = new NodeConstraint(this.accumulator);
        this.accumulator.clear();
        ShapeNodeConstraint shExpr = new ShapeNodeConstraint(nodeConstraint, semActs);
        this.push(this.shapeExprStack, shExpr);
    }

    private void addNodeConstraint(NodeConstraintComponent constraint) {
        this.stack("NodeConstraint: %s", constraint);
        this.accumulator.add(constraint);
    }

    protected void constraintDatatype(String str, int line, int column) {
        DatatypeConstraint dt = new DatatypeConstraint(str);
        this.addNodeConstraint(dt);
    }

    protected void constraintNodeKind(String nodeKindStr, int line, int column) {
        NodeKind nodeKind = NodeKind.create(nodeKindStr);
        NodeKindConstraint nk = new NodeKindConstraint(nodeKind);
        this.addNodeConstraint(nk);
    }

    protected void startValueSet() {
        this.start("ValueSet");
    }

    private void accumulateValueSetRange(ValueSetRange vsRange) {
        this.valueSetRanges.add(vsRange);
    }

    protected void finishValueSet() {
        List<ValueSetRange> x = this.valueSetRanges;
        this.valueSetRanges = new ArrayList<ValueSetRange>();
        ValueConstraint vc = new ValueConstraint(x);
        this.addNodeConstraint(vc);
        this.finish("ValueSet");
    }

    protected void startValueSetValue() {
        this.start("ValueSetValue");
    }

    protected void finishValueSetValue() {
        this.finish("ValueSetValue");
    }

    protected void startValueSetValueDot() {
        this.valueSetRange = new ValueSetRange(null, null, null, false);
    }

    protected void finishValueSetValueDot() {
        this.endValueSetValue();
    }

    protected void valueSetIriRange(String iriStr, boolean isStem) {
        this.setValueSetValue(iriStr, null, null, isStem);
    }

    protected void valueSetLiteralRange(Node literal, boolean isStem) {
        this.setValueSetValue(null, null, literal, isStem);
    }

    protected void valueSetLanguageRange(String lang, boolean isStem) {
        this.setValueSetValue(null, lang, null, isStem);
    }

    private void setValueSetValue(String iriStr, String lang, Node literal, boolean isStem) {
        if (this.valueSetRange != null) {
            throw new InternalErrorException("ValueSet range item already set null");
        }
        this.valueSetRange = new ValueSetRange(iriStr, ParserShExC.langtag(lang), literal, isStem);
    }

    protected void startIriRange() {
        this.start("iriRange");
    }

    protected void exclusionIriRange(String iriStr, boolean isStem) {
        this.seenValueExclusion(iriStr, null, null, isStem);
    }

    protected void finishIriRange() {
        this.endValueSetValue();
        this.finish("iriRange");
    }

    protected void startLiteralRange() {
        this.start("literalRange");
    }

    protected void exclusionLiteralRange(Node literal, boolean isStem) {
        this.seenValueExclusion(null, null, literal, isStem);
    }

    protected void finishLiteralRange() {
        this.endValueSetValue();
        this.finish("literalRange");
    }

    protected void startLanguageRange() {
        this.start("languageRange");
    }

    protected void exclusionLanguageRange(String lang, boolean isStem) {
        this.seenValueExclusion(null, lang, null, isStem);
    }

    protected void finishLanguageRange() {
        this.endValueSetValue();
        this.finish("languageRange");
    }

    protected void endValueSetValue() {
        if (this.valueSetRange == null) {
            throw new InternalErrorException("valueSetRange range is null");
        }
        this.accumulateValueSetRange(this.valueSetRange);
        this.valueSetRange = null;
    }

    private static String langtag(String lang) {
        if (lang != null && lang.startsWith("@")) {
            lang = lang.substring(1);
        }
        return lang;
    }

    protected void startValueExclusion() {
        this.start("valueExclusion");
    }

    protected void finishValueExclusion(String iriStr, String lang, Node lit, boolean isStem) {
        this.seenValueExclusion(iriStr, lang, lit, isStem);
        this.finish("valueExclusion");
    }

    private void seenValueExclusion(String iriStr, String lang, Node lit, boolean isStem) {
        this.valueSetRange.exclusions.add(new ValueSetItem(iriStr, ParserShExC.langtag(lang), lit, isStem));
    }

    protected Cardinality cardinalityRange(String image, int line, int column) {
        try {
            return Cardinality.create(image);
        }
        catch (Throwable th) {
            throw new ShexParseException("Bad cardinality: " + image, line, column);
        }
    }

    protected void numericFacetRange(String range, Node num, int line, int column) {
        NumRangeKind kind = NumRangeKind.create(range);
        NumRangeConstraint numLength = new NumRangeConstraint(kind, num);
        this.addNodeConstraint(numLength);
    }

    protected void numericFacetLength(String facetKind, int length, int line, int column) {
        NumLengthKind kind = NumLengthKind.create(facetKind);
        NumLengthConstraint numLength = new NumLengthConstraint(kind, length);
        this.addNodeConstraint(numLength);
    }

    protected SemAct crackSemanticAction(String iriAndCode, int line, int column) {
        String code;
        String iri;
        String whitespaces = " \t\n\r\f";
        int startOfIri = 1;
        while (whitespaces.indexOf(iriAndCode.charAt(startOfIri)) != -1) {
            ++startOfIri;
        }
        if (iriAndCode.charAt(startOfIri) == '<') {
            int iriEnd = iriAndCode.indexOf(62);
            iri = this.profile.resolveIRI(iriAndCode.substring(startOfIri + 1, iriEnd), (long)line, (long)column);
            int codeDelimiter = iriAndCode.indexOf(123, iriEnd);
            code = codeDelimiter == -1 ? null : iriAndCode.substring(codeDelimiter + 1, iriAndCode.length() - 2);
        } else {
            int endOfLocalName;
            int codeDelimiter = iriAndCode.indexOf(123, startOfIri);
            int n = endOfLocalName = codeDelimiter == -1 ? iriAndCode.length() : codeDelimiter - 1;
            while (whitespaces.indexOf(iriAndCode.charAt(endOfLocalName)) != -1) {
                --endOfLocalName;
            }
            String pname = iriAndCode.substring(startOfIri, endOfLocalName + 1);
            iri = this.resolvePName(pname, line, column);
            code = codeDelimiter == -1 ? null : iriAndCode.substring(codeDelimiter + 1, iriAndCode.length() - 2);
        }
        SemAct ret = new SemAct(iri, code == null ? null : EscapeStr.unescapeUnicode((String)code));
        this.stack("SemAct: %s %s", iri, code);
        return ret;
    }

    protected void stringFacetRegex(String regexStr, int line, int column) {
        int idx = regexStr.lastIndexOf(47);
        String pattern = regexStr.substring(1, idx);
        pattern = EscapeStr.unescapeUnicode((String)pattern);
        String flags = regexStr.substring(idx + 1);
        pattern = ShexParserLib.unescapeShexRegex(pattern, '\\', false);
        StrRegexConstraint regex = new StrRegexConstraint(pattern, flags);
        this.addNodeConstraint(regex);
    }

    protected void stringFacetLength(String str, int len) {
        StrLengthKind lengthType = StrLengthKind.create(str);
        StrLengthConstraint nodeConstraint = StrLengthConstraint.create(lengthType, len);
        this.addNodeConstraint(nodeConstraint);
    }

    protected Node langStringLiteral(int quoteLen, String image, int line, int column) {
        int idx = image.lastIndexOf(64);
        if (idx < 2 * quoteLen) {
            throw new ShexParseException("Bad langStringLiteral: " + image, line, column);
        }
        String lex = image.substring(quoteLen, idx - quoteLen);
        String lang = image.substring(idx + 1);
        lex = this.unescapeStr(lex, line, column);
        return NodeFactory.createLiteralLang((String)lex, (String)lang);
    }

    protected Node resolve_AT_PName(String image, int line, int column) {
        String prefixedName = image.substring(1);
        String iriStr = this.resolvePName(prefixedName, line, column);
        return this.createURI(iriStr, line, column);
    }

    protected void ampTripleExprLabel(Node ref) {
        this.push(this.tripleExprStack, new TripleExprRef(ref));
    }

    protected int integer(String image, int line, int column) {
        try {
            return Integer.parseInt(image);
        }
        catch (NumberFormatException ex) {
            throw new ShexParseException(ex.getMessage(), line, column);
        }
    }

    private <T> T peek(Deque<T> stack) {
        return stack.peek();
    }

    private <T> void push(Deque<T> stack, T item) {
        if (item == null) {
            this.debug("push-null", item);
        }
        if (DEBUG_STACK) {
            this.debug("push(%s)", item);
        }
        stack.push(item);
    }

    private <T> T pop(Deque<T> stack) {
        T item = stack.pop();
        if (DEBUG_STACK) {
            this.debug("pop(%s)", item);
        }
        return item;
    }

    private <T> List<T> pop(Deque<T> stack, int x) {
        int N = this.front(stack) - x;
        if (N == 0) {
            return null;
        }
        Object[] items0 = new Object[N];
        List<Object> items = Arrays.asList(items0);
        for (int i = N - 1; i >= 0; --i) {
            items.set(i, this.pop(stack));
        }
        return items;
    }

    private <T> int front(Deque<T> stack) {
        return stack.size();
    }

    private void start(String label) {
        this.start(null, label);
    }

    private void start(Inline inline, String label) {
        if (DEBUG_PARSE) {
            this.out.print("> ");
            this.out.print(label);
            if (inline == Inline.INLINE) {
                this.out.print("'");
            }
            this.out.println();
            this.out.incIndent();
        }
    }

    private void finish(String label) {
        this.finish(null, label);
    }

    private void finish(Inline inline, String label) {
        if (DEBUG_PARSE) {
            this.out.decIndent();
            this.out.print("< ");
            this.out.print(label);
            if (inline == Inline.INLINE) {
                this.out.print("'");
            }
            this.out.println();
        }
    }

    private void stack(String fmt, Object ... args) {
        if (DEBUG_PARSE) {
            this.out.print(String.format(fmt, args));
            this.out.println();
        }
    }

    private void debug(String fmt, Object ... args) {
        if (DEBUG_DEV) {
            this.out.print(String.format(fmt, args));
            this.out.println();
        }
    }

    private void debugNoIndent(String fmt, Object ... args) {
        if (DEBUG_DEV) {
            int x = this.out.getAbsoluteIndent();
            this.out.setAbsoluteIndent(0);
            this.out.print(String.format(fmt, args));
            if (!fmt.endsWith("\n")) {
                this.out.println();
            }
            this.out.setAbsoluteIndent(x);
        }
    }

    protected int startShapeExpression() {
        return this.startShapeExpression(Inline.NOT_INLINE);
    }

    protected void finishShapeExpression(int idx) {
        this.finishShapeExpression(Inline.NOT_INLINE, idx);
    }

    protected int startShapeOr() {
        return this.startShapeOr(Inline.NOT_INLINE);
    }

    protected void finishShapeOr(int idx) {
        this.finishShapeOr(Inline.NOT_INLINE, idx);
    }

    protected int startShapeAnd() {
        return this.startShapeAnd(Inline.NOT_INLINE);
    }

    protected void finishShapeAnd(int idx) {
        this.finishShapeAnd(Inline.NOT_INLINE, idx);
    }

    protected int startShapeNot() {
        return this.startShapeNot(Inline.NOT_INLINE);
    }

    protected void finishShapeNot(int idx, boolean negate) {
        this.finishShapeNot(Inline.NOT_INLINE, idx, negate);
    }

    protected int startShapeAtom() {
        return this.startShapeAtom(Inline.NOT_INLINE);
    }

    protected void finishShapeAtom(int idx) {
        this.finishShapeAtom(Inline.NOT_INLINE, idx);
    }

    protected int startInlineShapeExpression() {
        return this.startShapeExpression(Inline.INLINE);
    }

    protected void finishInlineShapeExpression(int idx) {
        this.finishShapeExpression(Inline.INLINE, idx);
    }

    protected int startInlineShapeOr() {
        return this.startShapeOr(Inline.INLINE);
    }

    protected void finishInlineShapeOr(int idx) {
        this.finishShapeOr(Inline.INLINE, idx);
    }

    protected int startInlineShapeAnd() {
        return this.startShapeAnd(Inline.INLINE);
    }

    protected void finishInlineShapeAnd(int idx) {
        this.finishShapeAnd(Inline.INLINE, idx);
    }

    protected int startInlineShapeNot() {
        return this.startShapeNot(Inline.INLINE);
    }

    protected void finishInlineShapeNot(int idx, boolean negate) {
        this.finishShapeNot(Inline.INLINE, idx, negate);
    }

    protected int startInlineShapeAtom() {
        return this.startShapeAtom(Inline.INLINE);
    }

    protected void finishInlineShapeAtom(int idx) {
        this.finishShapeAtom(Inline.INLINE, idx);
    }

    public void parseShapeMapStart() {
    }

    public ShapeMap parseShapeMapFinish() {
        return ShapeMap.create(this.associations);
    }

    protected Triple createTriple(Node s, Node p, Node o, int line, int column) {
        s = NodeUtils.nullToAny((Node)s);
        p = NodeUtils.nullToAny((Node)p);
        o = NodeUtils.nullToAny((Node)o);
        return Triple.create((Node)s, (Node)p, (Node)o);
    }

    protected void association(Node n, Triple t, Node label) {
        ShexRecord assoc;
        if (n != null && t != null) {
            throw new ShexParseException("Both node and triple in shape association");
        }
        if (n != null) {
            assoc = new ShexRecord(n, label);
        } else if (t != null) {
            assoc = new ShexRecord(t, label);
        } else {
            throw new ShexParseException("No node nor triple in shape association");
        }
        this.associations.add(assoc);
    }

    static enum Inline {
        INLINE,
        NOT_INLINE;

    }
}

