/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.PostgresqlConnectionConfiguration;
import io.r2dbc.postgresql.StatementCache;
import io.r2dbc.postgresql.api.PostgresqlConnection;
import io.r2dbc.postgresql.client.Client;
import io.r2dbc.postgresql.client.PortalNameSupplier;
import io.r2dbc.postgresql.codec.Codecs;
import io.r2dbc.postgresql.util.Assert;

final class ConnectionResources {
    private final Client client;
    private final Codecs codecs;
    private final PostgresqlConnection connection;
    private final PostgresqlConnectionConfiguration configuration;
    private final StatementCache statementCache;
    private final PortalNameSupplier portalNameSupplier;

    ConnectionResources(Client client, Codecs codecs, PostgresqlConnection connection, PostgresqlConnectionConfiguration configuration, PortalNameSupplier portalNameSupplier, StatementCache statementCache) {
        this.client = client;
        this.codecs = codecs;
        this.connection = connection;
        this.configuration = configuration;
        this.portalNameSupplier = Assert.requireNonNull(portalNameSupplier, "portalNameSupplier must not be null");
        this.statementCache = Assert.requireNonNull(statementCache, "statementCache must not be null");
    }

    public Client getClient() {
        return this.client;
    }

    public Codecs getCodecs() {
        return this.codecs;
    }

    public PostgresqlConnection getConnection() {
        return this.connection;
    }

    public PostgresqlConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    public PortalNameSupplier getPortalNameSupplier() {
        return this.portalNameSupplier;
    }

    public StatementCache getStatementCache() {
        return this.statementCache;
    }

    public String toString() {
        return "ConnectionContext{client=" + this.client + ", codecs=" + this.codecs + ", connection=" + this.connection + ", configuration=" + this.configuration + ", portalNameSupplier=" + this.portalNameSupplier + ", statementCache=" + this.statementCache + '}';
    }
}

