/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.cassandra.mail.task.MessageInconsistenciesEntry;
import org.apache.james.mailbox.cassandra.mail.task.RunningOptionsDTO;
import org.apache.james.mailbox.cassandra.mail.task.SolveMessageInconsistenciesService;
import org.apache.james.mailbox.cassandra.mail.task.SolveMessageInconsistenciesTask;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;

public class SolveMessageInconsistenciesTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final Instant timestamp;
    private final String type;
    private final long processedImapUidEntries;
    private final long processedMessageIdEntries;
    private final long addedMessageIdEntries;
    private final long updatedMessageIdEntries;
    private final long removedMessageIdEntries;
    private final Optional<RunningOptionsDTO> runningOptions;
    private final ImmutableList<MessageInconsistenciesEntry> fixedInconsistencies;
    private final ImmutableList<MessageInconsistenciesEntry> errors;

    private static SolveMessageInconsistenciesTaskAdditionalInformationDTO fromDomainObject(SolveMessageInconsistenciesTask.Details details, String type) {
        return new SolveMessageInconsistenciesTaskAdditionalInformationDTO(details.timestamp(), type, details.getProcessedImapUidEntries(), details.getProcessedMessageIdEntries(), details.getAddedMessageIdEntries(), details.getUpdatedMessageIdEntries(), details.getRemovedMessageIdEntries(), Optional.of(RunningOptionsDTO.asDTO(details.getRunningOptions())), details.getFixedInconsistencies(), details.getErrors());
    }

    public static AdditionalInformationDTOModule<SolveMessageInconsistenciesTask.Details, SolveMessageInconsistenciesTaskAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(SolveMessageInconsistenciesTask.Details.class).convertToDTO(SolveMessageInconsistenciesTaskAdditionalInformationDTO.class).toDomainObjectConverter(SolveMessageInconsistenciesTaskAdditionalInformationDTO::toDomainObject).toDTOConverter(SolveMessageInconsistenciesTaskAdditionalInformationDTO::fromDomainObject).typeName(SolveMessageInconsistenciesTask.SOLVE_MESSAGE_INCONSISTENCIES.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    public SolveMessageInconsistenciesTaskAdditionalInformationDTO(@JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="type") String type, @JsonProperty(value="processedImapUidEntries") long processedImapUidEntries, @JsonProperty(value="processedMessageIdEntries") long processedMessageIdEntries, @JsonProperty(value="addedMessageIdEntries") long addedMessageIdEntries, @JsonProperty(value="updatedMessageIdEntries") long updatedMessageIdEntries, @JsonProperty(value="removedMessageIdEntries") long removedMessageIdEntries, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions, @JsonProperty(value="fixedInconsistencies") ImmutableList<MessageInconsistenciesEntry> fixedInconsistencies, @JsonProperty(value="errors") ImmutableList<MessageInconsistenciesEntry> errors) {
        this.timestamp = timestamp;
        this.type = type;
        this.processedImapUidEntries = processedImapUidEntries;
        this.processedMessageIdEntries = processedMessageIdEntries;
        this.addedMessageIdEntries = addedMessageIdEntries;
        this.updatedMessageIdEntries = updatedMessageIdEntries;
        this.removedMessageIdEntries = removedMessageIdEntries;
        this.runningOptions = runningOptions;
        this.fixedInconsistencies = fixedInconsistencies;
        this.errors = errors;
    }

    public long getProcessedImapUidEntries() {
        return this.processedImapUidEntries;
    }

    public long getProcessedMessageIdEntries() {
        return this.processedMessageIdEntries;
    }

    public long getAddedMessageIdEntries() {
        return this.addedMessageIdEntries;
    }

    public long getUpdatedMessageIdEntries() {
        return this.updatedMessageIdEntries;
    }

    public long getRemovedMessageIdEntries() {
        return this.removedMessageIdEntries;
    }

    public Optional<RunningOptionsDTO> getRunningOptions() {
        return this.runningOptions;
    }

    public ImmutableList<MessageInconsistenciesEntry> getFixedInconsistencies() {
        return this.fixedInconsistencies;
    }

    public ImmutableList<MessageInconsistenciesEntry> getErrors() {
        return this.errors;
    }

    public String getType() {
        return this.type;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    private SolveMessageInconsistenciesTask.Details toDomainObject() {
        return new SolveMessageInconsistenciesTask.Details(this.timestamp, this.processedImapUidEntries, this.processedMessageIdEntries, this.addedMessageIdEntries, this.updatedMessageIdEntries, this.removedMessageIdEntries, this.runningOptions.map(RunningOptionsDTO::asDomainObject).orElse(SolveMessageInconsistenciesService.RunningOptions.DEFAULT), this.fixedInconsistencies, this.errors);
    }
}

