/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import jakarta.inject.Inject;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.utils.MailboxBaseTupleUtil;
import org.apache.james.mailbox.cassandra.table.CassandraMailboxTable;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMailboxDAO {
    private final CassandraAsyncExecutor executor;
    private final MailboxBaseTupleUtil mailboxBaseTupleUtil;
    private final PreparedStatement readStatement;
    private final PreparedStatement listStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement insertStatement;
    private final PreparedStatement updateStatement;
    private final PreparedStatement updateUidValidityStatement;
    private final CqlSession session;
    private final TypeCodec<UdtValue> mailboxBaseTypeCodec;

    @Inject
    public CassandraMailboxDAO(CqlSession session, CassandraTypesProvider typesProvider) {
        this.session = session;
        this.executor = new CassandraAsyncExecutor(session);
        this.mailboxBaseTupleUtil = new MailboxBaseTupleUtil(typesProvider);
        this.insertStatement = this.prepareInsert();
        this.updateStatement = this.prepareUpdate();
        this.updateUidValidityStatement = this.prepareUpdateUidValidity();
        this.deleteStatement = this.prepareDelete();
        this.listStatement = this.prepareList();
        this.readStatement = this.prepareRead();
        this.mailboxBaseTypeCodec = CodecRegistry.DEFAULT.codecFor((DataType)typesProvider.getDefinedUserType(CassandraMailboxTable.MAILBOX_BASE.asCql(true)));
    }

    private PreparedStatement prepareInsert() {
        return this.session.prepare(QueryBuilder.insertInto((String)"mailbox").value(CassandraMailboxTable.ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxTable.ID)).value(CassandraMailboxTable.NAME, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxTable.NAME)).value(CassandraMailboxTable.UIDVALIDITY, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxTable.UIDVALIDITY)).value(CassandraMailboxTable.MAILBOX_BASE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxTable.MAILBOX_BASE)).build());
    }

    private PreparedStatement prepareUpdate() {
        return this.session.prepare(((Update)QueryBuilder.update((String)"mailbox").set(new Assignment[]{Assignment.setColumn((CqlIdentifier)CassandraMailboxTable.MAILBOX_BASE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxTable.MAILBOX_BASE)), Assignment.setColumn((CqlIdentifier)CassandraMailboxTable.NAME, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxTable.NAME))}).where((Relation)Relation.column((CqlIdentifier)CassandraMailboxTable.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxTable.ID)))).build());
    }

    private PreparedStatement prepareUpdateUidValidity() {
        return this.session.prepare(((Update)QueryBuilder.update((String)"mailbox").setColumn(CassandraMailboxTable.UIDVALIDITY, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxTable.UIDVALIDITY)).where((Relation)Relation.column((CqlIdentifier)CassandraMailboxTable.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxTable.ID)))).build());
    }

    private PreparedStatement prepareDelete() {
        return this.session.prepare(((Delete)QueryBuilder.deleteFrom((String)"mailbox").where((Relation)Relation.column((CqlIdentifier)CassandraMailboxTable.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxTable.ID)))).build());
    }

    private PreparedStatement prepareList() {
        return this.session.prepare(QueryBuilder.selectFrom((String)"mailbox").columns(CassandraMailboxTable.FIELDS).build());
    }

    private PreparedStatement prepareRead() {
        return this.session.prepare(((Select)QueryBuilder.selectFrom((String)"mailbox").columns(CassandraMailboxTable.FIELDS).where((Relation)Relation.column((CqlIdentifier)CassandraMailboxTable.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxTable.ID)))).build());
    }

    public Mono<Void> save(Mailbox mailbox) {
        CassandraId cassandraId = (CassandraId)mailbox.getMailboxId();
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)this.insertStatement.bind(new Object[0]).setUuid(CassandraMailboxTable.ID, cassandraId.asUuid())).setString(CassandraMailboxTable.NAME, mailbox.getName())).setLong(CassandraMailboxTable.UIDVALIDITY, mailbox.getUidValidity().asLong())).setUdtValue(CassandraMailboxTable.MAILBOX_BASE, this.mailboxBaseTupleUtil.createMailboxBaseUDT(mailbox.getNamespace(), mailbox.getUser())));
    }

    public Mono<Void> updatePath(CassandraId mailboxId, MailboxPath mailboxPath) {
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.updateStatement.bind(new Object[0]).setUuid(CassandraMailboxTable.ID, mailboxId.asUuid())).setString(CassandraMailboxTable.NAME, mailboxPath.getName())).setUdtValue(CassandraMailboxTable.MAILBOX_BASE, this.mailboxBaseTupleUtil.createMailboxBaseUDT(mailboxPath.getNamespace(), mailboxPath.getUser())));
    }

    public Mono<Void> delete(CassandraId mailboxId) {
        return this.executor.executeVoid((Statement)this.deleteStatement.bind(new Object[0]).setUuid(CassandraMailboxTable.ID, mailboxId.asUuid()));
    }

    public Mono<Mailbox> retrieveMailbox(CassandraId mailboxId) {
        return this.executor.executeSingleRow((Statement)this.readStatement.bind(new Object[0]).set(CassandraMailboxTable.ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).flatMap(row -> this.mailboxFromRow((Row)row, mailboxId));
    }

    private Mono<Mailbox> mailboxFromRow(Row row, CassandraId cassandraId) {
        return this.sanitizeUidValidity(cassandraId, row.getLong(CassandraMailboxTable.UIDVALIDITY)).map(uidValidity -> {
            UdtValue mailboxBase = (UdtValue)row.get(CassandraMailboxTable.MAILBOX_BASE, this.mailboxBaseTypeCodec);
            return new Mailbox(new MailboxPath((String)mailboxBase.get(CassandraMailboxTable.MailboxBase.NAMESPACE, TypeCodecs.TEXT), Username.of((String)((String)mailboxBase.get(CassandraMailboxTable.MailboxBase.USER, TypeCodecs.TEXT))), (String)row.get(CassandraMailboxTable.NAME, TypeCodecs.TEXT)), uidValidity, (MailboxId)cassandraId);
        });
    }

    private Mono<UidValidity> sanitizeUidValidity(CassandraId cassandraId, long uidValidityAsLong) {
        if (!UidValidity.isValid((long)uidValidityAsLong)) {
            UidValidity newUidValidity = UidValidity.generate();
            return this.updateUidValidity(cassandraId, newUidValidity).then(Mono.just((Object)newUidValidity));
        }
        return Mono.just((Object)UidValidity.of((long)uidValidityAsLong));
    }

    private Mono<Void> updateUidValidity(CassandraId cassandraId, UidValidity uidValidity) {
        return this.executor.executeVoid((Statement)((BoundStatement)this.updateUidValidityStatement.bind(new Object[0]).setUuid(CassandraMailboxTable.ID, cassandraId.asUuid())).setLong(CassandraMailboxTable.UIDVALIDITY, uidValidity.asLong()));
    }

    public Flux<Mailbox> retrieveAllMailboxes() {
        return this.executor.executeRows((Statement)this.listStatement.bind(new Object[0])).flatMap(this::toMailboxWithId, 16);
    }

    private Mono<Mailbox> toMailboxWithId(Row row) {
        return this.mailboxFromRow(row, CassandraId.of(row.getUuid(CassandraMailboxTable.ID)));
    }
}

