/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import java.net.InetSocketAddress;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class TopologyEvent {
    public final Type type;
    public final InetSocketAddress broadcastRpcAddress;

    public static TopologyEvent suggestUp(InetSocketAddress broadcastRpcAddress) {
        return new TopologyEvent(Type.SUGGEST_UP, broadcastRpcAddress);
    }

    public static TopologyEvent suggestDown(InetSocketAddress broadcastRpcAddress) {
        return new TopologyEvent(Type.SUGGEST_DOWN, broadcastRpcAddress);
    }

    public static TopologyEvent forceDown(InetSocketAddress broadcastRpcAddress) {
        return new TopologyEvent(Type.FORCE_DOWN, broadcastRpcAddress);
    }

    public static TopologyEvent forceUp(InetSocketAddress broadcastRpcAddress) {
        return new TopologyEvent(Type.FORCE_UP, broadcastRpcAddress);
    }

    public static TopologyEvent suggestAdded(InetSocketAddress broadcastRpcAddress) {
        return new TopologyEvent(Type.SUGGEST_ADDED, broadcastRpcAddress);
    }

    public static TopologyEvent suggestRemoved(InetSocketAddress broadcastRpcAddress) {
        return new TopologyEvent(Type.SUGGEST_REMOVED, broadcastRpcAddress);
    }

    public TopologyEvent(Type type, InetSocketAddress broadcastRpcAddress) {
        this.type = type;
        this.broadcastRpcAddress = broadcastRpcAddress;
    }

    public boolean isForceEvent() {
        return this.type == Type.FORCE_DOWN || this.type == Type.FORCE_UP;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TopologyEvent) {
            TopologyEvent that = (TopologyEvent)other;
            return this.type == that.type && Objects.equals(this.broadcastRpcAddress, that.broadcastRpcAddress);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.broadcastRpcAddress});
    }

    public String toString() {
        return "TopologyEvent(" + (Object)((Object)this.type) + ", " + this.broadcastRpcAddress + ")";
    }

    public static enum Type {
        SUGGEST_UP,
        SUGGEST_DOWN,
        FORCE_UP,
        FORCE_DOWN,
        SUGGEST_ADDED,
        SUGGEST_REMOVED;

    }
}

