/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.transcode;

import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.managesieve.api.ManageSieveException;
import org.apache.james.managesieve.api.Session;
import org.apache.james.managesieve.api.SessionTerminatedException;
import org.apache.james.managesieve.transcode.ArgumentParser;
import org.apache.james.sieverepository.api.exception.SieveRepositoryException;

public class ManageSieveProcessor {
    public static final String AUTHENTICATE = "AUTHENTICATE";
    public static final String CAPABILITY = "CAPABILITY";
    public static final String CHECKSCRIPT = "CHECKSCRIPT";
    public static final String DELETESCRIPT = "DELETESCRIPT";
    public static final String GETACTIVE = "GETACTIVE";
    public static final String GETSCRIPT = "GETSCRIPT";
    public static final String HAVESPACE = "HAVESPACE";
    public static final String LISTSCRIPTS = "LISTSCRIPTS";
    public static final String LOGOUT = "LOGOUT";
    public static final String NOOP = "NOOP";
    public static final String PUTSCRIPT = "PUTSCRIPT";
    public static final String RENAMESCRIPT = "RENAMESCRIPT";
    public static final String SETACTIVE = "SETACTIVE";
    public static final String STARTTLS = "STARTTLS";
    public static final String UNAUTHENTICATE = "UNAUTHENTICATE";
    private final ArgumentParser argumentParser;

    @Inject
    public ManageSieveProcessor(ArgumentParser argumentParser) {
        this.argumentParser = argumentParser;
    }

    public String handleRequest(Session session, String request) throws ManageSieveException, SieveRepositoryException {
        int firstWordEndIndex = request.indexOf(32);
        String arguments = this.parseArguments(request, firstWordEndIndex);
        String command = this.parseCommand(request, firstWordEndIndex);
        return this.matchCommandWithImplementation(session, arguments, command) + "\r\n";
    }

    private String parseCommand(String request, int firstWordEndIndex) {
        String command = request.contains(" ") ? request.substring(0, firstWordEndIndex) : request;
        if (command.endsWith("\n")) {
            command = command.substring(0, command.length() - 1);
        }
        if (command.endsWith("\r")) {
            command = command.substring(0, command.length() - 1);
        }
        return command;
    }

    private String parseArguments(String request, int firstWordEndIndex) {
        if (request.contains(" ")) {
            return request.substring(firstWordEndIndex).trim();
        }
        return "";
    }

    private String matchCommandWithImplementation(Session session, String arguments, String command) throws SessionTerminatedException {
        if (session.getState() == Session.State.AUTHENTICATION_IN_PROGRESS) {
            return this.argumentParser.authenticate(session, arguments);
        }
        if (command.equalsIgnoreCase(AUTHENTICATE)) {
            if (StringUtils.countMatches((CharSequence)arguments, (CharSequence)"\"") == 4) {
                this.argumentParser.chooseMechanism(session, arguments);
                int bracket1 = arguments.indexOf(34);
                int bracket2 = arguments.indexOf(34, bracket1 + 1);
                int bracket3 = arguments.indexOf(34, bracket2 + 1);
                int bracket4 = arguments.indexOf(34, bracket3 + 1);
                return this.argumentParser.authenticate(session, arguments.substring(bracket3 + 1, bracket4));
            }
            return this.argumentParser.chooseMechanism(session, arguments);
        }
        if (command.equalsIgnoreCase(CAPABILITY)) {
            return this.argumentParser.capability(session, arguments);
        }
        if (command.equalsIgnoreCase(CHECKSCRIPT)) {
            return this.argumentParser.checkScript(session, arguments);
        }
        if (command.equalsIgnoreCase(DELETESCRIPT)) {
            return this.argumentParser.deleteScript(session, arguments);
        }
        if (command.equalsIgnoreCase(GETSCRIPT)) {
            return this.argumentParser.getScript(session, arguments);
        }
        if (command.equalsIgnoreCase(HAVESPACE)) {
            return this.argumentParser.haveSpace(session, arguments);
        }
        if (command.equalsIgnoreCase(LISTSCRIPTS)) {
            return this.argumentParser.listScripts(session, arguments);
        }
        if (command.equalsIgnoreCase(LOGOUT)) {
            this.argumentParser.logout();
        } else {
            if (command.equalsIgnoreCase(NOOP)) {
                return this.argumentParser.noop(arguments);
            }
            if (command.equalsIgnoreCase(PUTSCRIPT)) {
                return this.argumentParser.putScript(session, arguments);
            }
            if (command.equalsIgnoreCase(RENAMESCRIPT)) {
                return this.argumentParser.renameScript(session, arguments);
            }
            if (command.equalsIgnoreCase(SETACTIVE)) {
                return this.argumentParser.setActive(session, arguments);
            }
            if (command.equalsIgnoreCase(STARTTLS)) {
                return this.argumentParser.startTLS(session);
            }
            if (command.equalsIgnoreCase(UNAUTHENTICATE)) {
                return this.argumentParser.unauthenticate(session, arguments);
            }
        }
        return "NO unknown " + command + " command";
    }

    public String getAdvertisedCapabilities() {
        return this.argumentParser.getAdvertisedCapabilities();
    }
}

