/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j;

import java.io.File;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.james.mime4j.stream.MimeConfig;

public abstract class ExampleMessageTestCase
extends TestCase {
    private final File file;
    private final URL resource;

    protected ExampleMessageTestCase(File file, URL resource) {
        super(file.getName());
        this.file = file;
        this.resource = resource;
    }

    public File getSourceFile() {
        return this.file;
    }

    public URL getResource() {
        return this.resource;
    }

    public String getResourceBase() {
        String s;
        String r = this.resource.toString();
        if (r.endsWith(s = this.file.getName())) {
            return r.substring(0, r.length() - s.length()) + this.getFilenameBase();
        }
        return r;
    }

    public String getFilenameBase() {
        String s = this.file.getName();
        int idx = s.indexOf(46);
        if (idx != -1) {
            return s.substring(0, idx);
        }
        return s;
    }

    public MimeConfig getConfig() {
        MimeConfig.Builder b = MimeConfig.custom();
        if (this.file.getName().startsWith("malformedHeaderStartsBody")) {
            b.setMalformedHeaderStartsBody(true);
        }
        b.setMaxLineLen(-1);
        return b.build();
    }
}

