/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import javax.jcr.RepositoryException;

import java.io.IOException;
import java.util.Properties;

import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.impl.PackagePropertiesImpl;

public class JcrPackageProperties extends PackagePropertiesImpl {

    private JcrPackage pkg;

    public JcrPackageProperties(JcrPackage pkg) {
        this.pkg = pkg;
    }

    @Override
    protected Properties getPropertiesMap() {
        try {
            return pkg.getPackage().getMetaInf().getProperties();
        } catch (RepositoryException | IOException e) {
            throw new IllegalStateException(e);
        }
    }
}
