/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.jackrabbit.vault.fs.api;

import org.jetbrains.annotations.NotNull;

/**
 * {@code Dumpable}...
 *
 */
public interface Dumpable {

    /**
     * Dumps some human readable information using the given context.
     *
     * @param ctx the dump context
     * @param isLast specifies if this is the last element to dump on this level
     */
    void dump(@NotNull DumpContext ctx, boolean isLast);
}
