/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jtransforms.dht.DoubleDHT_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;

public class DoubleDHT_3D {
    private int slices;
    private long slicesl;
    private int rows;
    private long rowsl;
    private int columns;
    private long columnsl;
    private int sliceStride;
    private long sliceStridel;
    private int rowStride;
    private long rowStridel;
    private DoubleDHT_1D dhtSlices;
    private DoubleDHT_1D dhtRows;
    private DoubleDHT_1D dhtColumns;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDHT_3D(long slices, long rows, long columns) {
        if (slices <= 1L || rows <= 1L || columns <= 1L) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = (int)slices;
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.slicesl = slices;
        this.rowsl = rows;
        this.columnsl = columns;
        this.sliceStride = (int)(rows * columns);
        this.rowStride = (int)columns;
        this.sliceStridel = rows * columns;
        this.rowStridel = columns;
        if (slices * rows * columns >= CommonUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (CommonUtils.isPowerOf2(slices) && CommonUtils.isPowerOf2(rows) && CommonUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
        }
        CommonUtils.setUseLargeArrays(slices * rows * columns > (long)LargeArray.getMaxSizeOf32bitArray());
        this.dhtSlices = new DoubleDHT_1D(slices);
        this.dhtRows = slices == rows ? this.dhtSlices : new DoubleDHT_1D(rows);
        this.dhtColumns = slices == columns ? this.dhtSlices : (rows == columns ? this.dhtRows : new DoubleDHT_1D(columns));
    }

    public void forward(final double[] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, true);
                this.ddxt3db_subth(-1, a, true);
            } else {
                this.ddxt3da_sub(-1, a, true);
                this.ddxt3db_sub(-1, a, true);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                int idx1 = s2 * DoubleDHT_3D.this.sliceStride;
                                for (int r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                    DoubleDHT_3D.this.dhtColumns.forward(a, idx1 + r * DoubleDHT_3D.this.rowStride);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.rows];
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                int idx1 = s2 * DoubleDHT_3D.this.sliceStride;
                                for (int c = 0; c < DoubleDHT_3D.this.columns; ++c) {
                                    int idx3;
                                    int r;
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        idx3 = idx1 + r * DoubleDHT_3D.this.rowStride + c;
                                        temp[r] = a[idx3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(temp);
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        idx3 = idx1 + r * DoubleDHT_3D.this.rowStride + c;
                                        a[idx3] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int startRow = l * p;
                    final int stopRow = l == nthreads - 1 ? this.rows : startRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.slices];
                            for (int r = startRow; r < stopRow; ++r) {
                                int idx1 = r * DoubleDHT_3D.this.rowStride;
                                for (int c = 0; c < DoubleDHT_3D.this.columns; ++c) {
                                    int idx3;
                                    int s2;
                                    for (s2 = 0; s2 < DoubleDHT_3D.this.slices; ++s2) {
                                        idx3 = s2 * DoubleDHT_3D.this.sliceStride + idx1 + c;
                                        temp[s2] = a[idx3];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.forward(temp);
                                    for (s2 = 0; s2 < DoubleDHT_3D.this.slices; ++s2) {
                                        idx3 = s2 * DoubleDHT_3D.this.sliceStride + idx1 + c;
                                        a[idx3] = temp[s2];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int idx3;
                int c;
                int idx1;
                for (int s2 = 0; s2 < this.slices; ++s2) {
                    int idx12 = s2 * this.sliceStride;
                    for (int r = 0; r < this.rows; ++r) {
                        this.dhtColumns.forward(a, idx12 + r * this.rowStride);
                    }
                }
                double[] temp = new double[this.rows];
                for (int s3 = 0; s3 < this.slices; ++s3) {
                    idx1 = s3 * this.sliceStride;
                    for (c = 0; c < this.columns; ++c) {
                        int r;
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c;
                            temp[r] = a[idx3];
                        }
                        this.dhtRows.forward(temp);
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c;
                            a[idx3] = temp[r];
                        }
                    }
                }
                temp = new double[this.slices];
                for (int r = 0; r < this.rows; ++r) {
                    idx1 = r * this.rowStride;
                    for (c = 0; c < this.columns; ++c) {
                        int s4;
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx3 = s4 * this.sliceStride + idx1 + c;
                            temp[s4] = a[idx3];
                        }
                        this.dhtSlices.forward(temp);
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx3 = s4 * this.sliceStride + idx1 + c;
                            a[idx3] = temp[s4];
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void forward(final DoubleLargeArray a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, true);
                this.ddxt3db_subth(-1, a, true);
            } else {
                this.ddxt3da_sub(-1, a, true);
                this.ddxt3db_sub(-1, a, true);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                long lastSlice;
                long firstSlice;
                Future[] futures = new Future[nthreads];
                long p = this.slicesl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = (long)l * p;
                    lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                                long idx1 = s2 * (long)DoubleDHT_3D.this.sliceStride;
                                for (long r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                    DoubleDHT_3D.this.dhtColumns.forward(a, idx1 + r * (long)DoubleDHT_3D.this.rowStride);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = (long)l * p;
                    lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray temp = new DoubleLargeArray(DoubleDHT_3D.this.rowsl, false);
                            for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                                long idx1 = s2 * (long)DoubleDHT_3D.this.sliceStride;
                                for (long c = 0L; c < DoubleDHT_3D.this.columnsl; ++c) {
                                    long idx3;
                                    long r;
                                    for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                        idx3 = idx1 + r * (long)DoubleDHT_3D.this.rowStride + c;
                                        temp.setDouble(r, a.getDouble(idx3));
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(temp);
                                    for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                        idx3 = idx1 + r * (long)DoubleDHT_3D.this.rowStride + c;
                                        a.setDouble(idx3, temp.getDouble(r));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rowsl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final long startRow = (long)l * p;
                    final long stopRow = l == nthreads - 1 ? this.rowsl : startRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray temp = new DoubleLargeArray(DoubleDHT_3D.this.slicesl, false);
                            for (long r = startRow; r < stopRow; ++r) {
                                long idx1 = r * (long)DoubleDHT_3D.this.rowStride;
                                for (long c = 0L; c < DoubleDHT_3D.this.columnsl; ++c) {
                                    long idx3;
                                    long s2;
                                    for (s2 = 0L; s2 < DoubleDHT_3D.this.slicesl; ++s2) {
                                        idx3 = s2 * (long)DoubleDHT_3D.this.sliceStride + idx1 + c;
                                        temp.setDouble(s2, a.getDouble(idx3));
                                    }
                                    DoubleDHT_3D.this.dhtSlices.forward(temp);
                                    for (s2 = 0L; s2 < DoubleDHT_3D.this.slicesl; ++s2) {
                                        idx3 = s2 * (long)DoubleDHT_3D.this.sliceStride + idx1 + c;
                                        a.setDouble(idx3, temp.getDouble(s2));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                long idx3;
                long c;
                long idx1;
                for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                    long idx12 = s2 * (long)this.sliceStride;
                    for (long r = 0L; r < this.rowsl; ++r) {
                        this.dhtColumns.forward(a, idx12 + r * (long)this.rowStride);
                    }
                }
                DoubleLargeArray temp = new DoubleLargeArray(this.rowsl, false);
                for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                    idx1 = s3 * (long)this.sliceStride;
                    for (c = 0L; c < this.columnsl; ++c) {
                        long r;
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + r * (long)this.rowStride + c;
                            temp.setDouble(r, a.getDouble(idx3));
                        }
                        this.dhtRows.forward(temp);
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + r * (long)this.rowStride + c;
                            a.setDouble(idx3, temp.getDouble(r));
                        }
                    }
                }
                temp = new DoubleLargeArray(this.slicesl, false);
                for (long r = 0L; r < this.rowsl; ++r) {
                    idx1 = r * (long)this.rowStride;
                    for (c = 0L; c < this.columnsl; ++c) {
                        long s4;
                        for (s4 = 0L; s4 < this.slicesl; ++s4) {
                            idx3 = s4 * (long)this.sliceStride + idx1 + c;
                            temp.setDouble(s4, a.getDouble(idx3));
                        }
                        this.dhtSlices.forward(temp);
                        for (s4 = 0L; s4 < this.slicesl; ++s4) {
                            idx3 = s4 * (long)this.sliceStride + idx1 + c;
                            a.setDouble(idx3, temp.getDouble(s4));
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void forward(final double[][][] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, true);
                this.ddxt3db_subth(-1, a, true);
            } else {
                this.ddxt3da_sub(-1, a, true);
                this.ddxt3db_sub(-1, a, true);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                for (int r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                    DoubleDHT_3D.this.dhtColumns.forward(a[s2][r]);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.rows];
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                for (int c = 0; c < DoubleDHT_3D.this.columns; ++c) {
                                    int r;
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        temp[r] = a[s2][r][c];
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(temp);
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        a[s2][r][c] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < DoubleDHT_3D.this.columns; ++c) {
                                    int s2;
                                    for (s2 = 0; s2 < DoubleDHT_3D.this.slices; ++s2) {
                                        temp[s2] = a[s2][r][c];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.forward(temp);
                                    for (s2 = 0; s2 < DoubleDHT_3D.this.slices; ++s2) {
                                        a[s2][r][c] = temp[s2];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int c;
                int r;
                for (int s2 = 0; s2 < this.slices; ++s2) {
                    for (r = 0; r < this.rows; ++r) {
                        this.dhtColumns.forward(a[s2][r]);
                    }
                }
                double[] temp = new double[this.rows];
                for (int s3 = 0; s3 < this.slices; ++s3) {
                    for (c = 0; c < this.columns; ++c) {
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            temp[r2] = a[s3][r2][c];
                        }
                        this.dhtRows.forward(temp);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            a[s3][r2][c] = temp[r2];
                        }
                    }
                }
                temp = new double[this.slices];
                for (r = 0; r < this.rows; ++r) {
                    for (c = 0; c < this.columns; ++c) {
                        int s4;
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            temp[s4] = a[s4][r][c];
                        }
                        this.dhtSlices.forward(temp);
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            a[s4][r][c] = temp[s4];
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                int idx1 = s2 * DoubleDHT_3D.this.sliceStride;
                                for (int r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                    DoubleDHT_3D.this.dhtColumns.inverse(a, idx1 + r * DoubleDHT_3D.this.rowStride, scale);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.rows];
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                int idx1 = s2 * DoubleDHT_3D.this.sliceStride;
                                for (int c = 0; c < DoubleDHT_3D.this.columns; ++c) {
                                    int idx3;
                                    int r;
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        idx3 = idx1 + r * DoubleDHT_3D.this.rowStride + c;
                                        temp[r] = a[idx3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(temp, scale);
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        idx3 = idx1 + r * DoubleDHT_3D.this.rowStride + c;
                                        a[idx3] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                int idx1 = r * DoubleDHT_3D.this.rowStride;
                                for (int c = 0; c < DoubleDHT_3D.this.columns; ++c) {
                                    int idx3;
                                    int s2;
                                    for (s2 = 0; s2 < DoubleDHT_3D.this.slices; ++s2) {
                                        idx3 = s2 * DoubleDHT_3D.this.sliceStride + idx1 + c;
                                        temp[s2] = a[idx3];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(temp, scale);
                                    for (s2 = 0; s2 < DoubleDHT_3D.this.slices; ++s2) {
                                        idx3 = s2 * DoubleDHT_3D.this.sliceStride + idx1 + c;
                                        a[idx3] = temp[s2];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int idx3;
                int c;
                int idx1;
                for (int s2 = 0; s2 < this.slices; ++s2) {
                    int idx12 = s2 * this.sliceStride;
                    for (int r = 0; r < this.rows; ++r) {
                        this.dhtColumns.inverse(a, idx12 + r * this.rowStride, scale);
                    }
                }
                double[] temp = new double[this.rows];
                for (int s3 = 0; s3 < this.slices; ++s3) {
                    idx1 = s3 * this.sliceStride;
                    for (c = 0; c < this.columns; ++c) {
                        int r;
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c;
                            temp[r] = a[idx3];
                        }
                        this.dhtRows.inverse(temp, scale);
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c;
                            a[idx3] = temp[r];
                        }
                    }
                }
                temp = new double[this.slices];
                for (int r = 0; r < this.rows; ++r) {
                    idx1 = r * this.rowStride;
                    for (c = 0; c < this.columns; ++c) {
                        int s4;
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx3 = s4 * this.sliceStride + idx1 + c;
                            temp[s4] = a[idx3];
                        }
                        this.dhtSlices.inverse(temp, scale);
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx3 = s4 * this.sliceStride + idx1 + c;
                            a[idx3] = temp[s4];
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final DoubleLargeArray a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                long lastSlice;
                long firstSlice;
                Future[] futures = new Future[nthreads];
                long p = this.slicesl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = (long)l * p;
                    lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                                long idx1 = s2 * DoubleDHT_3D.this.sliceStridel;
                                for (long r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                    DoubleDHT_3D.this.dhtColumns.inverse(a, idx1 + r * DoubleDHT_3D.this.rowStridel, scale);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = (long)l * p;
                    lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray temp = new DoubleLargeArray(DoubleDHT_3D.this.rowsl, false);
                            for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                                long idx1 = s2 * DoubleDHT_3D.this.sliceStridel;
                                for (long c = 0L; c < DoubleDHT_3D.this.columnsl; ++c) {
                                    long idx3;
                                    long r;
                                    for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                        idx3 = idx1 + r * DoubleDHT_3D.this.rowStridel + c;
                                        temp.setDouble(r, a.getDouble(idx3));
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(temp, scale);
                                    for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                        idx3 = idx1 + r * DoubleDHT_3D.this.rowStridel + c;
                                        a.setDouble(idx3, temp.getDouble(r));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rowsl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final long firstRow = (long)l * p;
                    final long lastRow = l == nthreads - 1 ? this.rowsl : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray temp = new DoubleLargeArray(DoubleDHT_3D.this.slicesl, false);
                            for (long r = firstRow; r < lastRow; ++r) {
                                long idx1 = r * DoubleDHT_3D.this.rowStridel;
                                for (long c = 0L; c < DoubleDHT_3D.this.columnsl; ++c) {
                                    long idx3;
                                    long s2;
                                    for (s2 = 0L; s2 < DoubleDHT_3D.this.slicesl; ++s2) {
                                        idx3 = s2 * DoubleDHT_3D.this.sliceStridel + idx1 + c;
                                        temp.setDouble(s2, a.getDouble(idx3));
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(temp, scale);
                                    for (s2 = 0L; s2 < DoubleDHT_3D.this.slicesl; ++s2) {
                                        idx3 = s2 * DoubleDHT_3D.this.sliceStridel + idx1 + c;
                                        a.setDouble(idx3, temp.getDouble(s2));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                long idx3;
                long c;
                long idx1;
                for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                    long idx12 = s2 * this.sliceStridel;
                    for (long r = 0L; r < this.rowsl; ++r) {
                        this.dhtColumns.inverse(a, idx12 + r * this.rowStridel, scale);
                    }
                }
                DoubleLargeArray temp = new DoubleLargeArray(this.rowsl, false);
                for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                    idx1 = s3 * this.sliceStridel;
                    for (c = 0L; c < this.columnsl; ++c) {
                        long r;
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + r * this.rowStridel + c;
                            temp.setDouble(r, a.getDouble(idx3));
                        }
                        this.dhtRows.inverse(temp, scale);
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + r * this.rowStridel + c;
                            a.setDouble(idx3, temp.getDouble(r));
                        }
                    }
                }
                temp = new DoubleLargeArray(this.slicesl, false);
                for (long r = 0L; r < this.rowsl; ++r) {
                    idx1 = r * this.rowStridel;
                    for (c = 0L; c < this.columnsl; ++c) {
                        long s4;
                        for (s4 = 0L; s4 < this.slicesl; ++s4) {
                            idx3 = s4 * this.sliceStridel + idx1 + c;
                            temp.setDouble(s4, a.getDouble(idx3));
                        }
                        this.dhtSlices.inverse(temp, scale);
                        for (s4 = 0L; s4 < this.slicesl; ++s4) {
                            idx3 = s4 * this.sliceStridel + idx1 + c;
                            a.setDouble(idx3, temp.getDouble(s4));
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final double[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                for (int r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                    DoubleDHT_3D.this.dhtColumns.inverse(a[s2][r], scale);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.rows];
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                for (int c = 0; c < DoubleDHT_3D.this.columns; ++c) {
                                    int r;
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        temp[r] = a[s2][r][c];
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(temp, scale);
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        a[s2][r][c] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < DoubleDHT_3D.this.columns; ++c) {
                                    int s2;
                                    for (s2 = 0; s2 < DoubleDHT_3D.this.slices; ++s2) {
                                        temp[s2] = a[s2][r][c];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(temp, scale);
                                    for (s2 = 0; s2 < DoubleDHT_3D.this.slices; ++s2) {
                                        a[s2][r][c] = temp[s2];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int c;
                int r;
                for (int s2 = 0; s2 < this.slices; ++s2) {
                    for (r = 0; r < this.rows; ++r) {
                        this.dhtColumns.inverse(a[s2][r], scale);
                    }
                }
                double[] temp = new double[this.rows];
                for (int s3 = 0; s3 < this.slices; ++s3) {
                    for (c = 0; c < this.columns; ++c) {
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            temp[r2] = a[s3][r2][c];
                        }
                        this.dhtRows.inverse(temp, scale);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            a[s3][r2][c] = temp[r2];
                        }
                    }
                }
                temp = new double[this.slices];
                for (r = 0; r < this.rows; ++r) {
                    for (c = 0; c < this.columns; ++c) {
                        int s4;
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            temp[s4] = a[s4][r][c];
                        }
                        this.dhtSlices.inverse(temp, scale);
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            a[s4][r][c] = temp[s4];
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    private void ddxt3da_sub(int isgn, double[] a, boolean scale) {
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        double[] t2 = new double[nt];
        if (isgn == -1) {
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx1;
                int r;
                int idx0 = s2 * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.forward(a, idx0 + r * this.rowStride);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            t2[r2] = a[idx1];
                            t2[idx2] = a[idx1 + 1];
                            t2[idx2 + this.rows] = a[idx1 + 2];
                            t2[idx2 + 2 * this.rows] = a[idx1 + 3];
                        }
                        this.dhtRows.forward(t2, 0);
                        this.dhtRows.forward(t2, this.rows);
                        this.dhtRows.forward(t2, 2 * this.rows);
                        this.dhtRows.forward(t2, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            a[idx1] = t2[r2];
                            a[idx1 + 1] = t2[idx2];
                            a[idx1 + 2] = t2[idx2 + this.rows];
                            a[idx1 + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    t2[r] = a[idx1];
                    t2[this.rows + r] = a[idx1 + 1];
                }
                this.dhtRows.forward(t2, 0);
                this.dhtRows.forward(t2, this.rows);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a[idx1] = t2[r];
                    a[idx1 + 1] = t2[this.rows + r];
                }
            }
        } else {
            for (int s3 = 0; s3 < this.slices; ++s3) {
                int idx1;
                int r;
                int idx0 = s3 * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.inverse(a, idx0 + r * this.rowStride, scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            t2[r3] = a[idx1];
                            t2[idx2] = a[idx1 + 1];
                            t2[idx2 + this.rows] = a[idx1 + 2];
                            t2[idx2 + 2 * this.rows] = a[idx1 + 3];
                        }
                        this.dhtRows.inverse(t2, 0, scale);
                        this.dhtRows.inverse(t2, this.rows, scale);
                        this.dhtRows.inverse(t2, 2 * this.rows, scale);
                        this.dhtRows.inverse(t2, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            a[idx1] = t2[r3];
                            a[idx1 + 1] = t2[idx2];
                            a[idx1 + 2] = t2[idx2 + this.rows];
                            a[idx1 + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    t2[r] = a[idx1];
                    t2[this.rows + r] = a[idx1 + 1];
                }
                this.dhtRows.inverse(t2, 0, scale);
                this.dhtRows.inverse(t2, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a[idx1] = t2[r];
                    a[idx1 + 1] = t2[this.rows + r];
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, DoubleLargeArray a, boolean scale) {
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        DoubleLargeArray t2 = new DoubleLargeArray(nt);
        if (isgn == -1) {
            for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx1;
                long r;
                long idx0 = s2 * this.sliceStridel;
                for (r = 0L; r < this.rowsl; ++r) {
                    this.dhtColumns.forward(a, idx0 + r * this.rowStridel);
                }
                if (this.columnsl > 2L) {
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long r2;
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx1 = idx0 + r2 * this.rowStridel + c;
                            idx2 = this.rowsl + r2;
                            t2.setDouble(r2, a.getDouble(idx1));
                            t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                            t2.setDouble(idx2 + this.rowsl, a.getDouble(idx1 + 2L));
                            t2.setDouble(idx2 + 2L * this.rowsl, a.getDouble(idx1 + 3L));
                        }
                        this.dhtRows.forward(t2, 0L);
                        this.dhtRows.forward(t2, this.rowsl);
                        this.dhtRows.forward(t2, 2L * this.rowsl);
                        this.dhtRows.forward(t2, 3L * this.rowsl);
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx1 = idx0 + r2 * this.rowStridel + c;
                            idx2 = this.rowsl + r2;
                            a.setDouble(idx1, t2.getDouble(r2));
                            a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                            a.setDouble(idx1 + 2L, t2.getDouble(idx2 + this.rowsl));
                            a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    t2.setDouble(r, a.getDouble(idx1));
                    t2.setDouble(this.rowsl + r, a.getDouble(idx1 + 1L));
                }
                this.dhtRows.forward(t2, 0L);
                this.dhtRows.forward(t2, this.rowsl);
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    a.setDouble(idx1, t2.getDouble(r));
                    a.setDouble(idx1 + 1L, t2.getDouble(this.rowsl + r));
                }
            }
        } else {
            for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                long idx1;
                long r;
                long idx0 = s3 * this.sliceStridel;
                for (r = 0L; r < this.rowsl; ++r) {
                    this.dhtColumns.inverse(a, idx0 + r * this.rowStridel, scale);
                }
                if (this.columnsl > 2L) {
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long r3;
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c;
                            idx2 = this.rowsl + r3;
                            t2.setDouble(r3, a.getDouble(idx1));
                            t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                            t2.setDouble(idx2 + this.rowsl, a.getDouble(idx1 + 2L));
                            t2.setDouble(idx2 + 2L * this.rowsl, a.getDouble(idx1 + 3L));
                        }
                        this.dhtRows.inverse(t2, 0L, scale);
                        this.dhtRows.inverse(t2, this.rowsl, scale);
                        this.dhtRows.inverse(t2, 2L * this.rowsl, scale);
                        this.dhtRows.inverse(t2, 3L * this.rowsl, scale);
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c;
                            idx2 = this.rowsl + r3;
                            a.setDouble(idx1, t2.getDouble(r3));
                            a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                            a.setDouble(idx1 + 2L, t2.getDouble(idx2 + this.rowsl));
                            a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    t2.setDouble(r, a.getDouble(idx1));
                    t2.setDouble(this.rowsl + r, a.getDouble(idx1 + 1L));
                }
                this.dhtRows.inverse(t2, 0L, scale);
                this.dhtRows.inverse(t2, this.rowsl, scale);
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    a.setDouble(idx1, t2.getDouble(r));
                    a.setDouble(idx1 + 1L, t2.getDouble(this.rowsl + r));
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, double[][][] a, boolean scale) {
        int nt = 4 * this.rows;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        double[] t2 = new double[nt];
        if (isgn == -1) {
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.forward(a[s2][r]);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            t2[r2] = a[s2][r2][c];
                            t2[idx2] = a[s2][r2][c + 1];
                            t2[idx2 + this.rows] = a[s2][r2][c + 2];
                            t2[idx2 + 2 * this.rows] = a[s2][r2][c + 3];
                        }
                        this.dhtRows.forward(t2, 0);
                        this.dhtRows.forward(t2, this.rows);
                        this.dhtRows.forward(t2, 2 * this.rows);
                        this.dhtRows.forward(t2, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            a[s2][r2][c] = t2[r2];
                            a[s2][r2][c + 1] = t2[idx2];
                            a[s2][r2][c + 2] = t2[idx2 + this.rows];
                            a[s2][r2][c + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    t2[r] = a[s2][r][0];
                    t2[this.rows + r] = a[s2][r][1];
                }
                this.dhtRows.forward(t2, 0);
                this.dhtRows.forward(t2, this.rows);
                for (r = 0; r < this.rows; ++r) {
                    a[s2][r][0] = t2[r];
                    a[s2][r][1] = t2[this.rows + r];
                }
            }
        } else {
            for (int s3 = 0; s3 < this.slices; ++s3) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.inverse(a[s3][r], scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            t2[r3] = a[s3][r3][c];
                            t2[idx2] = a[s3][r3][c + 1];
                            t2[idx2 + this.rows] = a[s3][r3][c + 2];
                            t2[idx2 + 2 * this.rows] = a[s3][r3][c + 3];
                        }
                        this.dhtRows.inverse(t2, 0, scale);
                        this.dhtRows.inverse(t2, this.rows, scale);
                        this.dhtRows.inverse(t2, 2 * this.rows, scale);
                        this.dhtRows.inverse(t2, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a[s3][r3][c] = t2[r3];
                            a[s3][r3][c + 1] = t2[idx2];
                            a[s3][r3][c + 2] = t2[idx2 + this.rows];
                            a[s3][r3][c + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    t2[r] = a[s3][r][0];
                    t2[this.rows + r] = a[s3][r][1];
                }
                this.dhtRows.inverse(t2, 0, scale);
                this.dhtRows.inverse(t2, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[s3][r][0] = t2[r];
                    a[s3][r][1] = t2[this.rows + r];
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, double[] a, boolean scale) {
        block20: {
            double[] t2;
            block18: {
                block19: {
                    int nt = 4 * this.slices;
                    if (this.columns == 2) {
                        nt >>= 1;
                    }
                    t2 = new double[nt];
                    if (isgn != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int r = 0; r < this.rows; ++r) {
                        int idx0 = r * this.rowStride;
                        for (int c = 0; c < this.columns; c += 4) {
                            int idx2;
                            int idx1;
                            int s2;
                            for (s2 = 0; s2 < this.slices; ++s2) {
                                idx1 = s2 * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s2;
                                t2[s2] = a[idx1];
                                t2[idx2] = a[idx1 + 1];
                                t2[idx2 + this.slices] = a[idx1 + 2];
                                t2[idx2 + 2 * this.slices] = a[idx1 + 3];
                            }
                            this.dhtSlices.forward(t2, 0);
                            this.dhtSlices.forward(t2, this.slices);
                            this.dhtSlices.forward(t2, 2 * this.slices);
                            this.dhtSlices.forward(t2, 3 * this.slices);
                            for (s2 = 0; s2 < this.slices; ++s2) {
                                idx1 = s2 * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s2;
                                a[idx1] = t2[s2];
                                a[idx1 + 1] = t2[idx2];
                                a[idx1 + 2] = t2[idx2 + this.slices];
                                a[idx1 + 3] = t2[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s3;
                    int idx0 = r * this.rowStride;
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx1 = s3 * this.sliceStride + idx0;
                        t2[s3] = a[idx1];
                        t2[this.slices + s3] = a[idx1 + 1];
                    }
                    this.dhtSlices.forward(t2, 0);
                    this.dhtSlices.forward(t2, this.slices);
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx1 = s3 * this.sliceStride + idx0;
                        a[idx1] = t2[s3];
                        a[idx1 + 1] = t2[this.slices + s3];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx0 = r * this.rowStride;
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx1;
                        int s4;
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx1 = s4 * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s4;
                            t2[s4] = a[idx1];
                            t2[idx2] = a[idx1 + 1];
                            t2[idx2 + this.slices] = a[idx1 + 2];
                            t2[idx2 + 2 * this.slices] = a[idx1 + 3];
                        }
                        this.dhtSlices.inverse(t2, 0, scale);
                        this.dhtSlices.inverse(t2, this.slices, scale);
                        this.dhtSlices.inverse(t2, 2 * this.slices, scale);
                        this.dhtSlices.inverse(t2, 3 * this.slices, scale);
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx1 = s4 * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s4;
                            a[idx1] = t2[s4];
                            a[idx1 + 1] = t2[idx2];
                            a[idx1 + 2] = t2[idx2 + this.slices];
                            a[idx1 + 3] = t2[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s5;
                    int idx0 = r * this.rowStride;
                    for (s5 = 0; s5 < this.slices; ++s5) {
                        idx1 = s5 * this.sliceStride + idx0;
                        t2[s5] = a[idx1];
                        t2[this.slices + s5] = a[idx1 + 1];
                    }
                    this.dhtSlices.inverse(t2, 0, scale);
                    this.dhtSlices.inverse(t2, this.slices, scale);
                    for (s5 = 0; s5 < this.slices; ++s5) {
                        idx1 = s5 * this.sliceStride + idx0;
                        a[idx1] = t2[s5];
                        a[idx1 + 1] = t2[this.slices + s5];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, DoubleLargeArray a, boolean scale) {
        block20: {
            DoubleLargeArray t2;
            block18: {
                block19: {
                    long nt = 4L * this.slicesl;
                    if (this.columnsl == 2L) {
                        nt >>= 1;
                    }
                    t2 = new DoubleLargeArray(nt);
                    if (isgn != -1) break block18;
                    if (this.columnsl <= 2L) break block19;
                    for (long r = 0L; r < this.rowsl; ++r) {
                        long idx0 = r * this.rowStridel;
                        for (long c = 0L; c < this.columnsl; c += 4L) {
                            long idx2;
                            long idx1;
                            long s2;
                            for (s2 = 0L; s2 < this.slicesl; ++s2) {
                                idx1 = s2 * this.sliceStridel + idx0 + c;
                                idx2 = this.slicesl + s2;
                                t2.setDouble(s2, a.getDouble(idx1));
                                t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                                t2.setDouble(idx2 + this.slicesl, a.getDouble(idx1 + 2L));
                                t2.setDouble(idx2 + 2L * this.slicesl, a.getDouble(idx1 + 3L));
                            }
                            this.dhtSlices.forward(t2, 0L);
                            this.dhtSlices.forward(t2, this.slicesl);
                            this.dhtSlices.forward(t2, 2L * this.slicesl);
                            this.dhtSlices.forward(t2, 3L * this.slicesl);
                            for (s2 = 0L; s2 < this.slicesl; ++s2) {
                                idx1 = s2 * this.sliceStridel + idx0 + c;
                                idx2 = this.slicesl + s2;
                                a.setDouble(idx1, t2.getDouble(s2));
                                a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                a.setDouble(idx1 + 2L, t2.getDouble(idx2 + this.slicesl));
                                a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * this.slicesl));
                            }
                        }
                    }
                    break block20;
                }
                if (this.columnsl != 2L) break block20;
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx1;
                    long s3;
                    long idx0 = r * this.rowStridel;
                    for (s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx1 = s3 * this.sliceStridel + idx0;
                        t2.setDouble(s3, a.getDouble(idx1));
                        t2.setDouble(this.slicesl + s3, a.getDouble(idx1 + 1L));
                    }
                    this.dhtSlices.forward(t2, 0L);
                    this.dhtSlices.forward(t2, this.slicesl);
                    for (s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx1 = s3 * this.sliceStridel + idx0;
                        a.setDouble(idx1, t2.getDouble(s3));
                        a.setDouble(idx1 + 1L, t2.getDouble(this.slicesl + s3));
                    }
                }
                break block20;
            }
            if (this.columnsl > 2L) {
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx0 = r * this.rowStridel;
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long idx1;
                        long s4;
                        for (s4 = 0L; s4 < this.slicesl; ++s4) {
                            idx1 = s4 * this.sliceStridel + idx0 + c;
                            idx2 = this.slicesl + s4;
                            t2.setDouble(s4, a.getDouble(idx1));
                            t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                            t2.setDouble(idx2 + this.slicesl, a.getDouble(idx1 + 2L));
                            t2.setDouble(idx2 + 2L * this.slicesl, a.getDouble(idx1 + 3L));
                        }
                        this.dhtSlices.inverse(t2, 0L, scale);
                        this.dhtSlices.inverse(t2, this.slicesl, scale);
                        this.dhtSlices.inverse(t2, 2L * this.slicesl, scale);
                        this.dhtSlices.inverse(t2, 3L * this.slicesl, scale);
                        for (s4 = 0L; s4 < this.slicesl; ++s4) {
                            idx1 = s4 * this.sliceStridel + idx0 + c;
                            idx2 = this.slicesl + s4;
                            a.setDouble(idx1, t2.getDouble(s4));
                            a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                            a.setDouble(idx1 + 2L, t2.getDouble(idx2 + this.slicesl));
                            a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * this.slicesl));
                        }
                    }
                }
            } else if (this.columnsl == 2L) {
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx1;
                    long s5;
                    long idx0 = r * this.rowStridel;
                    for (s5 = 0L; s5 < this.slicesl; ++s5) {
                        idx1 = s5 * this.sliceStridel + idx0;
                        t2.setDouble(s5, a.getDouble(idx1));
                        t2.setDouble(this.slicesl + s5, a.getDouble(idx1 + 1L));
                    }
                    this.dhtSlices.inverse(t2, 0L, scale);
                    this.dhtSlices.inverse(t2, this.slicesl, scale);
                    for (s5 = 0L; s5 < this.slicesl; ++s5) {
                        idx1 = s5 * this.sliceStridel + idx0;
                        a.setDouble(idx1, t2.getDouble(s5));
                        a.setDouble(idx1 + 1L, t2.getDouble(this.slicesl + s5));
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, double[][][] a, boolean scale) {
        block20: {
            double[] t2;
            block18: {
                block19: {
                    int nt = 4 * this.slices;
                    if (this.columns == 2) {
                        nt >>= 1;
                    }
                    t2 = new double[nt];
                    if (isgn != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int r = 0; r < this.rows; ++r) {
                        for (int c = 0; c < this.columns; c += 4) {
                            int idx2;
                            int s2;
                            for (s2 = 0; s2 < this.slices; ++s2) {
                                idx2 = this.slices + s2;
                                t2[s2] = a[s2][r][c];
                                t2[idx2] = a[s2][r][c + 1];
                                t2[idx2 + this.slices] = a[s2][r][c + 2];
                                t2[idx2 + 2 * this.slices] = a[s2][r][c + 3];
                            }
                            this.dhtSlices.forward(t2, 0);
                            this.dhtSlices.forward(t2, this.slices);
                            this.dhtSlices.forward(t2, 2 * this.slices);
                            this.dhtSlices.forward(t2, 3 * this.slices);
                            for (s2 = 0; s2 < this.slices; ++s2) {
                                idx2 = this.slices + s2;
                                a[s2][r][c] = t2[s2];
                                a[s2][r][c + 1] = t2[idx2];
                                a[s2][r][c + 2] = t2[idx2 + this.slices];
                                a[s2][r][c + 3] = t2[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int r = 0; r < this.rows; ++r) {
                    int s3;
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        t2[s3] = a[s3][r][0];
                        t2[this.slices + s3] = a[s3][r][1];
                    }
                    this.dhtSlices.forward(t2, 0);
                    this.dhtSlices.forward(t2, this.slices);
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        a[s3][r][0] = t2[s3];
                        a[s3][r][1] = t2[this.slices + s3];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int s4;
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx2 = this.slices + s4;
                            t2[s4] = a[s4][r][c];
                            t2[idx2] = a[s4][r][c + 1];
                            t2[idx2 + this.slices] = a[s4][r][c + 2];
                            t2[idx2 + 2 * this.slices] = a[s4][r][c + 3];
                        }
                        this.dhtSlices.inverse(t2, 0, scale);
                        this.dhtSlices.inverse(t2, this.slices, scale);
                        this.dhtSlices.inverse(t2, 2 * this.slices, scale);
                        this.dhtSlices.inverse(t2, 3 * this.slices, scale);
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx2 = this.slices + s4;
                            a[s4][r][c] = t2[s4];
                            a[s4][r][c + 1] = t2[idx2];
                            a[s4][r][c + 2] = t2[idx2 + this.slices];
                            a[s4][r][c + 3] = t2[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int s5;
                    for (s5 = 0; s5 < this.slices; ++s5) {
                        t2[s5] = a[s5][r][0];
                        t2[this.slices + s5] = a[s5][r][1];
                    }
                    this.dhtSlices.inverse(t2, 0, scale);
                    this.dhtSlices.inverse(t2, this.slices, scale);
                    for (s5 = 0; s5 < this.slices; ++s5) {
                        a[s5][r][0] = t2[s5];
                        a[s5][r][1] = t2[this.slices + s5];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] t2 = new double[ntf];
                    if (isgn == -1) {
                        for (int s2 = n0; s2 < DoubleDHT_3D.this.slices; s2 += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s2 * DoubleDHT_3D.this.sliceStride;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                DoubleDHT_3D.this.dhtColumns.forward(a, idx0 + r * DoubleDHT_3D.this.rowStride);
                            }
                            if (DoubleDHT_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDHT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleDHT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleDHT_3D.this.rowStride + c;
                                        idx2 = DoubleDHT_3D.this.rows + r2;
                                        t2[r2] = a[idx1];
                                        t2[idx2] = a[idx1 + 1];
                                        t2[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a[idx1 + 2];
                                        t2[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a[idx1 + 3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(t2, 0);
                                    DoubleDHT_3D.this.dhtRows.forward(t2, DoubleDHT_3D.this.rows);
                                    DoubleDHT_3D.this.dhtRows.forward(t2, 2 * DoubleDHT_3D.this.rows);
                                    DoubleDHT_3D.this.dhtRows.forward(t2, 3 * DoubleDHT_3D.this.rows);
                                    for (r2 = 0; r2 < DoubleDHT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleDHT_3D.this.rowStride + c;
                                        idx2 = DoubleDHT_3D.this.rows + r2;
                                        a[idx1] = t2[r2];
                                        a[idx1 + 1] = t2[idx2];
                                        a[idx1 + 2] = t2[idx2 + DoubleDHT_3D.this.rows];
                                        a[idx1 + 3] = t2[idx2 + 2 * DoubleDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDHT_3D.this.rowStride;
                                t2[r] = a[idx1];
                                t2[((DoubleDHT_3D)DoubleDHT_3D.this).rows + r] = a[idx1 + 1];
                            }
                            DoubleDHT_3D.this.dhtRows.forward(t2, 0);
                            DoubleDHT_3D.this.dhtRows.forward(t2, DoubleDHT_3D.this.rows);
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDHT_3D.this.rowStride;
                                a[idx1] = t2[r];
                                a[idx1 + 1] = t2[DoubleDHT_3D.this.rows + r];
                            }
                        }
                    } else {
                        for (int s3 = n0; s3 < DoubleDHT_3D.this.slices; s3 += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s3 * DoubleDHT_3D.this.sliceStride;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                DoubleDHT_3D.this.dhtColumns.inverse(a, idx0 + r * DoubleDHT_3D.this.rowStride, scale);
                            }
                            if (DoubleDHT_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDHT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleDHT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleDHT_3D.this.rowStride + c;
                                        idx2 = DoubleDHT_3D.this.rows + r3;
                                        t2[r3] = a[idx1];
                                        t2[idx2] = a[idx1 + 1];
                                        t2[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a[idx1 + 2];
                                        t2[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a[idx1 + 3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(t2, 0, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t2, DoubleDHT_3D.this.rows, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t2, 2 * DoubleDHT_3D.this.rows, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t2, 3 * DoubleDHT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleDHT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleDHT_3D.this.rowStride + c;
                                        idx2 = DoubleDHT_3D.this.rows + r3;
                                        a[idx1] = t2[r3];
                                        a[idx1 + 1] = t2[idx2];
                                        a[idx1 + 2] = t2[idx2 + DoubleDHT_3D.this.rows];
                                        a[idx1 + 3] = t2[idx2 + 2 * DoubleDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDHT_3D.this.rowStride;
                                t2[r] = a[idx1];
                                t2[((DoubleDHT_3D)DoubleDHT_3D.this).rows + r] = a[idx1 + 1];
                            }
                            DoubleDHT_3D.this.dhtRows.inverse(t2, 0, scale);
                            DoubleDHT_3D.this.dhtRows.inverse(t2, DoubleDHT_3D.this.rows, scale);
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDHT_3D.this.rowStride;
                                a[idx1] = t2[r];
                                a[idx1 + 1] = t2[DoubleDHT_3D.this.rows + r];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3da_subth(final int isgn, final DoubleLargeArray a, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.slicesl ? this.slicesl : (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    DoubleLargeArray t2 = new DoubleLargeArray(ntf);
                    if (isgn == -1) {
                        for (long s2 = n0; s2 < DoubleDHT_3D.this.slicesl; s2 += (long)nthreads) {
                            long idx1;
                            long r;
                            long idx0 = s2 * (long)DoubleDHT_3D.this.sliceStride;
                            for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                DoubleDHT_3D.this.dhtColumns.forward(a, idx0 + r * (long)DoubleDHT_3D.this.rowStride);
                            }
                            if (DoubleDHT_3D.this.columnsl > 2L) {
                                for (long c = 0L; c < DoubleDHT_3D.this.columnsl; c += 4L) {
                                    long idx2;
                                    long r2;
                                    for (r2 = 0L; r2 < DoubleDHT_3D.this.rowsl; ++r2) {
                                        idx1 = idx0 + r2 * (long)DoubleDHT_3D.this.rowStride + c;
                                        idx2 = DoubleDHT_3D.this.rowsl + r2;
                                        t2.setDouble(r2, a.getDouble(idx1));
                                        t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                                        t2.setDouble(idx2 + DoubleDHT_3D.this.rowsl, a.getDouble(idx1 + 2L));
                                        t2.setDouble(idx2 + 2L * DoubleDHT_3D.this.rowsl, a.getDouble(idx1 + 3L));
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(t2, 0L);
                                    DoubleDHT_3D.this.dhtRows.forward(t2, DoubleDHT_3D.this.rowsl);
                                    DoubleDHT_3D.this.dhtRows.forward(t2, 2L * DoubleDHT_3D.this.rowsl);
                                    DoubleDHT_3D.this.dhtRows.forward(t2, 3L * DoubleDHT_3D.this.rowsl);
                                    for (r2 = 0L; r2 < DoubleDHT_3D.this.rowsl; ++r2) {
                                        idx1 = idx0 + r2 * (long)DoubleDHT_3D.this.rowStride + c;
                                        idx2 = DoubleDHT_3D.this.rowsl + r2;
                                        a.setDouble(idx1, t2.getDouble(r2));
                                        a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                        a.setDouble(idx1 + 2L, t2.getDouble(idx2 + DoubleDHT_3D.this.rowsl));
                                        a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * DoubleDHT_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columnsl != 2L) continue;
                            for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * (long)DoubleDHT_3D.this.rowStride;
                                t2.setDouble(r, a.getDouble(idx1));
                                t2.setDouble(DoubleDHT_3D.this.rowsl + r, a.getDouble(idx1 + 1L));
                            }
                            DoubleDHT_3D.this.dhtRows.forward(t2, 0L);
                            DoubleDHT_3D.this.dhtRows.forward(t2, DoubleDHT_3D.this.rowsl);
                            for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * (long)DoubleDHT_3D.this.rowStride;
                                a.setDouble(idx1, t2.getDouble(r));
                                a.setDouble(idx1 + 1L, t2.getDouble(DoubleDHT_3D.this.rowsl + r));
                            }
                        }
                    } else {
                        for (long s3 = n0; s3 < DoubleDHT_3D.this.slicesl; s3 += (long)nthreads) {
                            long idx1;
                            long r;
                            long idx0 = s3 * (long)DoubleDHT_3D.this.sliceStride;
                            for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                DoubleDHT_3D.this.dhtColumns.inverse(a, idx0 + r * (long)DoubleDHT_3D.this.rowStride, scale);
                            }
                            if (DoubleDHT_3D.this.columnsl > 2L) {
                                for (long c = 0L; c < DoubleDHT_3D.this.columnsl; c += 4L) {
                                    long idx2;
                                    long r3;
                                    for (r3 = 0L; r3 < DoubleDHT_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * (long)DoubleDHT_3D.this.rowStride + c;
                                        idx2 = DoubleDHT_3D.this.rowsl + r3;
                                        t2.setDouble(r3, a.getDouble(idx1));
                                        t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                                        t2.setDouble(idx2 + DoubleDHT_3D.this.rowsl, a.getDouble(idx1 + 2L));
                                        t2.setDouble(idx2 + 2L * DoubleDHT_3D.this.rowsl, a.getDouble(idx1 + 3L));
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(t2, 0L, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t2, DoubleDHT_3D.this.rowsl, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t2, 2L * DoubleDHT_3D.this.rowsl, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t2, 3L * DoubleDHT_3D.this.rowsl, scale);
                                    for (r3 = 0L; r3 < DoubleDHT_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * (long)DoubleDHT_3D.this.rowStride + c;
                                        idx2 = DoubleDHT_3D.this.rowsl + r3;
                                        a.setDouble(idx1, t2.getDouble(r3));
                                        a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                        a.setDouble(idx1 + 2L, t2.getDouble(idx2 + DoubleDHT_3D.this.rowsl));
                                        a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * DoubleDHT_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columnsl != 2L) continue;
                            for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * (long)DoubleDHT_3D.this.rowStride;
                                t2.setDouble(r, a.getDouble(idx1));
                                t2.setDouble(DoubleDHT_3D.this.rowsl + r, a.getDouble(idx1 + 1L));
                            }
                            DoubleDHT_3D.this.dhtRows.inverse(t2, 0L, scale);
                            DoubleDHT_3D.this.dhtRows.inverse(t2, DoubleDHT_3D.this.rowsl, scale);
                            for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * (long)DoubleDHT_3D.this.rowStride;
                                a.setDouble(idx1, t2.getDouble(r));
                                a.setDouble(idx1 + 1L, t2.getDouble(DoubleDHT_3D.this.rowsl + r));
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3da_subth(final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] t2 = new double[ntf];
                    if (isgn == -1) {
                        for (int s2 = n0; s2 < DoubleDHT_3D.this.slices; s2 += nthreads) {
                            int r;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                DoubleDHT_3D.this.dhtColumns.forward(a[s2][r]);
                            }
                            if (DoubleDHT_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDHT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleDHT_3D.this.rows; ++r2) {
                                        idx2 = DoubleDHT_3D.this.rows + r2;
                                        t2[r2] = a[s2][r2][c];
                                        t2[idx2] = a[s2][r2][c + 1];
                                        t2[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a[s2][r2][c + 2];
                                        t2[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a[s2][r2][c + 3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(t2, 0);
                                    DoubleDHT_3D.this.dhtRows.forward(t2, DoubleDHT_3D.this.rows);
                                    DoubleDHT_3D.this.dhtRows.forward(t2, 2 * DoubleDHT_3D.this.rows);
                                    DoubleDHT_3D.this.dhtRows.forward(t2, 3 * DoubleDHT_3D.this.rows);
                                    for (r2 = 0; r2 < DoubleDHT_3D.this.rows; ++r2) {
                                        idx2 = DoubleDHT_3D.this.rows + r2;
                                        a[s2][r2][c] = t2[r2];
                                        a[s2][r2][c + 1] = t2[idx2];
                                        a[s2][r2][c + 2] = t2[idx2 + DoubleDHT_3D.this.rows];
                                        a[s2][r2][c + 3] = t2[idx2 + 2 * DoubleDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                t2[r] = a[s2][r][0];
                                t2[((DoubleDHT_3D)DoubleDHT_3D.this).rows + r] = a[s2][r][1];
                            }
                            DoubleDHT_3D.this.dhtRows.forward(t2, 0);
                            DoubleDHT_3D.this.dhtRows.forward(t2, DoubleDHT_3D.this.rows);
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                a[s2][r][0] = t2[r];
                                a[s2][r][1] = t2[DoubleDHT_3D.this.rows + r];
                            }
                        }
                    } else {
                        for (int s3 = n0; s3 < DoubleDHT_3D.this.slices; s3 += nthreads) {
                            int r;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                DoubleDHT_3D.this.dhtColumns.inverse(a[s3][r], scale);
                            }
                            if (DoubleDHT_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDHT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleDHT_3D.this.rows; ++r3) {
                                        idx2 = DoubleDHT_3D.this.rows + r3;
                                        t2[r3] = a[s3][r3][c];
                                        t2[idx2] = a[s3][r3][c + 1];
                                        t2[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a[s3][r3][c + 2];
                                        t2[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a[s3][r3][c + 3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(t2, 0, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t2, DoubleDHT_3D.this.rows, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t2, 2 * DoubleDHT_3D.this.rows, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t2, 3 * DoubleDHT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleDHT_3D.this.rows; ++r3) {
                                        idx2 = DoubleDHT_3D.this.rows + r3;
                                        a[s3][r3][c] = t2[r3];
                                        a[s3][r3][c + 1] = t2[idx2];
                                        a[s3][r3][c + 2] = t2[idx2 + DoubleDHT_3D.this.rows];
                                        a[s3][r3][c + 3] = t2[idx2 + 2 * DoubleDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                t2[r] = a[s3][r][0];
                                t2[((DoubleDHT_3D)DoubleDHT_3D.this).rows + r] = a[s3][r][1];
                            }
                            DoubleDHT_3D.this.dhtRows.inverse(t2, 0, scale);
                            DoubleDHT_3D.this.dhtRows.inverse(t2, DoubleDHT_3D.this.rows, scale);
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                a[s3][r][0] = t2[r];
                                a[s3][r][1] = t2[DoubleDHT_3D.this.rows + r];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        double[] t2;
                        block17: {
                            block18: {
                                t2 = new double[ntf];
                                if (isgn != -1) break block17;
                                if (DoubleDHT_3D.this.columns <= 2) break block18;
                                for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                    int idx0 = r * DoubleDHT_3D.this.rowStride;
                                    for (int c = 0; c < DoubleDHT_3D.this.columns; c += 4) {
                                        int idx2;
                                        int idx1;
                                        int s2;
                                        for (s2 = 0; s2 < DoubleDHT_3D.this.slices; ++s2) {
                                            idx1 = s2 * DoubleDHT_3D.this.sliceStride + idx0 + c;
                                            idx2 = DoubleDHT_3D.this.slices + s2;
                                            t2[s2] = a[idx1];
                                            t2[idx2] = a[idx1 + 1];
                                            t2[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a[idx1 + 2];
                                            t2[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a[idx1 + 3];
                                        }
                                        DoubleDHT_3D.this.dhtSlices.forward(t2, 0);
                                        DoubleDHT_3D.this.dhtSlices.forward(t2, DoubleDHT_3D.this.slices);
                                        DoubleDHT_3D.this.dhtSlices.forward(t2, 2 * DoubleDHT_3D.this.slices);
                                        DoubleDHT_3D.this.dhtSlices.forward(t2, 3 * DoubleDHT_3D.this.slices);
                                        for (s2 = 0; s2 < DoubleDHT_3D.this.slices; ++s2) {
                                            idx1 = s2 * DoubleDHT_3D.this.sliceStride + idx0 + c;
                                            idx2 = DoubleDHT_3D.this.slices + s2;
                                            a[idx1] = t2[s2];
                                            a[idx1 + 1] = t2[idx2];
                                            a[idx1 + 2] = t2[idx2 + DoubleDHT_3D.this.slices];
                                            a[idx1 + 3] = t2[idx2 + 2 * DoubleDHT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDHT_3D.this.columns != 2) break block19;
                            for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                int idx1;
                                int s3;
                                int idx0 = r * DoubleDHT_3D.this.rowStride;
                                for (s3 = 0; s3 < DoubleDHT_3D.this.slices; ++s3) {
                                    idx1 = s3 * DoubleDHT_3D.this.sliceStride + idx0;
                                    t2[s3] = a[idx1];
                                    t2[((DoubleDHT_3D)DoubleDHT_3D.this).slices + s3] = a[idx1 + 1];
                                }
                                DoubleDHT_3D.this.dhtSlices.forward(t2, 0);
                                DoubleDHT_3D.this.dhtSlices.forward(t2, DoubleDHT_3D.this.slices);
                                for (s3 = 0; s3 < DoubleDHT_3D.this.slices; ++s3) {
                                    idx1 = s3 * DoubleDHT_3D.this.sliceStride + idx0;
                                    a[idx1] = t2[s3];
                                    a[idx1 + 1] = t2[DoubleDHT_3D.this.slices + s3];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDHT_3D.this.columns > 2) {
                            for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                int idx0 = r * DoubleDHT_3D.this.rowStride;
                                for (int c = 0; c < DoubleDHT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int idx1;
                                    int s4;
                                    for (s4 = 0; s4 < DoubleDHT_3D.this.slices; ++s4) {
                                        idx1 = s4 * DoubleDHT_3D.this.sliceStride + idx0 + c;
                                        idx2 = DoubleDHT_3D.this.slices + s4;
                                        t2[s4] = a[idx1];
                                        t2[idx2] = a[idx1 + 1];
                                        t2[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a[idx1 + 2];
                                        t2[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a[idx1 + 3];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(t2, 0, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t2, DoubleDHT_3D.this.slices, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t2, 2 * DoubleDHT_3D.this.slices, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t2, 3 * DoubleDHT_3D.this.slices, scale);
                                    for (s4 = 0; s4 < DoubleDHT_3D.this.slices; ++s4) {
                                        idx1 = s4 * DoubleDHT_3D.this.sliceStride + idx0 + c;
                                        idx2 = DoubleDHT_3D.this.slices + s4;
                                        a[idx1] = t2[s4];
                                        a[idx1 + 1] = t2[idx2];
                                        a[idx1 + 2] = t2[idx2 + DoubleDHT_3D.this.slices];
                                        a[idx1 + 3] = t2[idx2 + 2 * DoubleDHT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDHT_3D.this.columns == 2) {
                            for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                int idx1;
                                int s5;
                                int idx0 = r * DoubleDHT_3D.this.rowStride;
                                for (s5 = 0; s5 < DoubleDHT_3D.this.slices; ++s5) {
                                    idx1 = s5 * DoubleDHT_3D.this.sliceStride + idx0;
                                    t2[s5] = a[idx1];
                                    t2[((DoubleDHT_3D)DoubleDHT_3D.this).slices + s5] = a[idx1 + 1];
                                }
                                DoubleDHT_3D.this.dhtSlices.inverse(t2, 0, scale);
                                DoubleDHT_3D.this.dhtSlices.inverse(t2, DoubleDHT_3D.this.slices, scale);
                                for (s5 = 0; s5 < DoubleDHT_3D.this.slices; ++s5) {
                                    idx1 = s5 * DoubleDHT_3D.this.sliceStride + idx0;
                                    a[idx1] = t2[s5];
                                    a[idx1 + 1] = t2[DoubleDHT_3D.this.slices + s5];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final DoubleLargeArray a, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.slicesl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        DoubleLargeArray t2;
                        block17: {
                            block18: {
                                t2 = new DoubleLargeArray(ntf);
                                if (isgn != -1) break block17;
                                if (DoubleDHT_3D.this.columnsl <= 2L) break block18;
                                for (long r = n0; r < DoubleDHT_3D.this.rowsl; r += (long)nthreads) {
                                    long idx0 = r * DoubleDHT_3D.this.rowStridel;
                                    for (long c = 0L; c < DoubleDHT_3D.this.columnsl; c += 4L) {
                                        long idx2;
                                        long idx1;
                                        long s2;
                                        for (s2 = 0L; s2 < DoubleDHT_3D.this.slicesl; ++s2) {
                                            idx1 = s2 * DoubleDHT_3D.this.sliceStridel + idx0 + c;
                                            idx2 = DoubleDHT_3D.this.slicesl + s2;
                                            t2.setDouble(s2, a.getDouble(idx1));
                                            t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                                            t2.setDouble(idx2 + DoubleDHT_3D.this.slicesl, a.getDouble(idx1 + 2L));
                                            t2.setDouble(idx2 + 2L * DoubleDHT_3D.this.slicesl, a.getDouble(idx1 + 3L));
                                        }
                                        DoubleDHT_3D.this.dhtSlices.forward(t2, 0L);
                                        DoubleDHT_3D.this.dhtSlices.forward(t2, DoubleDHT_3D.this.slicesl);
                                        DoubleDHT_3D.this.dhtSlices.forward(t2, 2L * DoubleDHT_3D.this.slicesl);
                                        DoubleDHT_3D.this.dhtSlices.forward(t2, 3L * DoubleDHT_3D.this.slicesl);
                                        for (s2 = 0L; s2 < DoubleDHT_3D.this.slicesl; ++s2) {
                                            idx1 = s2 * DoubleDHT_3D.this.sliceStridel + idx0 + c;
                                            idx2 = DoubleDHT_3D.this.slicesl + s2;
                                            a.setDouble(idx1, t2.getDouble(s2));
                                            a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                            a.setDouble(idx1 + 2L, t2.getDouble(idx2 + DoubleDHT_3D.this.slicesl));
                                            a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * DoubleDHT_3D.this.slicesl));
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDHT_3D.this.columnsl != 2L) break block19;
                            for (long r = n0; r < DoubleDHT_3D.this.rowsl; r += (long)nthreads) {
                                long idx1;
                                long s3;
                                long idx0 = r * DoubleDHT_3D.this.rowStridel;
                                for (s3 = 0L; s3 < DoubleDHT_3D.this.slicesl; ++s3) {
                                    idx1 = s3 * DoubleDHT_3D.this.sliceStridel + idx0;
                                    t2.setDouble(s3, a.getDouble(idx1));
                                    t2.setDouble(DoubleDHT_3D.this.slicesl + s3, a.getDouble(idx1 + 1L));
                                }
                                DoubleDHT_3D.this.dhtSlices.forward(t2, 0L);
                                DoubleDHT_3D.this.dhtSlices.forward(t2, DoubleDHT_3D.this.slicesl);
                                for (s3 = 0L; s3 < DoubleDHT_3D.this.slicesl; ++s3) {
                                    idx1 = s3 * DoubleDHT_3D.this.sliceStridel + idx0;
                                    a.setDouble(idx1, t2.getDouble(s3));
                                    a.setDouble(idx1 + 1L, t2.getDouble(DoubleDHT_3D.this.slicesl + s3));
                                }
                            }
                            break block19;
                        }
                        if (DoubleDHT_3D.this.columnsl > 2L) {
                            for (long r = n0; r < DoubleDHT_3D.this.rowsl; r += (long)nthreads) {
                                long idx0 = r * DoubleDHT_3D.this.rowStridel;
                                for (long c = 0L; c < DoubleDHT_3D.this.columnsl; c += 4L) {
                                    long idx2;
                                    long idx1;
                                    long s4;
                                    for (s4 = 0L; s4 < DoubleDHT_3D.this.slicesl; ++s4) {
                                        idx1 = s4 * DoubleDHT_3D.this.sliceStridel + idx0 + c;
                                        idx2 = DoubleDHT_3D.this.slicesl + s4;
                                        t2.setDouble(s4, a.getDouble(idx1));
                                        t2.setDouble(idx2, a.getDouble(idx1 + 1L));
                                        t2.setDouble(idx2 + DoubleDHT_3D.this.slicesl, a.getDouble(idx1 + 2L));
                                        t2.setDouble(idx2 + 2L * DoubleDHT_3D.this.slicesl, a.getDouble(idx1 + 3L));
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(t2, 0L, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t2, DoubleDHT_3D.this.slicesl, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t2, 2L * DoubleDHT_3D.this.slicesl, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t2, 3L * DoubleDHT_3D.this.slicesl, scale);
                                    for (s4 = 0L; s4 < DoubleDHT_3D.this.slicesl; ++s4) {
                                        idx1 = s4 * DoubleDHT_3D.this.sliceStridel + idx0 + c;
                                        idx2 = DoubleDHT_3D.this.slicesl + s4;
                                        a.setDouble(idx1, t2.getDouble(s4));
                                        a.setDouble(idx1 + 1L, t2.getDouble(idx2));
                                        a.setDouble(idx1 + 2L, t2.getDouble(idx2 + DoubleDHT_3D.this.slicesl));
                                        a.setDouble(idx1 + 3L, t2.getDouble(idx2 + 2L * DoubleDHT_3D.this.slicesl));
                                    }
                                }
                            }
                        } else if (DoubleDHT_3D.this.columnsl == 2L) {
                            for (long r = n0; r < DoubleDHT_3D.this.rowsl; r += (long)nthreads) {
                                long idx1;
                                long s5;
                                long idx0 = r * DoubleDHT_3D.this.rowStridel;
                                for (s5 = 0L; s5 < DoubleDHT_3D.this.slicesl; ++s5) {
                                    idx1 = s5 * DoubleDHT_3D.this.sliceStridel + idx0;
                                    t2.setDouble(s5, a.getDouble(idx1));
                                    t2.setDouble(DoubleDHT_3D.this.slicesl + s5, a.getDouble(idx1 + 1L));
                                }
                                DoubleDHT_3D.this.dhtSlices.inverse(t2, 0L, scale);
                                DoubleDHT_3D.this.dhtSlices.inverse(t2, DoubleDHT_3D.this.slicesl, scale);
                                for (s5 = 0L; s5 < DoubleDHT_3D.this.slicesl; ++s5) {
                                    idx1 = s5 * DoubleDHT_3D.this.sliceStridel + idx0;
                                    a.setDouble(idx1, t2.getDouble(s5));
                                    a.setDouble(idx1 + 1L, t2.getDouble(DoubleDHT_3D.this.slicesl + s5));
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        double[] t2;
                        block17: {
                            block18: {
                                t2 = new double[ntf];
                                if (isgn != -1) break block17;
                                if (DoubleDHT_3D.this.columns <= 2) break block18;
                                for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                    for (int c = 0; c < DoubleDHT_3D.this.columns; c += 4) {
                                        int idx2;
                                        int s2;
                                        for (s2 = 0; s2 < DoubleDHT_3D.this.slices; ++s2) {
                                            idx2 = DoubleDHT_3D.this.slices + s2;
                                            t2[s2] = a[s2][r][c];
                                            t2[idx2] = a[s2][r][c + 1];
                                            t2[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a[s2][r][c + 2];
                                            t2[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a[s2][r][c + 3];
                                        }
                                        DoubleDHT_3D.this.dhtSlices.forward(t2, 0);
                                        DoubleDHT_3D.this.dhtSlices.forward(t2, DoubleDHT_3D.this.slices);
                                        DoubleDHT_3D.this.dhtSlices.forward(t2, 2 * DoubleDHT_3D.this.slices);
                                        DoubleDHT_3D.this.dhtSlices.forward(t2, 3 * DoubleDHT_3D.this.slices);
                                        for (s2 = 0; s2 < DoubleDHT_3D.this.slices; ++s2) {
                                            idx2 = DoubleDHT_3D.this.slices + s2;
                                            a[s2][r][c] = t2[s2];
                                            a[s2][r][c + 1] = t2[idx2];
                                            a[s2][r][c + 2] = t2[idx2 + DoubleDHT_3D.this.slices];
                                            a[s2][r][c + 3] = t2[idx2 + 2 * DoubleDHT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDHT_3D.this.columns != 2) break block19;
                            for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                int s3;
                                for (s3 = 0; s3 < DoubleDHT_3D.this.slices; ++s3) {
                                    t2[s3] = a[s3][r][0];
                                    t2[((DoubleDHT_3D)DoubleDHT_3D.this).slices + s3] = a[s3][r][1];
                                }
                                DoubleDHT_3D.this.dhtSlices.forward(t2, 0);
                                DoubleDHT_3D.this.dhtSlices.forward(t2, DoubleDHT_3D.this.slices);
                                for (s3 = 0; s3 < DoubleDHT_3D.this.slices; ++s3) {
                                    a[s3][r][0] = t2[s3];
                                    a[s3][r][1] = t2[DoubleDHT_3D.this.slices + s3];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDHT_3D.this.columns > 2) {
                            for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                for (int c = 0; c < DoubleDHT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int s4;
                                    for (s4 = 0; s4 < DoubleDHT_3D.this.slices; ++s4) {
                                        idx2 = DoubleDHT_3D.this.slices + s4;
                                        t2[s4] = a[s4][r][c];
                                        t2[idx2] = a[s4][r][c + 1];
                                        t2[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a[s4][r][c + 2];
                                        t2[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a[s4][r][c + 3];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(t2, 0, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t2, DoubleDHT_3D.this.slices, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t2, 2 * DoubleDHT_3D.this.slices, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t2, 3 * DoubleDHT_3D.this.slices, scale);
                                    for (s4 = 0; s4 < DoubleDHT_3D.this.slices; ++s4) {
                                        idx2 = DoubleDHT_3D.this.slices + s4;
                                        a[s4][r][c] = t2[s4];
                                        a[s4][r][c + 1] = t2[idx2];
                                        a[s4][r][c + 2] = t2[idx2 + DoubleDHT_3D.this.slices];
                                        a[s4][r][c + 3] = t2[idx2 + 2 * DoubleDHT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDHT_3D.this.columns == 2) {
                            for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                int s5;
                                for (s5 = 0; s5 < DoubleDHT_3D.this.slices; ++s5) {
                                    t2[s5] = a[s5][r][0];
                                    t2[((DoubleDHT_3D)DoubleDHT_3D.this).slices + s5] = a[s5][r][1];
                                }
                                DoubleDHT_3D.this.dhtSlices.inverse(t2, 0, scale);
                                DoubleDHT_3D.this.dhtSlices.inverse(t2, DoubleDHT_3D.this.slices, scale);
                                for (s5 = 0; s5 < DoubleDHT_3D.this.slices; ++s5) {
                                    a[s5][r][0] = t2[s5];
                                    a[s5][r][1] = t2[DoubleDHT_3D.this.slices + s5];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void yTransform(double[] a) {
        for (int s2 = 0; s2 <= this.slices / 2; ++s2) {
            int sC = (this.slices - s2) % this.slices;
            int idx9 = s2 * this.sliceStride;
            int idx10 = sC * this.sliceStride;
            for (int r = 0; r <= this.rows / 2; ++r) {
                int rC = (this.rows - r) % this.rows;
                int idx11 = r * this.rowStride;
                int idx12 = rC * this.rowStride;
                for (int c = 0; c <= this.columns / 2; ++c) {
                    int cC = (this.columns - c) % this.columns;
                    int idx1 = idx9 + idx12 + c;
                    int idx2 = idx9 + idx11 + cC;
                    int idx3 = idx10 + idx11 + c;
                    int idx4 = idx10 + idx12 + cC;
                    int idx5 = idx10 + idx12 + c;
                    int idx6 = idx10 + idx11 + cC;
                    int idx7 = idx9 + idx11 + c;
                    int idx8 = idx9 + idx12 + cC;
                    double A2 = a[idx1];
                    double B = a[idx2];
                    double C2 = a[idx3];
                    double D = a[idx4];
                    double E = a[idx5];
                    double F = a[idx6];
                    double G = a[idx7];
                    double H = a[idx8];
                    a[idx7] = (A2 + B + C2 - D) / 2.0;
                    a[idx3] = (E + F + G - H) / 2.0;
                    a[idx1] = (G + H + E - F) / 2.0;
                    a[idx5] = (C2 + D + A2 - B) / 2.0;
                    a[idx2] = (H + G + F - E) / 2.0;
                    a[idx6] = (D + C2 + B - A2) / 2.0;
                    a[idx8] = (B + A2 + D - C2) / 2.0;
                    a[idx4] = (F + E + H - G) / 2.0;
                }
            }
        }
    }

    private void yTransform(DoubleLargeArray a) {
        for (long s2 = 0L; s2 <= this.slicesl / 2L; ++s2) {
            long sC = (this.slicesl - s2) % this.slicesl;
            long idx9 = s2 * this.sliceStridel;
            long idx10 = sC * this.sliceStridel;
            for (long r = 0L; r <= this.rowsl / 2L; ++r) {
                long rC = (this.rowsl - r) % this.rowsl;
                long idx11 = r * this.rowStridel;
                long idx12 = rC * this.rowStridel;
                for (long c = 0L; c <= this.columnsl / 2L; ++c) {
                    long cC = (this.columnsl - c) % this.columnsl;
                    long idx1 = idx9 + idx12 + c;
                    long idx2 = idx9 + idx11 + cC;
                    long idx3 = idx10 + idx11 + c;
                    long idx4 = idx10 + idx12 + cC;
                    long idx5 = idx10 + idx12 + c;
                    long idx6 = idx10 + idx11 + cC;
                    long idx7 = idx9 + idx11 + c;
                    long idx8 = idx9 + idx12 + cC;
                    double A2 = a.getDouble(idx1);
                    double B = a.getDouble(idx2);
                    double C2 = a.getDouble(idx3);
                    double D = a.getDouble(idx4);
                    double E = a.getDouble(idx5);
                    double F = a.getDouble(idx6);
                    double G = a.getDouble(idx7);
                    double H = a.getDouble(idx8);
                    a.setDouble(idx7, (A2 + B + C2 - D) / 2.0);
                    a.setDouble(idx3, (E + F + G - H) / 2.0);
                    a.setDouble(idx1, (G + H + E - F) / 2.0);
                    a.setDouble(idx5, (C2 + D + A2 - B) / 2.0);
                    a.setDouble(idx2, (H + G + F - E) / 2.0);
                    a.setDouble(idx6, (D + C2 + B - A2) / 2.0);
                    a.setDouble(idx8, (B + A2 + D - C2) / 2.0);
                    a.setDouble(idx4, (F + E + H - G) / 2.0);
                }
            }
        }
    }

    private void yTransform(double[][][] a) {
        for (int s2 = 0; s2 <= this.slices / 2; ++s2) {
            int sC = (this.slices - s2) % this.slices;
            for (int r = 0; r <= this.rows / 2; ++r) {
                int rC = (this.rows - r) % this.rows;
                for (int c = 0; c <= this.columns / 2; ++c) {
                    int cC = (this.columns - c) % this.columns;
                    double A2 = a[s2][rC][c];
                    double B = a[s2][r][cC];
                    double C2 = a[sC][r][c];
                    double D = a[sC][rC][cC];
                    double E = a[sC][rC][c];
                    double F = a[sC][r][cC];
                    double G = a[s2][r][c];
                    double H = a[s2][rC][cC];
                    a[s2][r][c] = (A2 + B + C2 - D) / 2.0;
                    a[sC][r][c] = (E + F + G - H) / 2.0;
                    a[s2][rC][c] = (G + H + E - F) / 2.0;
                    a[sC][rC][c] = (C2 + D + A2 - B) / 2.0;
                    a[s2][r][cC] = (H + G + F - E) / 2.0;
                    a[sC][r][cC] = (D + C2 + B - A2) / 2.0;
                    a[s2][rC][cC] = (B + A2 + D - C2) / 2.0;
                    a[sC][rC][cC] = (F + E + H - G) / 2.0;
                }
            }
        }
    }
}

