/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.security;

import org.eclipse.milo.opcua.stack.core.UaException;

public enum SecurityAlgorithm {
    None("", ""),
    HmacSha1("http://www.w3.org/2000/09/xmldsig#hmac-sha1", "HmacSHA1"),
    HmacSha256("http://www.w3.org/2000/09/xmldsig#hmac-sha256", "HmacSHA256"),
    Aes128("http://www.w3.org/2001/04/xmlenc#aes128-cbc", "AES/CBC/NoPadding"),
    Aes256("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "AES/CBC/NoPadding"),
    RsaSha1("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "SHA1withRSA"),
    RsaSha256("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "SHA256withRSA"),
    RsaSha256Pss("http://opcfoundation.org/UA/security/rsa-pss-sha2-256", "SHA256withRSA/PSS"),
    Rsa15("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "RSA/ECB/PKCS1Padding"),
    RsaOaepSha1("http://www.w3.org/2001/04/xmlenc#rsa-oaep", "RSA/ECB/OAEPWithSHA-1AndMGF1Padding"),
    RsaOaepSha256("http://opcfoundation.org/UA/security/rsa-oaep-sha2-256", "RSA/ECB/OAEPWithSHA256AndMGF1Padding"),
    KwRsa15("http://www.w3.org/2001/04/xmlenc#rsa-1_5", ""),
    KwRsaOaep("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", ""),
    PSha1("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1", ""),
    PSha256("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha256", ""),
    Sha1("http://www.w3.org/2000/09/xmldsig#sha1", "SHA-1"),
    Sha256("http://www.w3.org/2001/04/xmlenc#sha256", "SHA-256");

    private final String uri;
    private final String transformation;

    private SecurityAlgorithm(String uri, String transformation) {
        this.uri = uri;
        this.transformation = transformation;
    }

    public String getUri() {
        return this.uri;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public static SecurityAlgorithm fromUri(String securityAlgorithmUri) throws UaException {
        for (SecurityAlgorithm algorithm : SecurityAlgorithm.values()) {
            if (!algorithm.getUri().equals(securityAlgorithmUri)) continue;
            return algorithm;
        }
        throw new UaException(2148728832L, "unknown securityAlgorithmUri: " + securityAlgorithmUri);
    }
}

