/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ratis.server.raftlog.segmented.LogSegment;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogCache;
import org.apache.ratis.util.AutoCloseableLock;

public interface CacheInvalidationPolicy {
    public List<LogSegment> evict(long[] var1, long var2, long var4, SegmentedRaftLogCache.LogSegmentList var6, int var7);

    public static class CacheInvalidationPolicyDefault
    implements CacheInvalidationPolicy {
        @Override
        public List<LogSegment> evict(long[] followerNextIndices, long safeEvictIndex, long lastAppliedIndex, SegmentedRaftLogCache.LogSegmentList segments, int maxCachedSegments) {
            try (AutoCloseableLock readLock = segments.readLock();){
                List<LogSegment> list = this.evictImpl(followerNextIndices, safeEvictIndex, lastAppliedIndex, segments);
                return list;
            }
        }

        private List<LogSegment> evictImpl(long[] followerNextIndices, long safeEvictIndex, long lastAppliedIndex, SegmentedRaftLogCache.LogSegmentList segments) {
            ArrayList<LogSegment> result;
            block7: {
                LogSegment s;
                int j;
                int safeIndex;
                block8: {
                    LogSegment segment;
                    int j2;
                    LogSegment segment2;
                    result = new ArrayList<LogSegment>();
                    for (safeIndex = segments.size() - 1; safeIndex >= 0 && ((segment2 = segments.get(safeIndex)).isOpen() || segment2.getEndIndex() > safeEvictIndex); --safeIndex) {
                    }
                    if (followerNextIndices != null && followerNextIndices.length != 0) break block8;
                    for (j2 = 0; j2 <= safeIndex && (segment = segments.get(j2)).getEndIndex() <= lastAppliedIndex; ++j2) {
                        if (!segment.hasCache()) continue;
                        result.add(segment);
                    }
                    if (!result.isEmpty()) break block7;
                    for (int i = safeIndex; i >= j2; --i) {
                        LogSegment s2 = segments.get(i);
                        if (s2.getStartIndex() <= lastAppliedIndex || !s2.hasCache()) continue;
                        result.add(s2);
                        break block7;
                    }
                    break block7;
                }
                Arrays.sort(followerNextIndices);
                long minToRead = Math.min(followerNextIndices[0], lastAppliedIndex);
                for (j = 0; j <= safeIndex && (s = segments.get(j)).getEndIndex() < minToRead; ++j) {
                    if (!s.hasCache()) continue;
                    result.add(s);
                }
                if (result.isEmpty()) {
                    while (j <= safeIndex) {
                        s = segments.get(j);
                        if (Arrays.stream(followerNextIndices).noneMatch(s::containsIndex) && !s.containsIndex(lastAppliedIndex) && s.hasCache()) {
                            result.add(s);
                            break;
                        }
                        ++j;
                    }
                }
            }
            return result;
        }
    }
}

