/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl.singlechild;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.AbstractSingleChildFilter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TagFilter
extends AbstractSingleChildFilter {
    private final int index;

    public TagFilter(SchemaFilter child, int index) {
        super(child);
        this.index = index;
    }

    public TagFilter(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.index = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public <C> Boolean accept(SchemaFilterVisitor<C> visitor, C node) {
        return visitor.visitTagFilter(this, node);
    }

    @Override
    public SchemaFilterType getSchemaFilterType() {
        return SchemaFilterType.TAG;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.index, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((int)this.index, (OutputStream)stream);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagFilter that = (TagFilter)o;
        return super.equals(o) && Objects.equals(this.index, that.index);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, super.hashCode());
    }
}

