/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.disk;

import java.io.File;
import java.nio.file.FileStore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.load.LoadFileException;
import org.apache.iotdb.db.storageengine.load.disk.InheritSystemMultiDisksStrategySelector;
import org.apache.iotdb.metrics.utils.FileStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinIOSelector
extends InheritSystemMultiDisksStrategySelector {
    private static final Logger logger = LoggerFactory.getLogger(MinIOSelector.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Map<String, String> rootDisks2DataDirsMapForLoad = new HashMap<String, String>(config.getTierDataDirs()[0].length);

    public MinIOSelector() {
        Arrays.stream(config.getTierDataDirs()[0]).filter(Objects::nonNull).map(v -> this.fsFactory.getFile(v, "unsequence").getPath()).forEach(dataDirPath -> {
            File dataDirFile = new File((String)dataDirPath);
            try {
                FileStore fileStore = FileStoreUtils.getFileStore((String)dataDirFile.getCanonicalPath());
                if (fileStore != null) {
                    String mountPoint = fileStore.toString();
                    this.rootDisks2DataDirsMapForLoad.put(mountPoint, (String)dataDirPath);
                    logger.info("Add {}'s mount point {}", dataDirPath, (Object)mountPoint);
                } else {
                    logger.info("Failed to find mount point {}, skip register it to map", dataDirPath);
                }
            }
            catch (Exception e) {
                logger.warn("Exception occurs when reading data dir's mount point {}", dataDirPath, (Object)e);
            }
        });
    }

    @Override
    public File getTargetFile(File fileToLoad, String databaseName, String dataRegionId, long filePartitionId, String tsfileName, int tierLevel) throws DiskSpaceInsufficientException, LoadFileException {
        String fileDirRoot = null;
        try {
            fileDirRoot = Optional.ofNullable(FileStoreUtils.getFileStore((String)fileToLoad.getCanonicalPath())).map(Object::toString).orElse(null);
        }
        catch (Exception e) {
            logger.warn("Exception occurs when reading target file's mount point {}", (Object)filePartitionId, (Object)e);
        }
        if (this.rootDisks2DataDirsMapForLoad.containsKey(fileDirRoot)) {
            File targetFile = this.fsFactory.getFile(this.rootDisks2DataDirsMapForLoad.get(fileDirRoot), databaseName + File.separatorChar + dataRegionId + File.separatorChar + filePartitionId + File.separator + tsfileName);
            return targetFile;
        }
        return super.getTargetFile(fileToLoad, databaseName, dataRegionId, filePartitionId, tsfileName, tierLevel);
    }
}

