/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.logfile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.ISerializer;

@NotThreadSafe
public class FakeCRC32Serializer<T>
implements ISerializer<T> {
    private static final byte[] PLACE_HOLDER = new byte[8];
    private static final int INITIALIZED_BUFFER_SIZE = 8192;
    private final ByteArrayOutputStream logBufferStream = new ByteArrayOutputStream(8192);
    private final ByteBuffer logLengthBuffer = ByteBuffer.allocate(4);
    private final ISerializer<T> serializer;

    public FakeCRC32Serializer(ISerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public void serialize(T t, OutputStream outputStream) throws IOException {
        this.serializer.serialize(t, this.logBufferStream);
        this.logLengthBuffer.putInt(this.logBufferStream.size());
        outputStream.write(this.logLengthBuffer.array());
        this.logBufferStream.write(PLACE_HOLDER);
        this.logBufferStream.writeTo(outputStream);
        this.logLengthBuffer.clear();
        this.logBufferStream.reset();
    }
}

