/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OrderBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Window;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WindowFrame;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class WindowSpecification
extends Node
implements Window {
    private final Optional<Identifier> existingWindowName;
    private final List<Expression> partitionBy;
    private final Optional<OrderBy> orderBy;
    private final Optional<WindowFrame> frame;

    public WindowSpecification(NodeLocation location, Optional<Identifier> existingWindowName, List<Expression> partitionBy, Optional<OrderBy> orderBy, Optional<WindowFrame> frame) {
        super(Objects.requireNonNull(location));
        this.existingWindowName = Objects.requireNonNull(existingWindowName, "existingWindowName is null");
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy is null");
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
        this.frame = Objects.requireNonNull(frame, "frame is null");
    }

    public Optional<Identifier> getExistingWindowName() {
        return this.existingWindowName;
    }

    public List<Expression> getPartitionBy() {
        return this.partitionBy;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public Optional<WindowFrame> getFrame() {
        return this.frame;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindowSpecification(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        this.existingWindowName.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        nodes.addAll(this.partitionBy);
        this.orderBy.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.frame.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowSpecification o = (WindowSpecification)obj;
        return Objects.equals(this.existingWindowName, o.existingWindowName) && Objects.equals(this.partitionBy, o.partitionBy) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.frame, o.frame);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.existingWindowName, this.partitionBy, this.orderBy, this.frame);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("existingWindowName", this.existingWindowName).add("partitionBy", this.partitionBy).add("orderBy", this.orderBy).add("frame", this.frame).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return WindowSpecification.sameClass(this, other);
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        if (this.existingWindowName.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.existingWindowName.get().serialize(byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.partitionBy.size(), (ByteBuffer)byteBuffer);
        for (Expression expression : this.partitionBy) {
            Expression.serialize(expression, byteBuffer);
        }
        if (this.orderBy.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.orderBy.get().serialize(byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        }
        if (this.frame.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.frame.get().serialize(byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        if (this.existingWindowName.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.existingWindowName.get().serialize(stream);
        } else {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.partitionBy.size(), (OutputStream)stream);
        for (Expression expression : this.partitionBy) {
            Expression.serialize(expression, stream);
        }
        if (this.orderBy.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.orderBy.get().serialize(stream);
        } else {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        }
        if (this.frame.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.frame.get().serialize(stream);
        } else {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        }
    }

    public WindowSpecification(ByteBuffer byteBuffer) {
        super(null);
        this.existingWindowName = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1 ? Optional.of(new Identifier(byteBuffer)) : Optional.empty();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.partitionBy = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            this.partitionBy.add(Expression.deserialize(byteBuffer));
        }
        this.orderBy = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1 ? Optional.of(new OrderBy(byteBuffer)) : Optional.empty();
        this.frame = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1 ? Optional.of(new WindowFrame(byteBuffer)) : Optional.empty();
    }
}

