/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnMetadata;
import org.apache.iotdb.db.queryengine.plan.relational.utils.TypeUtil;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeFactory;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ColumnSchema {
    private final String name;
    private final Type type;
    private final TsTableColumnCategory columnCategory;
    private final boolean hidden;
    private Map<String, String> props;

    public ColumnSchema(String name, Type type, boolean hidden, TsTableColumnCategory columnCategory) {
        Objects.requireNonNull(name, "name is null");
        this.name = name.toLowerCase(Locale.ENGLISH);
        this.type = type;
        this.columnCategory = columnCategory;
        this.hidden = hidden;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public TsTableColumnCategory getColumnCategory() {
        return this.columnCategory;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnSchema that = (ColumnSchema)o;
        return this.hidden == that.hidden && this.name.equals(that.name) && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.hidden);
    }

    public String toString() {
        return new StringJoiner(", ", ColumnSchema.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("type=" + this.type).add("hidden=" + this.hidden).toString();
    }

    public static void serialize(ColumnSchema columnSchema, ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)columnSchema.getName(), (ByteBuffer)byteBuffer);
        TypeUtil.serialize(columnSchema.getType(), byteBuffer);
        columnSchema.getColumnCategory().serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)columnSchema.isHidden(), (ByteBuffer)byteBuffer);
    }

    public static void serialize(ColumnSchema columnSchema, DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)columnSchema.getName(), (OutputStream)stream);
        TypeUtil.serialize(columnSchema.getType(), stream);
        columnSchema.getColumnCategory().serialize((OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)columnSchema.isHidden(), (OutputStream)stream);
    }

    public static ColumnSchema deserialize(ByteBuffer byteBuffer) {
        String name = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        Type type = TypeUtil.deserialize(byteBuffer);
        TsTableColumnCategory columnCategory = TsTableColumnCategory.deserialize((ByteBuffer)byteBuffer);
        boolean isHidden = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        return new ColumnSchema(name, type, isHidden, columnCategory);
    }

    public static ColumnSchema ofTsColumnSchema(TsTableColumnSchema schema) {
        return new ColumnSchema(schema.getColumnName(), TypeFactory.getType((TSDataType)schema.getDataType()), false, schema.getColumnCategory());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ColumnMetadata columnMetadata) {
        return new Builder(columnMetadata);
    }

    public static class Builder {
        private String name;
        private Type type;
        private TsTableColumnCategory columnCategory;
        private boolean hidden;

        private Builder() {
        }

        private Builder(ColumnMetadata columnMetadata) {
            this.name = columnMetadata.getName();
            this.type = columnMetadata.getType();
            this.hidden = columnMetadata.isHidden();
        }

        public Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name is null");
            return this;
        }

        public Builder setType(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
            return this;
        }

        public Builder setColumnCategory(TsTableColumnCategory columnCategory) {
            this.columnCategory = Objects.requireNonNull(columnCategory, "columnCategory is null");
            return this;
        }

        public Builder setHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public ColumnSchema build() {
            return new ColumnSchema(this.name, this.type, this.hidden, this.columnCategory);
        }
    }
}

