/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ActiveRegionScanMergeNode
extends MultiChildProcessNode {
    private final boolean outputCount;
    private final boolean needMerge;
    private final long estimatedSize;

    public ActiveRegionScanMergeNode(PlanNodeId id, boolean outputCount, boolean needMerge, long size) {
        super(id);
        this.estimatedSize = size;
        this.outputCount = outputCount;
        this.needMerge = needMerge;
    }

    public long getEstimatedSize() {
        return this.estimatedSize;
    }

    public boolean isOutputCount() {
        return this.outputCount;
    }

    public boolean isNeedMerge() {
        return this.needMerge;
    }

    @Override
    public PlanNode clone() {
        return new ActiveRegionScanMergeNode(this.id, this.outputCount, this.needMerge, this.estimatedSize);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.outputCount ? ColumnHeaderConstant.countDevicesColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList()) : ColumnHeaderConstant.showDevicesColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    public static ActiveRegionScanMergeNode deserialize(ByteBuffer byteBuffer) {
        boolean outputCount = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        boolean needMerge = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        long estimatedSize = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new ActiveRegionScanMergeNode(planNodeId, outputCount, needMerge, estimatedSize);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.REGION_MERGE.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.outputCount, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.needMerge, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.estimatedSize, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.REGION_MERGE.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.outputCount, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.needMerge, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.estimatedSize, (OutputStream)stream);
    }

    public String toString() {
        return "ActiveRegionScanMergeNode{outputCount=" + this.outputCount + ", needMerge=" + this.needMerge + ", id=" + this.id + '}';
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitRegionMerge(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ActiveRegionScanMergeNode that = (ActiveRegionScanMergeNode)o;
        return this.outputCount == that.outputCount && this.needMerge == that.needMerge;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.outputCount, this.needMerge);
    }
}

