/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.ir;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.ExpressionRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.ExpressionTreeRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.IrUtils;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;

public final class NormalizeOrExpressionRewriter {
    public static Expression normalizeOrExpression(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(), expression);
    }

    private NormalizeOrExpressionRewriter() {
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private Visitor() {
        }

        @Override
        public Expression rewriteLogicalExpression(LogicalExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List terms = (List)node.getTerms().stream().map(expression -> treeRewriter.rewrite(expression, context)).collect(ImmutableList.toImmutableList());
            if (node.getOperator() == LogicalExpression.Operator.AND) {
                return IrUtils.and(terms);
            }
            ImmutableList.Builder inPredicateBuilder = ImmutableList.builder();
            ImmutableSet.Builder expressionToSkipBuilder = ImmutableSet.builder();
            ImmutableList.Builder othersExpressionBuilder = ImmutableList.builder();
            this.groupComparisonAndInPredicate(terms).forEach((expression, values) -> {
                if (values.size() > 1) {
                    inPredicateBuilder.add((Object)new InPredicate((Expression)expression, this.mergeToInListExpression((Collection<Expression>)values)));
                    expressionToSkipBuilder.add(expression);
                }
            });
            ImmutableSet expressionToSkip = expressionToSkipBuilder.build();
            for (Expression expression2 : terms) {
                if (expression2 instanceof ComparisonExpression && ((ComparisonExpression)expression2).getOperator() == ComparisonExpression.Operator.EQUAL) {
                    ComparisonExpression comparisonExpression = (ComparisonExpression)expression2;
                    if (expressionToSkip.contains(comparisonExpression.getLeft())) continue;
                    othersExpressionBuilder.add((Object)expression2);
                    continue;
                }
                if (expression2 instanceof InPredicate && ((InPredicate)expression2).getValueList() instanceof InListExpression) {
                    InPredicate inPredicate = (InPredicate)expression2;
                    if (expressionToSkip.contains(inPredicate.getValue())) continue;
                    othersExpressionBuilder.add((Object)expression2);
                    continue;
                }
                othersExpressionBuilder.add((Object)expression2);
            }
            return IrUtils.or((Collection<Expression>)ImmutableList.builder().addAll((Iterable)othersExpressionBuilder.build()).addAll((Iterable)inPredicateBuilder.build()).build());
        }

        private InListExpression mergeToInListExpression(Collection<Expression> expressions) {
            LinkedHashSet<Expression> expressionValues = new LinkedHashSet<Expression>();
            for (Expression expression : expressions) {
                if (expression instanceof ComparisonExpression && ((ComparisonExpression)expression).getOperator() == ComparisonExpression.Operator.EQUAL) {
                    ComparisonExpression comparisonExpression = (ComparisonExpression)expression;
                    expressionValues.add(comparisonExpression.getRight());
                    continue;
                }
                if (expression instanceof InPredicate && ((InPredicate)expression).getValueList() instanceof InListExpression) {
                    InPredicate inPredicate = (InPredicate)expression;
                    InListExpression valueList = (InListExpression)inPredicate.getValueList();
                    expressionValues.addAll(valueList.getValues());
                    continue;
                }
                throw new IllegalStateException("Unexpected expression: " + expression);
            }
            return new InListExpression((List<Expression>)ImmutableList.copyOf(expressionValues));
        }

        private Map<Expression, Collection<Expression>> groupComparisonAndInPredicate(List<Expression> terms) {
            ImmutableMultimap.Builder expressionBuilder = ImmutableMultimap.builder();
            for (Expression expression : terms) {
                if (expression instanceof ComparisonExpression && ((ComparisonExpression)expression).getOperator() == ComparisonExpression.Operator.EQUAL) {
                    ComparisonExpression comparisonExpression = (ComparisonExpression)expression;
                    expressionBuilder.put((Object)comparisonExpression.getLeft(), (Object)comparisonExpression);
                    continue;
                }
                if (!(expression instanceof InPredicate) || !(((InPredicate)expression).getValueList() instanceof InListExpression)) continue;
                InPredicate inPredicate = (InPredicate)expression;
                expressionBuilder.put((Object)inPredicate.getValue(), (Object)inPredicate);
            }
            return expressionBuilder.build().asMap();
        }
    }
}

